/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class MOVEQ
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 28672;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n & 0xFF;
                mC68000Cpu.reg_sr &= 0xFFF0;
                if ((n2 & 0x80) == 128) {
                    n2 -= 256;
                    mC68000Cpu.reg_sr += 8;
                } else if (n2 == 0) {
                    mC68000Cpu.reg_sr += 4;
                }
                mC68000Cpu.data_regs[n >> 9 & 7] = n2;
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return MOVEQ.this.disassembleOp(n, n2);
            }
        };
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 256; ++j) {
                mC68000Cpu.addInstruction(n + (i << 9) + j, instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2) {
        DisassembledOperand disassembledOperand = new DisassembledOperand(String.format("#$%02x", n2 & 0xFF));
        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
        return new DisassembledInstruction(n, n2, "moveq", disassembledOperand, disassembledOperand2);
    }
}

