/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class PEA
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = 0;
                block0 : switch (n >> 3 & 7) {
                    case 2: {
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n2 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n2 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                                break block0;
                            }
                            case 2: {
                                n2 = mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 3: {
                                n2 = mC68000Cpu.pc_reg * 2 + this.getDisplacement(mC68000Cpu);
                            }
                        }
                    }
                }
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], n2);
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Long);
                return new DisassembledInstruction(n, n2, "pea", disassembledOperand);
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }
        };
        int n = 18496;
        for (int i = 2; i < 8; ++i) {
            if (i == 3 || i == 4) continue;
            int n2 = i << 3;
            for (int j = 0; j < 8 && !(i == 7 & j > 3); ++j) {
                mC68000Cpu.addInstruction(n + n2 + j, instruction);
            }
        }
    }
}

