/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.SUB2EA;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SUB_AnContent
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 37136;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.data_regs[n >> 9 & 7] & 0xFF;
                        if ((n3 & 0x80) != 0) {
                            n3 |= 0xFFFFFF00;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        int n4 = mC68000Cpu.readMemoryByteSigned(mC68000Cpu.addr_regs[n2]);
                        boolean bl2 = n4 < 0;
                        boolean bl3 = ((n4 -= n3) & 0x80) != 0;
                        mC68000Cpu.writeMemoryByte(mC68000Cpu.addr_regs[n2], n4);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if ((n4 & 0xFF) == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_AnContent.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 37200;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.data_regs[n >> 9 & 7] & 0xFFFF;
                        if ((n3 & 0x8000) != 0) {
                            n3 |= 0xFFFF0000;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        int n4 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n2]);
                        boolean bl2 = n4 < 0;
                        boolean bl3 = ((n4 -= n3) & 0x8000) != 0;
                        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[n2], n4);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if ((n4 & 0xFFFF) == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_AnContent.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 37264;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.data_regs[n >> 9 & 7];
                        boolean bl = n3 < 0;
                        int n4 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        boolean bl2 = n4 < 0;
                        boolean bl3 = (n4 -= n3) < 0;
                        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[n2], n4);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_AnContent.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (j << 9) + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 >> 9 & 7));
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "SUB" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

