/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SUBI
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 1024;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = mC68000Cpu.readMemoryWordPCInc() & 0xFF;
                        int n3 = 0;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if ((n2 & 0x80) != 0) {
                            n2 |= 0xFFFFFF00;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                boolean bl2;
                                int n4 = n & 7;
                                int n5 = mC68000Cpu.data_regs[n4];
                                int n6 = n5 & 0xFF;
                                if ((n6 & 0x80) != 0) {
                                    n6 |= 0xFFFFFF00;
                                    bl2 = true;
                                } else {
                                    bl2 = false;
                                }
                                boolean bl3 = ((n6 -= n2) & 0x80) != 0;
                                n5 &= 0xFFFFFF00;
                                mC68000Cpu.data_regs[n4] = n5 |= n6 & 0xFF;
                                n2 = 0;
                                if (n6 == 0) {
                                    n2 |= 4;
                                } else if (bl3) {
                                    n2 |= 8;
                                }
                                if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                                    n2 |= 2;
                                }
                                if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                                    n2 |= 0x11;
                                }
                                mC68000Cpu.reg_sr |= n2;
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n7 = n & 7;
                                n3 = mC68000Cpu.addr_regs[n7];
                                if (n7 == 7) {
                                    int n8 = n7;
                                    mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 2;
                                    break;
                                }
                                int n9 = n7;
                                mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] + 1;
                                break;
                            }
                            case 4: {
                                int n10 = n & 7;
                                if (n10 == 7) {
                                    int n11 = n10;
                                    mC68000Cpu.addr_regs[n11] = mC68000Cpu.addr_regs[n11] - 2;
                                } else {
                                    int n12 = n10;
                                    mC68000Cpu.addr_regs[n12] = mC68000Cpu.addr_regs[n12] - 1;
                                }
                                n3 = mC68000Cpu.addr_regs[n10];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = SUBI.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n13 = mC68000Cpu.readMemoryByteSigned(n3);
                        boolean bl4 = n13 < 0;
                        boolean bl5 = ((n13 -= n2) & 0x80) != 0;
                        n2 = 0;
                        mC68000Cpu.writeMemoryByte(n3, n13);
                        if (n13 == 0) {
                            n2 += 4;
                        } else if (bl5) {
                            n2 += 8;
                        }
                        if (!bl && bl4 && !bl5 || bl && !bl4 && bl5) {
                            n2 += 2;
                        }
                        if (bl && !bl4 || bl5 && !bl4 || bl && bl5) {
                            n2 += 17;
                        }
                        mC68000Cpu.reg_sr |= n2;
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBI.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 1088;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n3 = 0;
                        boolean bl = n2 < 0;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                boolean bl2;
                                int n4 = n & 7;
                                int n5 = mC68000Cpu.data_regs[n4];
                                int n6 = n5 & 0xFFFF;
                                if ((n6 & 0x8000) != 0) {
                                    n6 |= 0xFFFF0000;
                                    bl2 = true;
                                } else {
                                    bl2 = false;
                                }
                                boolean bl3 = ((n6 -= n2) & 0x8000) != 0;
                                n5 &= 0xFFFF0000;
                                mC68000Cpu.data_regs[n4] = n5 |= n6 & 0xFFFF;
                                n2 = 0;
                                if (n6 == 0) {
                                    n2 += 4;
                                } else if (bl3) {
                                    n2 += 8;
                                }
                                if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                                    n2 += 2;
                                }
                                if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                                    n2 += 17;
                                }
                                mC68000Cpu.reg_sr |= n2;
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n7 = n & 7;
                                n3 = mC68000Cpu.addr_regs[n7];
                                int n8 = n7;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 2;
                                break;
                            }
                            case 4: {
                                int n9;
                                int n10 = n9 = n & 7;
                                mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 2;
                                n3 = mC68000Cpu.addr_regs[n9];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = SUBI.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n11 = mC68000Cpu.readMemoryWordSigned(n3);
                        boolean bl4 = n11 < 0;
                        boolean bl5 = ((n11 -= n2) & 0x8000) != 0;
                        n2 = 0;
                        mC68000Cpu.writeMemoryWord(n3, n11);
                        if (n11 == 0) {
                            n2 += 4;
                        } else if (bl5) {
                            n2 += 8;
                        }
                        if (!bl && bl4 && !bl5 || bl && !bl4 && bl5) {
                            n2 += 2;
                        }
                        if (bl && !bl4 || bl5 && !bl4 || bl && bl5) {
                            n2 += 17;
                        }
                        mC68000Cpu.reg_sr |= n2;
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBI.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 1152;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n3 = 0;
                        boolean bl = n2 < 0;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4 = mC68000Cpu.data_regs[n & 7];
                                boolean bl2 = n4 < 0;
                                boolean bl3 = (n4 -= n2) < 0;
                                mC68000Cpu.data_regs[n & 7] = n4;
                                mC68000Cpu.reg_sr &= 0xFFE0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr += 4;
                                } else if (bl3) {
                                    mC68000Cpu.reg_sr += 8;
                                }
                                if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                                    mC68000Cpu.reg_sr += 2;
                                }
                                if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                                    mC68000Cpu.reg_sr += 17;
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n5 = n & 7;
                                n3 = mC68000Cpu.addr_regs[n5];
                                int n6 = n5;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 4;
                                break;
                            }
                            case 4: {
                                int n7;
                                int n8 = n7 = n & 7;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] - 4;
                                n3 = mC68000Cpu.addr_regs[n7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = SUBI.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n9 = mC68000Cpu.readMemoryLong(n3);
                        boolean bl4 = n9 < 0;
                        boolean bl5 = (n9 -= n2) < 0;
                        mC68000Cpu.writeMemoryLong(n3, n9);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n9 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl5) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl && bl4 && !bl5 || bl && !bl4 && bl5) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl4 || bl5 && !bl4 || bl && bl5) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBI.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n2 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 1); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        int n3;
        String string;
        int n4;
        switch (size) {
            case Byte: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                string = String.format("#$%02x", n4 & 0xFF);
                n3 = 2;
                break;
            }
            case Word: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                string = String.format("#$%04x", n4);
                n3 = 2;
                break;
            }
            case Long: {
                n4 = mC68000Cpu.readMemoryLong(n + 2);
                string = String.format("#$%08x", n4);
                n3 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Size unsized for SUBI");
            }
        }
        DisassembledOperand disassembledOperand = new DisassembledOperand(string, n3, n4);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + n3, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "subi" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

