/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.SUBQ;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SUBQ_Dn
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 20736;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2;
                        int n3 = n & 7;
                        int n4 = n >> 9 & 7;
                        if (n4 == 0) {
                            n4 = 8;
                        }
                        if (((n2 = mC68000Cpu.data_regs[n3] & 0xFF) & 0x80) != 0) {
                            n2 |= 0xFFFFFF00;
                        }
                        int n5 = n2 - n4;
                        int n6 = n3;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFFFF00;
                        int n7 = n3;
                        mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | n5 & 0xFF;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = (n2 & 0x80) != 0;
                        boolean bl4 = bl = (n5 & 0x80) != 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_Dn.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 20800;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2;
                        int n3 = n & 7;
                        int n4 = n >> 9 & 7;
                        if (n4 == 0) {
                            n4 = 8;
                        }
                        if (((n2 = mC68000Cpu.data_regs[n3] & 0xFFFF) & 0x8000) != 0) {
                            n2 |= 0xFFFF0000;
                        }
                        int n5 = n2 - n4;
                        int n6 = n3;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFF0000;
                        int n7 = n3;
                        mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | n5 & 0xFFFF;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = (n2 & 0x8000) != 0;
                        boolean bl4 = bl = (n5 & 0x8000) != 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_Dn.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 20864;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = n >> 9 & 7;
                        if (n3 == 0) {
                            n3 = 8;
                        }
                        int n4 = mC68000Cpu.data_regs[n2];
                        mC68000Cpu.data_regs[n2] = n4 - n3;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = n4 < 0;
                        boolean bl4 = bl = mC68000Cpu.data_regs[n2] < 0;
                        if (mC68000Cpu.data_regs[n2] == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_Dn.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (k << 9) + j, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("#" + (n2 >> 9 & 7));
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "subq" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

