/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.SUBQ;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SUBQ_L
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 20793;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        if (n2 == 0) {
                            n2 = 8;
                        }
                        int n3 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n4 = mC68000Cpu.readMemoryByteSigned(n3);
                        int n5 = n4 - n2;
                        mC68000Cpu.writeMemoryByte(n3, n5);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = (n4 & 0x80) != 0;
                        boolean bl4 = bl = (n5 & 0x80) != 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_L.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 20857;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        if (n2 == 0) {
                            n2 = 8;
                        }
                        int n3 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n4 = mC68000Cpu.readMemoryWordSigned(n3);
                        int n5 = n4 - n2;
                        mC68000Cpu.writeMemoryWord(n3, n5);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = (n4 & 0x8000) != 0;
                        boolean bl4 = bl = (n5 & 0x8000) != 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_L.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 20921;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        if (n2 == 0) {
                            n2 = 8;
                        }
                        int n3 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n4 = mC68000Cpu.readMemoryLong(n3);
                        int n5 = n4 - n2;
                        mC68000Cpu.writeMemoryLong(n3, n5);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        boolean bl2 = false;
                        boolean bl3 = n4 < 0;
                        boolean bl4 = bl = n5 < 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUBQ_L.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + (j << 9), instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("#" + (n2 >> 9 & 7));
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "subq" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

