/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class SWAP
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 18496;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n & 7;
                int n3 = mC68000Cpu.data_regs[n2];
                int n4 = n2;
                mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] << 16;
                int n5 = n2;
                mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] | (n3 >>>= 16);
                mC68000Cpu.reg_sr &= 0xFFF0;
                if (mC68000Cpu.data_regs[n2] < 0) {
                    mC68000Cpu.reg_sr |= 8;
                } else if (mC68000Cpu.data_regs[n2] == 0) {
                    mC68000Cpu.reg_sr |= 4;
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return new DisassembledInstruction(n, n2, "swap", new DisassembledOperand("d" + (n2 & 7)));
            }
        };
        for (int i = 0; i < 8; ++i) {
            mC68000Cpu.addInstruction(n + i, instruction);
        }
    }
}

