/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.io.FileNotFoundException;
import java.net.ProtocolException;
import smsqmulator.DeviceDriver;
import smsqmulator.DoNothingException;
import smsqmulator.Helper;
import smsqmulator.IncorrectFiletypeException;
import smsqmulator.Localization;
import smsqmulator.MemDrive;
import smsqmulator.Warnings;
import smsqmulator.WinDriver;
import smsqmulator.cpu.MC68000Cpu;

public class MemDriver
extends WinDriver
implements DeviceDriver {
    public MemDriver(MC68000Cpu mC68000Cpu, Warnings warnings) {
        super(mC68000Cpu, warnings);
        this.deviceID = 1296387376;
        this.drives = new MemDrive[8];
    }

    @Override
    public boolean formatMedium(String string, IniFile iniFile) {
        this.cpu.data_regs[0] = -14;
        return false;
    }

    @Override
    public boolean setNames(String[] stringArray, IniFile iniFile, boolean bl, boolean bl2) {
        if (stringArray.length == 8) {
            int n;
            if (iniFile.getTrueOrFalse("DISABLE-MEM-DEVICE")) {
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < 8; ++n) {
                if (this.nativeDir[n] == null || this.nativeDir[n].isEmpty()) continue;
                if (bl || stringArray[n] == null || stringArray[n].isEmpty()) {
                    if (this.drives[n] == null) continue;
                    this.drives[n].unuse();
                    this.drives[n] = null;
                    continue;
                }
                if (this.nativeDir[n].toLowerCase().equals(stringArray[n].toLowerCase()) || this.drives[n] == null) continue;
                this.drives[n].unuse();
                this.drives[n] = null;
            }
            this.nativeDir = (String[])stringArray.clone();
            for (n = 0; n < 8; ++n) {
                try {
                    if (this.nativeDir[n] == null || this.nativeDir[n].isEmpty()) continue;
                    if (this.drives[n] != null) {
                        if (!this.nativeDir[n].equals(this.drives[n].getDrivename())) {
                            this.drives[n].unuse();
                            this.drives[n] = new MemDrive(this.cpu, this.nativeDir[n], this, n + 49, this.warnings);
                        }
                    } else {
                        this.drives[n] = new MemDrive(this.cpu, this.nativeDir[n], this, n + 49, this.warnings);
                    }
                    if (!this.drives[n].isReadOnly() || !this.warnings.warnIfQXLDriveIsReadOnly) continue;
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[105]).append("\n");
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.warnings.warnIfNonexistingQXLDrive) {
                        stringBuilder.append(this.nativeDir[n]).append("\n");
                        stringBuilder.append(Localization.Texts[64]).append("\n");
                    }
                    this.drives[n] = null;
                    continue;
                }
                catch (ProtocolException protocolException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(protocolException.getMessage()).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[65]).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (DoNothingException doNothingException) {
                    this.drives[n] = null;
                    continue;
                }
                catch (IncorrectFiletypeException incorrectFiletypeException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[111]).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(exception.getMessage()).append("\n");
                    this.drives[n] = null;
                }
            }
            if (stringBuilder.length() != 0 && !bl2) {
                Helper.reportError(Localization.Texts[45], Localization.Texts[49] + "\n" + stringBuilder.toString(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeBack(int n) {
        if (this.drives[n] != null) {
            MemDrive memDrive = (MemDrive)this.drives[n];
            memDrive.writeBack(this.nativeDir[n]);
        } else {
            this.cpu.data_regs[0] = -7;
        }
    }
}

