/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import com.apple.eawt.Application;
import inifile.IniFile;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.Monitor;
import smsqmulator.MonitorGui;
import smsqmulator.SampledSound;
import smsqmulator.Screen;
import smsqmulator.Screen0;
import smsqmulator.Screen16;
import smsqmulator.Screen32;
import smsqmulator.SoundDevice;
import smsqmulator.Warnings;
import smsqmulator.cpu.CPUforScreenEmulation;
import smsqmulator.cpu.MC68000Cpu;

public class SMSQmulator {
    private MC68000Cpu cpu;
    private Screen screen;

    public SMSQmulator(int n, boolean bl, boolean bl2, String string) {
        boolean bl3;
        GraphicsEnvironment graphicsEnvironment;
        GraphicsDevice[] graphicsDeviceArray;
        int n2;
        int n3;
        String string2;
        Object object;
        String string3;
        String string4 = System.getProperty("user.dir") + File.separator;
        try {
            string3 = SMSQmulator.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            object = URLDecoder.decode(string3, "UTF-8");
            File file = new File((String)object);
            string2 = file.getAbsoluteFile().getParent() + File.separator;
        }
        catch (Exception exception) {
            string2 = System.getProperty("user.home") + File.separator;
        }
        string3 = null;
        if (string != null && !string.isEmpty()) {
            object = new File(string);
            if (!((File)object).exists()) {
                Helper.reportError("Error", "The ini file '" + string + "' doesn't exist!", null);
            } else {
                string3 = ((File)object).getAbsoluteFile().getParent() + File.separator;
                string = ((File)object).getName();
            }
        }
        if (string3 == null) {
            string3 = string4;
            string = "SMSQmulator.ini";
            object = new File(string3 + string);
            if (!((File)object).exists()) {
                string3 = null;
            }
        }
        if (string3 == null && !((File)(object = new File((string3 = string2) + string))).exists()) {
            string3 = null;
        }
        if (string3 == null) {
            string3 = System.getProperty("user.home") + File.separator;
        }
        this.setLaF();
        object = new IniFile();
        SMSQmulator.presetOptions((IniFile)object, string2 + "SMSQE");
        ((IniFile)object).setFilename(string3 + string);
        try {
            ((IniFile)object).readIniFile();
        }
        catch (Exception exception) {
            try {
                ((IniFile)object).addOption("WIN1", string4 + "SMSQmulator.win", "Directory name for WIN1_ drive");
                ((IniFile)object).writeIniFile();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        ((IniFile)object).addOption("EXPANDED_DIR", string3, "./ will be expanded to this - do not modify, will be overwritten!");
        int n4 = ((IniFile)object).getOptionAsInt("WDW_XSIZE", 512);
        int n5 = ((IniFile)object).getOptionAsInt("WDW_YSIZE", 256);
        if (n4 < 512) {
            n4 = 512;
        }
        if (n5 < 256) {
            n5 = 256;
        }
        n4 += n4 % 8 == 0 ? 0 : 8 - n4 % 8;
        int n6 = ((IniFile)object).getOptionAsInt("WINDOW-MODE", 0);
        if (n6 > 2 || n6 < 0) {
            n6 = 0;
        }
        if ((n3 = ((IniFile)object).getOptionAsInt("SCREEN-NUMBER", 0)) > (n2 = (graphicsDeviceArray = (graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment()).getScreenDevices()).length)) {
            n3 = 0;
        }
        GraphicsDevice graphicsDevice = graphicsDeviceArray[n3];
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        if (n6 > 0) {
            n4 = rectangle.width;
            n5 = rectangle.height;
            if (n6 == 2 && ((IniFile)object).getTrueOrFalse("DOUBLE-SIZE")) {
                n4 /= 2;
                n5 /= 2;
            }
        }
        int n7 = ((IniFile)object).getOptionAsInt("MEM_SIZE", 1);
        switch (((IniFile)object).getOptionAsInt("SCREEN-MODE", 0)) {
            case 2: {
                this.screen = new Screen16(n4, n5, 0, ((IniFile)object).getTrueOrFalse("VIBRANT-COLOURS"), null, false);
                if (n7 >= 8) break;
                n7 = 8;
                break;
            }
            case 3: {
                this.screen = new Screen32(n4, n5, 0, ((IniFile)object).getTrueOrFalse("VIBRANT-COLOURS"), null, false);
                if (n7 >= 8) break;
                n7 = 8;
                break;
            }
            default: {
                this.screen = n4 == 512 && n5 == 256 ? new Screen0(n4, n5, 0, null, false) : new Screen0(n4, n5, 0, null, false);
            }
        }
        int n8 = ((IniFile)object).getOptionAsInt("LANGUAGE", 0);
        Localization localization = new Localization(n8);
        Warnings warnings = new Warnings();
        warnings.setWarnings((IniFile)object);
        this.cpu = ((IniFile)object).getTrueOrFalse("QL-SCREEN-EMULATION") ? new CPUforScreenEmulation(n7 * 1024 * 1024, this.screen, (IniFile)object, 350000) : new MC68000Cpu(n7 * 1024 * 1024, this.screen, (IniFile)object, 350000);
        String string5 = ((IniFile)object).getOptionValue("SSSS-FREQUENCY");
        SampledSound sampledSound = new SampledSound(this.cpu, ((IniFile)object).getOptionAsInt("SOUND-VOLUME", 50), warnings, string5);
        SoundDevice soundDevice = new SoundDevice(sampledSound);
        MonitorGui monitorGui = null;
        if (bl && !bl2) {
            bl3 = ((IniFile)object).getTrueOrFalse("FAST-MODE");
            Monitor monitor = new Monitor(this.cpu, false, false, sampledSound, null, null, bl3, warnings, ((IniFile)object).getOptionAsInt("THROTTLE", 0), ((IniFile)object).getOptionAsInt("TIME-OFFSET", 0), null, ((IniFile)object).getOptionAsInt("SOUND-VOLUME", 50), soundDevice, (IniFile)object);
            this.screen.setMonitor(monitor);
        } else {
            monitorGui = new MonitorGui(this.screen, (IniFile)object, warnings, n, ((IniFile)object).getTrueOrFalse("VIBRANT-COLOURS"), bl, n6, graphicsConfiguration, graphicsDeviceArray, n3);
            bl3 = true;
            boolean bl4 = false;
            boolean bl5 = ((IniFile)object).getTrueOrFalse("FAST-MODE");
            Monitor monitor = new Monitor(this.cpu, bl3, bl4, sampledSound, monitorGui.getRegLogger(), monitorGui.getDataLogger(), bl5, warnings, ((IniFile)object).getOptionAsInt("THROTTLE", 0), ((IniFile)object).getOptionAsInt("TIME-OFFSET", 0), monitorGui, ((IniFile)object).getOptionAsInt("SOUND-VOLUME", 50), soundDevice, (IniFile)object);
            monitor.setInputWindow(monitorGui.getInputWindow());
            monitorGui.setMonitor(monitor, false);
            monitorGui.getRegLogger().append("Use the small window below to type your commands.\nType 'h' for help.\n");
        }
        if (monitorGui != null) {
            String string6 = ((IniFile)object).getOptionValue("ROM_IMAGE_FILE");
            if (string6 != null && !string6.isEmpty()) {
                monitorGui.setRomfile(string6);
            }
            monitorGui.setVisible(true);
        }
    }

    public static void main(final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream inputStream = SMSQmulator.class.getResourceAsStream("SMSQmulator.class");
                int n = 0;
                try {
                    byte[] byArray = new byte[8];
                    inputStream.read(byArray);
                    n = (byArray[7] & 0xFF) - 44;
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (stringArray.length != 0) {
                    new SMSQmulator(n, false, false, stringArray[0]);
                } else {
                    new SMSQmulator(n, false, false, null);
                }
            }
        });
    }

    public static final void presetOptions(IniFile iniFile, String string) {
        String[] stringArray = new String[]{"NFA1", "", "Directory name for NFA1_ drive", "NFA2", "", "", "NFA3", "", "", "NFA4", "", "", "NFA5", "", "", "NFA6", "", "", "NFA7", "", "", "NFA8", "", "", "NFA_USE", "", "", "SFA1", "", "Directory name for SFA1_ drive", "SFA2", "", "", "SFA3", "", "", "SFA4", "", "", "SFA5", "", "", "SFA6", "", "", "SFA7", "", "", "SFA8", "", "", "SFA_USE", "", "", "WIN1", "", "File name for WIN1_ drive", "WIN2", "", "", "WIN3", "", "", "WIN4", "", "", "WIN5", "", "", "WIN6", "", "", "WIN7", "", "", "WIN8", "", "", "WIN_USE", "", "", "MEM1", "", "File name for MEM1_ drive", "MEM2", "", "", "MEM3", "", "", "MEM4", "", "", "MEM5", "", "", "MEM6", "", "", "MEM7", "", "", "MEM8", "", "", "MEM_USE", "", "", "FLP1", "", "File name for FLP1_ drive", "FLP2", "", "", "FLP3", "", "", "FLP4", "", "", "FLP5", "", "", "FLP6", "", "", "FLP7", "", "", "FLP8", "", "", "FLP_USE", "", "", "DISABLE-WIN-DEVICE", "0", "Disable the WIN device (0 = no, 1 = yes)", "DISABLE-NFA-DEVICE", "0", "Disable the NFA device (0 = no, 1 = yes)", "DISABLE-SFA-DEVICE", "0", "Disable the SFA device (0 = no, 1 = yes)", "DISABLE-FLP-DEVICE", "0", "Disable the FLP device (0 = no, 1 = yes)", "DISABLE-MEM-DEVICE", "1", "Disable the MEM device (0 = no, 1 = yes)", "WDW_XSIZE", "512", "X size of window: min size = 512", "WDW_YSIZE", "256", "Y size of window: min size = 256", "ROM_IMAGE_FILE", "", "File containing the SMSQE code", "NFA-FILENAME-CHANGE", "", "Change case of files on NFA devices (0: no change 1:upper case 2:lower case)", "SFA-FILENAME-CHANGE", "", "Change case of file names on SFA devices (0: no change 1:upper case 2:lower case)", "MEM_SIZE", "8", "Size of memory in MiB", "SCREEN-MODE", "3", "Screen colour mode (0 = QL mode, 2 = Aurora 8 bit colour mode, 3 = 16 bit colour mode)", "MONITOR-VISIBLE", "0", "Is the debugging monitor panel visible? (0 = no;  1 = yes)", "DIVIDER-LOCATION", "200", "X location of debugging monitor windows divider", "FAST-MODE", "1", "Start emulation in fast mode? (0 = no, 1 = yes)", "LANGUAGE", "2", "Language to be used by the emulator (NOT SMSQ/E) (1-DE  2-UK/US  3-ES  4-FR  5-IT)", "WARN-ON-NONSTANDARD-WINDRIVE", "1", "Warn if a WIN drive has a non standard drive map (0 = no, 1 = yes)", "WARN-ON-NONEXISTING-WINDRIVE", "1", "Warn if a WIN drive file doesn't exist (0 = no, 1 = yes)", "WARN-ON-WINDRIVE-FULL", "0", "Warn when a WIN drive is full (0 = no, 1 = yes)", "TIME-OFFSET", "0", "Number of seconds the date is off (+ or -, 1 hour = 3600 secs)", "DOUBLE-SIZE", "0", "Double the size of SMSQ/E pixels? (0 = no, 1 = yes)", "MENUBAR-VISIBLE", "1", "Menu bar is visible (1 = yes, 0 = no)", "WARN-ON-WINDRIVE-READ-ONLY", "1", "Warn when a WIN drive is read only (0 = no, 1 = yes)", "WDW-XPOS", "0", "Window x position on screen", "WDW-YPOS", "0", "Window y position on screen", "VIBRANT-COLOURS", "0", "(Try to) use more vibrant colours (0 = no, 1 = yes)", "SUSPEND-WHEN-ICONIFIED", "1", "Suspend execution when window is iconified? (0 = no, 1 = yes)", "SOUND-VOLUME", "50", "Sound volume from 0 (no sound) to 100 (loudest)", "WARN-ON-SOUND-PROBLEM", "1", "Warn if sound can't be correctly initialised (0 = no, 1 = yes)", "WARN-ON-NONEXISTING-FLPDRIVE", "1", "Warn if any floppy image file can't be opened (0 = no, 1 = yes)", "LESS-CPU-WHEN-IDLE", "1", "Use less CPU time when idle (0 = no, 1 = yes)", "WARN-ON-FLPDRIVE-READ-ONLY", "1", "Warn if an flp drive is read only (0 = no, 1 = yes)", "IGNORE-QXLWIN-LOCK-ERROR", "0", "Ignore error if qxl.win files can't be locked (0 = no, 1 = yes)", "MOUSE-CLICK-DELAY", "0", "Delay after mouse click before mouse button can be released, in milliseconds", "SCREEN-UPDATE-RATE", "50", "Frequency at which screen is updated in milliseconds", "WINDOW-MODE", "0", "SMSQmulator window mode 0 (=window, 1 = full size, 2 = special full size)", "SCREEN-NUMBER", "0", "Number of screen to be used in multi-monitor environment", "QL-SCREEN-EMULATION", "0", "Allow QL screen emulation (warning: may result in performance penalty)? (0 = no, 1 = yes)", "SSSS-FREQUENCY", "22.05", "SSSS frequency in Khz, allowed are 20 and 22.05 only, default 22.05", "MAKE-UNLOCKABLE-QXLWIN-READONLY", "0", "When ignoring file lock errors, make an unlockable file read only", "POPUP-ACTION", "1", "Action after JVA_POPUP : 0 = open wdw, 1 = blink taskbar entry", "MOUSEWHEEL-ACCEL", "1", "Speed of mouse scroll wheel (1 - 9 = normal to fast)", "EXPANDED_DIR", "", "./ will be expanded to this - do not modify, will be overwritten!"};
        for (int i = 0; i < stringArray.length; i += 3) {
            iniFile.addOption(stringArray[i + 0], stringArray[i + 1], stringArray[i + 2]);
        }
        iniFile.addOption("ROM_IMAGE_FILE", string, "File containing the SMSQE code");
    }

    private void setLaF() {
        block9: {
            try {
                boolean bl = true;
                String string = System.getProperty("os.name").toLowerCase();
                if (string.toLowerCase().contains("mac")) {
                    Application application = Application.getApplication();
                    URL uRL = MonitorGui.class.getResource("images/WolfSoft2.gif");
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read(uRL);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    application.setDockIconImage(bufferedImage);
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                    System.setProperty("apple.awt.brushMetalLook", "true");
                    break block9;
                }
                if (string.equals("windows")) break block9;
                bl = false;
                Font font = new Font("Verdana", 0, 11);
                UIManager.put("DefaultFont", font);
                UIManager.put("defaultFont", font);
                UIManager.put("ArrowButton.font", font);
                UIManager.put("Button.font", font);
                UIManager.put("CheckBox.font", font);
                UIManager.put("CheckBoxMenuItem.font", font);
                UIManager.put("ColorChooser.font", font);
                UIManager.put("ComboBox.font", font);
                UIManager.put("DesktopIcon.font", font);
                UIManager.put("DesktopPane.font", font);
                UIManager.put("EditorPane.font", font);
                UIManager.put("FileChooser.font", font);
                UIManager.put("FormattedTextField.font", font);
                UIManager.put("InternalFrame.font", font);
                UIManager.put("InternalFrame.titlefont", font);
                UIManager.put("InternalFrameTitlePane.font", font);
                UIManager.put("Label.font", font);
                UIManager.put("List.font", font);
                UIManager.put("Menu.font", font);
                UIManager.put("MenuBar.font", font);
                UIManager.put("MenuItem.font", font);
                UIManager.put("OptionPane.font", font);
                UIManager.put("Panel.font", font);
                UIManager.put("PasswordField.font", font);
                UIManager.put("PopupMenu.font", font);
                UIManager.put("PopupMenuSeparator.font", font);
                UIManager.put("ProgressBar.font", font);
                UIManager.put("RadioButton.font", font);
                UIManager.put("RadioButtonMenuItem.font", font);
                UIManager.put("RootPane.font", font);
                UIManager.put("ScrollBar.font", font);
                UIManager.put("ScrollBarThumb.font", font);
                UIManager.put("ScrollBarTrack.font", font);
                UIManager.put("ScrollPane.font", font);
                UIManager.put("Saparator.font", font);
                UIManager.put("Spinner.font", font);
                UIManager.put("SplitPane.font", font);
                UIManager.put("Slider.font", font);
                UIManager.put("SliderThumb.font", font);
                UIManager.put("SliderTrack.font", font);
                UIManager.put("Table.font", font);
                UIManager.put("TableHeader.font", font);
                UIManager.put("TabbedPane.font", font);
                UIManager.put("TextArea.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("TextPane.font", font);
                UIManager.put("TitledBorder.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("ToolBar.font", font);
                UIManager.put("ToolTip.font", font);
                UIManager.put("Tree.font", font);
                UIManager.put("Viewport.font", font);
                string = "Nimbus";
                for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                    if (!string.equals(lookAndFeelInfo.getName())) continue;
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    break;
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Oops, Look and feel inexistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Oops, classe inconnue (?)!!!");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Oops, classe non construite!!!");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Oops, erreur inconnue (?)!!!");
            }
        }
    }
}

