/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.awt.Robot;
import java.io.File;
import java.util.HashMap;
import smsqmulator.Arith;
import smsqmulator.Beep;
import smsqmulator.ClipboardXfer;
import smsqmulator.DeviceDriver;
import smsqmulator.FloppyDriver;
import smsqmulator.Helper;
import smsqmulator.IPHandler;
import smsqmulator.Localization;
import smsqmulator.Monitor;
import smsqmulator.MonitorGui;
import smsqmulator.SampledSound;
import smsqmulator.Screen;
import smsqmulator.SoundDevice;
import smsqmulator.Types;
import smsqmulator.WinDrive;
import smsqmulator.cpu.CPUforScreenEmulation;
import smsqmulator.cpu.MC68000Cpu;

public class TrapDispatcher {
    private final SampledSound sam;
    private final Beep beep;
    private boolean throttleStop = false;
    private ClipboardXfer cxfer = null;
    private final MonitorGui gui;
    private int xLoc;
    private int yLoc;
    private Robot robot = null;
    private final SoundDevice sound;
    private IniFile inifile;
    private long currentClock;
    private long lastTime;
    private FloppyDriver floppy;
    private final IPHandler ipHandler;
    private Arith arithpkg = new Arith();
    private final HashMap<Integer, DeviceDriver> devicesMap = new HashMap();
    private volatile int schedCounter = 0;

    public TrapDispatcher(SampledSound sampledSound, int n, MonitorGui monitorGui, int n2, SoundDevice soundDevice, IniFile iniFile, IPHandler iPHandler) {
        this.sam = sampledSound;
        this.beep = new Beep(n2);
        this.sound = soundDevice;
        this.gui = monitorGui;
        this.inifile = iniFile;
        this.ipHandler = iPHandler;
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(0);
            this.robot.setAutoWaitForIdle(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispatchTrap(int n, MC68000Cpu mC68000Cpu) {
        if ((n = -n) > 43775) {
            this.arithpkg.handleOp(mC68000Cpu, n - 43776);
            return;
        }
        int n2 = mC68000Cpu.data_regs[0];
        block1 : switch (n) {
            case 40963: {
                if (n2 < 0 || n2 > 79 || n2 > 7 && n2 < 64) {
                    mC68000Cpu.data_regs[0] = -15;
                    break;
                }
                DeviceDriver deviceDriver = this.devicesMap.get(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[3] + 62));
                if (deviceDriver == null) {
                    mC68000Cpu.data_regs[0] = -19;
                    break;
                }
                int n3 = mC68000Cpu.addr_regs[0];
                deviceDriver.trap3OK(mC68000Cpu.readMemoryByte(n3 + 93), n2, n3, mC68000Cpu.readMemoryWord(n3 + 30));
                break;
            }
            case 40962: {
                int n4 = mC68000Cpu.addr_regs[0];
                switch (n2) {
                    case 1: {
                        int n5;
                        int n6 = mC68000Cpu.readMemoryWord(n4 + 50);
                        if (mC68000Cpu.readMemoryByte(n4 + 51 + n6) == Types.UNDERSCORE) {
                            --n6;
                        }
                        byte[] byArray = new byte[n6];
                        byte[] byArray2 = new byte[n6];
                        for (n5 = 0; n5 < n6; ++n5) {
                            byArray[n5] = (byte)mC68000Cpu.readMemoryByte(n4 + 52 + n5);
                            byArray2[n5] = WinDrive.LOWER_CASE[byArray[n5] & 0xFF];
                        }
                        n5 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[1] + 20) - 1;
                        int n7 = mC68000Cpu.readMemoryByte(n4 + 28);
                        int n8 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[3] + 62);
                        DeviceDriver deviceDriver = this.devicesMap.get(n8);
                        if (deviceDriver == null) {
                            mC68000Cpu.data_regs[0] = -7;
                            break block1;
                        }
                        if (!deviceDriver.openFile(mC68000Cpu.addr_regs[3], n4, n7, n5, byArray, byArray2)) break block1;
                        mC68000Cpu.writeMemoryByte(n4 + 46, 255);
                        mC68000Cpu.writeMemoryByte(n4 + 93, n5);
                        break block1;
                    }
                    case 2: {
                        DeviceDriver deviceDriver = this.devicesMap.get(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[3] + 62));
                        if (deviceDriver == null) {
                            mC68000Cpu.data_regs[0] = -6;
                            break block1;
                        }
                        deviceDriver.closeFile(mC68000Cpu.readMemoryByte(n4 + 93), mC68000Cpu.readMemoryWord(n4 + 30));
                        break block1;
                    }
                    case 3: {
                        String string = mC68000Cpu.readSmsqeString(mC68000Cpu.addr_regs[1]);
                        if (string.length() < 6) {
                            mC68000Cpu.data_regs[0] = -15;
                            break block1;
                        }
                        DeviceDriver deviceDriver = this.devicesMap.get(Helper.convertUsageName(string.substring(0, 3)));
                        if (deviceDriver == null) {
                            mC68000Cpu.data_regs[0] = -7;
                            break block1;
                        }
                        deviceDriver.formatMedium(string, this.inifile);
                        break block1;
                    }
                }
                mC68000Cpu.data_regs[0] = -19;
                Helper.reportError(Localization.Texts[54], Localization.Texts[55] + n2, null);
                break;
            }
            case 40965: {
                switch (mC68000Cpu.data_regs[0]) {
                    case 1: {
                        mC68000Cpu.setScreenMode(mC68000Cpu.data_regs[1] & 0xFF);
                        break block1;
                    }
                    case 2: {
                        this.resetDrives();
                        this.gui.getMonitor().getCPU().setupSMSQE(true);
                        break block1;
                    }
                    case 3: {
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 4: {
                        this.setDirForDrive(mC68000Cpu.data_regs[7], mC68000Cpu.data_regs[6] & 0xFFFF, mC68000Cpu.readSmsqeString(mC68000Cpu.addr_regs[6] + mC68000Cpu.addr_regs[1]), mC68000Cpu, false);
                        break block1;
                    }
                    case 5: {
                        mC68000Cpu.setEmuScreenMode(mC68000Cpu.data_regs[1] & 0xFF);
                        break block1;
                    }
                    case 6: {
                        mC68000Cpu.moveBlock();
                        break block1;
                    }
                    case 7: {
                        int n9 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[0] + 38);
                        DeviceDriver deviceDriver = this.devicesMap.get(mC68000Cpu.data_regs[7]);
                        if (deviceDriver == null && (deviceDriver = this.getDeviceFromMapValues(mC68000Cpu.data_regs[7])) == null) {
                            mC68000Cpu.data_regs[0] = -7;
                            return;
                        }
                        deviceDriver.setUsage(n9);
                        this.setUsage(mC68000Cpu.data_regs[7], n9);
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 8: {
                        if (this.sam == null) break block1;
                        this.sam.fillPointers(mC68000Cpu);
                        break block1;
                    }
                    case 9: {
                        if (this.sam == null) break block1;
                        this.sam.killSound(mC68000Cpu);
                        break block1;
                    }
                    case 10: {
                        if (this.sam == null) break block1;
                        this.sam.playSample(mC68000Cpu);
                        break block1;
                    }
                    case 11: {
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 12: {
                        this.beep.play(mC68000Cpu);
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.data_regs[1] = 0;
                        break block1;
                    }
                    case 13: {
                        this.beep.killSound(mC68000Cpu);
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 14: {
                        if (this.sam == null) break block1;
                        this.sam.closeSound(true);
                        break block1;
                    }
                    case 15: {
                        int n10 = mC68000Cpu.addr_regs[6] + mC68000Cpu.addr_regs[1];
                        int n11 = mC68000Cpu.readMemoryWord(n10);
                        DeviceDriver deviceDriver = this.devicesMap.get(mC68000Cpu.data_regs[7]);
                        if (deviceDriver == null) {
                            deviceDriver = this.getDeviceFromMapValues(mC68000Cpu.data_regs[7]);
                        }
                        mC68000Cpu.data_regs[0] = -7;
                        if (n11 < 0 || n11 > 8 || deviceDriver == null) {
                            mC68000Cpu.data_regs[0] = -15;
                            return;
                        }
                        if (n11 == 0) {
                            n11 = deviceDriver.getUsage();
                            if (n11 != 0) {
                                mC68000Cpu.writeMemoryWord(n10 -= 6, 3);
                                mC68000Cpu.writeMemoryLong(n10 + 2, n11);
                                mC68000Cpu.addr_regs[1] = n10 - mC68000Cpu.addr_regs[6];
                                mC68000Cpu.data_regs[0] = 0;
                            }
                            return;
                        }
                        String string = deviceDriver.getName(n11);
                        if (string != null && !string.isEmpty()) {
                            n10 = n10 - 2 - string.length() & 0xFFFFFFFE;
                            mC68000Cpu.addr_regs[1] = n10 - mC68000Cpu.addr_regs[6];
                            mC68000Cpu.writeSmsqeString(n10, string, 256);
                            mC68000Cpu.data_regs[0] = 0;
                            break block1;
                        }
                        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - 2;
                        mC68000Cpu.writeMemoryShort(n10 - 2, (short)0);
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 16: {
                        String string = System.getProperty("os.name") + " " + System.getProperty("os.version");
                        mC68000Cpu.writeSmsqeString(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), string, true, 40);
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        break block1;
                    }
                    case 17: {
                        if (this.sam.isStillPlaying(mC68000Cpu)) {
                            mC68000Cpu.writeMemoryLong(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), 65537);
                        } else {
                            mC68000Cpu.writeMemoryLong(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), 0);
                        }
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        break block1;
                    }
                    case 18: {
                        int n12;
                        mC68000Cpu.data_regs[1] = n12 = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 19: {
                        if (this.gui != null) {
                            this.gui.menuBarVisible(true);
                        }
                        mC68000Cpu.data_regs[0] = 0;
                        break block1;
                    }
                    case 20: {
                        mC68000Cpu.combineBlocks();
                        break block1;
                    }
                    case 22: {
                        mC68000Cpu.data_regs[0] = 0;
                        this.setSoundVolume(mC68000Cpu.data_regs[1] & 0xFFFF);
                        break block1;
                    }
                    case 23: {
                        int n13 = mC68000Cpu.data_regs[2] - 1;
                        DeviceDriver deviceDriver = this.devicesMap.get(mC68000Cpu.data_regs[1]);
                        if (n13 < 0 || n13 > 7 || deviceDriver == null) {
                            mC68000Cpu.data_regs[0] = -15;
                            return;
                        }
                        deviceDriver.writeBack(n13);
                        break block1;
                    }
                    case 24: {
                        this.sound.openChannel(mC68000Cpu);
                        break block1;
                    }
                    case 25: {
                        this.sound.closeChannel();
                        break block1;
                    }
                    case 26: {
                        this.sound.doIO(mC68000Cpu);
                        break block1;
                    }
                    case 27: {
                        this.currentClock = System.currentTimeMillis();
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        break block1;
                    }
                    case 28: {
                        mC68000Cpu.writeMemoryLong(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), (int)(System.currentTimeMillis() - this.currentClock));
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        break block1;
                    }
                    case 29: {
                        if (this.gui != null) {
                            Monitor monitor = this.gui.getMonitor();
                            monitor.setScreenUpdateInterval(mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[1] + 2));
                        }
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        break block1;
                    }
                    case 30: {
                        int n14 = this.gui != null ? this.gui.menuBarIsVisible() : -1;
                        mC68000Cpu.writeMemoryWord(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), n14);
                        TrapDispatcher.noError(mC68000Cpu);
                        break block1;
                    }
                    case 31: {
                        System.exit(0);
                        break block1;
                    }
                    case 32: 
                    case 33: {
                        Screen screen = mC68000Cpu.getScreen();
                        screen.fillBlock(mC68000Cpu, mC68000Cpu.data_regs[0] == 32);
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        mC68000Cpu.pc_reg = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7]) / 2;
                        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 4;
                        break block1;
                    }
                    case 34: 
                    case 35: {
                        Screen screen = mC68000Cpu.getScreen();
                        boolean bl = mC68000Cpu.data_regs[0] == 34;
                        mC68000Cpu.data_regs[0] = 0;
                        mC68000Cpu.reg_sr |= 4;
                        screen.xorBlock(mC68000Cpu, bl);
                        mC68000Cpu.pc_reg = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7]) / 2;
                        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 4;
                        break block1;
                    }
                    case 36: {
                        mC68000Cpu.data_regs[1] = Localization.getQLVersion();
                        TrapDispatcher.noError(mC68000Cpu);
                        break block1;
                    }
                    case 37: {
                        String string = mC68000Cpu.readSmsqeString(mC68000Cpu.addr_regs[1]);
                        this.gui.setTitle(string);
                        TrapDispatcher.noError(mC68000Cpu);
                        break block1;
                    }
                    case 38: {
                        mC68000Cpu.data_regs[0] = this.sam != null ? this.sam.getSample() / 2 : 0;
                        mC68000Cpu.data_regs[0] = mC68000Cpu.data_regs[0];
                        break block1;
                    }
                }
                mC68000Cpu.data_regs[0] = -19;
                break;
            }
            case 40966: {
                int n15 = mC68000Cpu.data_regs[1];
                int n16 = n15 >>> 16;
                int n17 = n15 & 0xFFFF;
                int n18 = mC68000Cpu.addr_regs[3];
                if (n16 >= mC68000Cpu.readMemoryWord(n18 + 242) || n17 >= mC68000Cpu.readMemoryWord(n18 + 244)) {
                    mC68000Cpu.data_regs[0] = -4;
                    mC68000Cpu.pc_reg = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7]) / 2;
                    mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 4;
                    break;
                }
                mC68000Cpu.writeMemoryByte(n18 + 143, 0);
                mC68000Cpu.writeMemoryByte(n18 + 82, 0);
                mC68000Cpu.writeMemoryLong(n18 + 56, n15);
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.addr_regs[1]);
                if (this.gui == null || !this.gui.getMouseIsInScreen()) break;
                boolean bl = this.gui.setMousePosition(n16, n17);
                if (bl) {
                    n16 += n16;
                    n17 += n17;
                }
                if (this.robot == null) break;
                this.robot.mouseMove(n16 + this.xLoc, n17 + this.yLoc);
                break;
            }
            case 40967: {
                ++this.schedCounter;
                if (this.schedCounter > 5) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.schedCounter = 0;
                }
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 40968: {
                if (this.floppy == null) {
                    mC68000Cpu.data_regs[0] = -7;
                    return;
                }
                switch (mC68000Cpu.data_regs[0]) {
                    case 0: {
                        this.floppy.readSector();
                        break;
                    }
                    case 1: {
                        this.floppy.writeSector();
                        break;
                    }
                    case 2: {
                        this.floppy.formatDrive();
                        break;
                    }
                    case 3: {
                        this.floppy.checkWriteProtect();
                        break;
                    }
                    case 4: {
                        this.floppy.checkDriveStatus();
                        break;
                    }
                    case 5: {
                        this.floppy.setDrive();
                        break;
                    }
                    case 6: {
                        this.floppy.getDrive();
                    }
                }
                break;
            }
            case 40969: {
                this.ipHandler.handleTrap(mC68000Cpu);
                break;
            }
            case 40971: {
                switch (mC68000Cpu.data_regs[0]) {
                    case 0: {
                        this.gui.deIconify();
                        TrapDispatcher.noError(mC68000Cpu);
                        break;
                    }
                    case 1: {
                        this.gui.iconify();
                        TrapDispatcher.noError(mC68000Cpu);
                    }
                }
                break;
            }
            case 40972: {
                switch (mC68000Cpu.data_regs[0]) {
                    case 0: {
                        this.gui.getMonitor().setCopyScreen(mC68000Cpu.data_regs[1] & 0xFFFF, mC68000Cpu.data_regs[5]);
                        break;
                    }
                    case 1: {
                        mC68000Cpu.data_regs[1] = mC68000Cpu instanceof CPUforScreenEmulation ? 1 : 0;
                    }
                }
                break;
            }
            case 40973: {
                switch (mC68000Cpu.data_regs[0]) {
                    case 0: {
                        if (this.cxfer == null) {
                            this.cxfer = new ClipboardXfer();
                        }
                        this.cxfer.transferClipboardContentsToScrap(mC68000Cpu);
                        break;
                    }
                    case 1: {
                        if (this.cxfer == null) {
                            this.cxfer = new ClipboardXfer();
                        }
                        this.cxfer.transferScrapToClipboard(mC68000Cpu);
                        break;
                    }
                    case 2: {
                        if (this.cxfer == null) {
                            this.cxfer = new ClipboardXfer();
                        }
                        this.cxfer.getChangeCounter(mC68000Cpu);
                        break;
                    }
                    case 3: {
                        if (this.cxfer == null) {
                            this.cxfer = new ClipboardXfer();
                        }
                        this.cxfer.startMonitoring();
                        break;
                    }
                    case 4: {
                        if (this.cxfer == null) {
                            this.cxfer = new ClipboardXfer();
                        }
                        this.cxfer.stopMonitoring();
                    }
                }
                break;
            }
        }
    }

    public void setScreenCoordinates(int n, int n2) {
        this.xLoc = n;
        this.yLoc = n2;
    }

    private static void noError(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.data_regs[0] = 0;
        mC68000Cpu.reg_sr |= 4;
    }

    public synchronized void setThrottleStatus(boolean bl) {
        this.throttleStop = bl;
    }

    public void resetCounter() {
        this.schedCounter = 0;
    }

    private synchronized boolean checkThrottle() {
        return this.throttleStop;
    }

    public void setThrottle(int n) {
    }

    public void setFloppy(FloppyDriver floppyDriver) {
        this.floppy = floppyDriver;
    }

    public void register(DeviceDriver deviceDriver) {
        for (DeviceDriver deviceDriver2 : this.devicesMap.values()) {
            if (deviceDriver.getClass() != deviceDriver2.getClass()) continue;
            return;
        }
        this.devicesMap.put(deviceDriver.getDeviceID(), deviceDriver);
    }

    public void setNamesForDrives(int n, String[] stringArray, boolean bl) {
        DeviceDriver deviceDriver = this.devicesMap.get(n);
        if (deviceDriver == null) {
            deviceDriver = this.getDeviceFromMapValues(n);
        }
        if (deviceDriver != null) {
            deviceDriver.setNames(stringArray, this.inifile, bl, false);
            this.gui.setNewDeviceNames(n, stringArray);
        }
    }

    public void resetDrives() {
        for (DeviceDriver deviceDriver : this.devicesMap.values()) {
            String[] stringArray = deviceDriver.getNames();
            deviceDriver.setNames(stringArray, this.inifile, true, true);
        }
    }

    public String[] getNamesForDrives(int n) {
        DeviceDriver deviceDriver = this.devicesMap.get(n);
        if (deviceDriver == null) {
            deviceDriver = this.getDeviceFromMapValues(n);
        }
        return deviceDriver == null ? null : deviceDriver.getNames();
    }

    private void setDirForDrive(int n, int n2, String string, MC68000Cpu mC68000Cpu, boolean bl) {
        String[] stringArray = this.getNamesForDrives(n);
        if (stringArray == null || n2 < 1 || n2 > 8) {
            mC68000Cpu.data_regs[0] = -7;
            return;
        }
        if (string.equals(" ")) {
            string = "";
        }
        switch (n) {
            case 1179406384: 
            case 1296387376: 
            case 1464421936: {
                if (!string.endsWith(File.separator)) break;
                string = string.substring(0, string.length());
                break;
            }
            default: {
                if (string.endsWith(File.separator)) break;
                string = string + File.separator;
            }
        }
        stringArray[n2 - 1] = string;
        this.setNamesForDrives(n, stringArray, bl);
        mC68000Cpu.data_regs[0] = 0;
    }

    public void setFilenameChange(int n, int n2) {
        DeviceDriver deviceDriver = this.devicesMap.get(n);
        if (deviceDriver != null) {
            deviceDriver.setFilenameChange(n2);
        }
    }

    public void closeAllFiles() {
        for (DeviceDriver deviceDriver : this.devicesMap.values()) {
            if (deviceDriver == null) continue;
            deviceDriver.closeAllFiles();
        }
    }

    public void setCpu(MC68000Cpu mC68000Cpu) {
        for (DeviceDriver deviceDriver : this.devicesMap.values()) {
            if (deviceDriver == null) continue;
            deviceDriver.setCpu(mC68000Cpu);
        }
    }

    public void setUsage(int n, int n2) {
        DeviceDriver deviceDriver = this.devicesMap.get(n);
        if (deviceDriver == null) {
            deviceDriver = this.getDeviceFromMapValues(n);
        }
        if (deviceDriver != null) {
            deviceDriver.setUsage(n2);
            this.devicesMap.remove(n);
            this.devicesMap.put(n2, deviceDriver);
        }
    }

    private DeviceDriver getDeviceFromMapValues(int n) {
        for (DeviceDriver deviceDriver : this.devicesMap.values()) {
            if (deviceDriver.getDeviceID() != n) continue;
            return deviceDriver;
        }
        return null;
    }

    public void setSoundVolume(int n) {
        if (this.beep != null) {
            this.beep.setVolume(n);
        }
        if (this.sam != null) {
            this.sam.setVolume(n);
        }
    }

    public void reset() {
        for (DeviceDriver deviceDriver : this.devicesMap.values()) {
            deviceDriver.closeAllFiles();
        }
        this.resetDrives();
    }
}

