/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import smsqmulator.DeviceDriver;
import smsqmulator.SfaDriver;
import smsqmulator.XfaFile;
import smsqmulator.cpu.MC68000Cpu;

public class XfaDriver
implements DeviceDriver {
    protected int deviceID;
    protected String[] nativeDir = new String[8];
    protected MC68000Cpu cpu;
    private final HashMap<Integer, XfaFile>[] fileMap;
    protected boolean[][] fileNumber;
    protected int usage;
    protected int filenameChange = 0;
    protected ByteBuffer tempHeader;

    public XfaDriver(MC68000Cpu mC68000Cpu) {
        int n;
        this.cpu = mC68000Cpu;
        for (n = 0; n < this.nativeDir.length; ++n) {
            this.nativeDir[n] = "";
        }
        this.fileMap = new HashMap[8];
        for (n = 0; n < 8; ++n) {
            this.fileMap[n] = new HashMap(500);
        }
        this.fileNumber = new boolean[8][65536];
        if (this.deviceID == 1397113136) {
            this.tempHeader = ByteBuffer.allocate(68);
        }
    }

    @Override
    public boolean openFile(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        this.cpu.data_regs[0] = -7;
        if (this.nativeDir[n4].isEmpty()) {
            return false;
        }
        String string = this.cpu.readSmsqeString(n2 + 50);
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().equals("*d2d")) {
            this.cpu.data_regs[0] = -19;
            return false;
        }
        switch (this.filenameChange) {
            default: {
                break;
            }
            case 1: {
                string = string.toUpperCase();
                break;
            }
            case 2: {
                string = string.toLowerCase();
            }
        }
        File file = new File(this.nativeDir[n4] + XfaDriver.convertFilename(this.nativeDir[n4], string));
        switch (n3) {
            case 0: {
                if (!file.exists()) {
                    return false;
                }
                if (!file.canWrite() && !file.isDirectory()) {
                    this.cpu.data_regs[0] = -9;
                    return false;
                }
                if (this.deviceID == 1397113136 && SfaDriver.readHeaderOK(file, this.cpu, this.tempHeader) != 1) {
                    return false;
                }
                this.fileOpen(n4, file, string, n2, file.isDirectory(), true);
                break;
            }
            case 1: {
                if (!file.canRead()) {
                    return false;
                }
                if (this.deviceID == 1397113136 && SfaDriver.readHeaderOK(file, this.cpu, this.tempHeader) == 0) {
                    return false;
                }
                this.fileOpen(n4, file, string, n2, file.isDirectory(), false);
                break;
            }
            case 2: {
                if (file.exists() || file.isDirectory()) {
                    this.cpu.data_regs[0] = -8;
                    return false;
                }
                this.fileOpen(n4, file, string, n2, false, true);
                break;
            }
            case 3: {
                if (file.isDirectory()) {
                    this.cpu.data_regs[0] = -9;
                    return false;
                }
                if (file.exists()) {
                    if (this.deviceID == 1397113136 && SfaDriver.readHeaderOK(file, this.cpu, this.tempHeader) != 1) {
                        return false;
                    }
                    boolean bl = file.delete();
                    if (!bl) {
                        this.cpu.data_regs[0] = -9;
                        return false;
                    }
                }
                this.fileOpen(n4, file, string, n2, false, true);
                break;
            }
            case 4: {
                int n5;
                if (string.endsWith("_")) {
                    string = string.substring(0, string.length() - 1);
                }
                String string2 = this.nativeDir[n4];
                StringBuilder stringBuilder = new StringBuilder(250);
                stringBuilder.append(string2).append(File.separator).append(string);
                file = new File(stringBuilder.toString());
                if (file.exists() && file.isDirectory()) {
                    this.fileOpen(n4, file, string, n2, true, true);
                    return true;
                }
                String[] stringArray = string.split("_");
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    stringBuilder.append(stringArray[n5]).append(File.separator);
                }
                file = new File(stringBuilder.toString());
                if (file.exists() && file.isDirectory()) {
                    this.fileOpen(n4, file, string, n2, true, true);
                    return true;
                }
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                n5 = stringBuilder.length();
                int n6 = this.composeSubdirName(stringArray, 0, stringBuilder);
                if (n6 == n5) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.setLength(n6);
                }
                file = new File(stringBuilder.toString());
                if (!file.isDirectory()) {
                    return false;
                }
                string2 = n6 == n5 ? "" : stringBuilder.substring(string2.length(), n6 - 1).replace(File.separator, "_");
                if (!string.equals(string2)) {
                    this.cpu.writeSmsqeString(n2 + 50, string2, -1);
                }
                this.fileOpen(n4, file, string2, n2, true, true);
                return true;
            }
            case 255: {
                this.deleteFile(n4, byArray, file);
            }
        }
        return true;
    }

    private int composeSubdirName(String[] stringArray, int n, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        for (int i = n; i < stringArray.length; ++i) {
            int n3 = stringBuilder.length();
            stringBuilder.append(stringArray[i]).append(File.separator);
            File file = new File(stringBuilder.toString());
            if (file.exists() && file.isDirectory()) {
                return this.composeSubdirName(stringArray, i + 1, stringBuilder);
            }
            if (n3 != n2) {
                stringBuilder.setLength(n3 - 1);
                stringBuilder.append("_");
            } else {
                stringBuilder.setLength(n2);
            }
            stringBuilder.append(stringArray[i]).append(File.separator);
            file = new File(stringBuilder.toString());
            if (!file.exists() || !file.isDirectory()) continue;
            return this.composeSubdirName(stringArray, i + 1, stringBuilder);
        }
        return n2;
    }

    @Override
    public boolean closeFile(int n, int n2) {
        XfaFile xfaFile = this.fileMap[n].get(n2);
        if (xfaFile == null) {
            this.cpu.data_regs[0] = -6;
            return true;
        }
        xfaFile.close(this.cpu);
        this.fileMap[n].remove(n2);
        this.fileNumber[n][n2] = false;
        return true;
    }

    @Override
    public boolean formatMedium(String string, IniFile iniFile) {
        this.cpu.data_regs[0] = -19;
        return true;
    }

    @Override
    public boolean deleteFile(int n, byte[] byArray, File file) {
        String string = new String(byArray);
        this.cpu.data_regs[0] = this.fileIsOpen(n, string) ? -9 : (file.delete() ? 0 : (file.exists() ? -9 : 0));
        return true;
    }

    private boolean fileIsOpen(int n, String string) {
        Collection<XfaFile> collection = this.fileMap[n].values();
        Iterator<XfaFile> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getFilename();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private int getFreeNumber(int n) {
        for (int i = 0; i < this.fileNumber[n].length; ++i) {
            if (this.fileNumber[n][i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean setNames(String[] stringArray, IniFile iniFile, boolean bl, boolean bl2) {
        if (stringArray.length != 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (stringArray[i] == null) continue;
            this.nativeDir[i] = stringArray[i];
        }
        return true;
    }

    public void setDirname(int n, String string) {
        if (n < 0 || n > 7 || string == null) {
            return;
        }
        this.nativeDir[n] = string;
    }

    private boolean fileOpen(int n, File file, String string, int n2, boolean bl, boolean bl2) {
        RandomAccessFile randomAccessFile = null;
        boolean bl3 = false;
        try {
            XfaFile xfaFile;
            if (bl) {
                xfaFile = new XfaFile(file, string, true, n, this.nativeDir, this.deviceID, this.filenameChange, this.usage);
            } else {
                if (bl2) {
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    bl3 = true;
                } else {
                    randomAccessFile = new RandomAccessFile(file, "r");
                }
                FileChannel fileChannel = randomAccessFile.getChannel();
                if (bl3) {
                    FileLock fileLock = null;
                    try {
                        fileLock = fileChannel.tryLock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fileLock == null) {
                        this.cpu.data_regs[0] = -9;
                        this.cpu.reg_sr &= 0xFFFFFFFB;
                        return false;
                    }
                }
                xfaFile = new XfaFile(randomAccessFile, fileChannel, bl3, file, string, bl, this.deviceID, n, this.nativeDir, this.filenameChange, this.usage);
            }
            int n3 = this.getFreeNumber(n);
            if (n3 == -1) {
                this.cpu.data_regs[0] = -11;
                return false;
            }
            this.fileNumber[n][n3] = true;
            this.fileMap[n].put(n3, xfaFile);
            this.cpu.writeMemoryWord(n2 + 30, n3);
            this.cpu.writeMemoryWord(n2 + 94, n3);
            this.cpu.data_regs[0] = 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.cpu.data_regs[0] = -7;
            return false;
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.cpu.data_regs[0] = -11;
            return false;
        }
        return true;
    }

    @Override
    public boolean trap3OK(int n, int n2, int n3, int n4) {
        XfaFile xfaFile = this.fileMap[n].get(n4);
        if (xfaFile == null) {
            this.cpu.data_regs[0] = -7;
        } else {
            xfaFile.handleTrap3(n2, n3, this.cpu, this.nativeDir[n]);
        }
        return true;
    }

    @Override
    public void setUsage(int n) {
        this.usage = n;
    }

    public static final String convertFilename(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return string2;
        }
        String[] stringArray = string2.split("_");
        if (stringArray.length < 2) {
            return string2.replace("_", File.separator);
        }
        String string3 = string + File.separator;
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string3 = string3 + File.separator + stringArray[i]);
            if (file.exists() && file.isDirectory()) continue;
            return XfaDriver.makeName(stringArray, i);
        }
        return XfaDriver.makeName(stringArray, stringArray.length - 1);
    }

    public static final String convertFilename2(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return string2;
        }
        String[] stringArray = string2.split("_");
        if (stringArray.length < 2) {
            return string2.replace("_", File.separator);
        }
        String string3 = string + File.separator;
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string3 = string3 + File.separator + stringArray[i]);
            if (file.exists() && file.isDirectory()) continue;
            return XfaDriver.makeName(stringArray, i);
        }
        return XfaDriver.makeName(stringArray, stringArray.length - 1);
    }

    public static final String makeName(String[] stringArray, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(stringArray[n2]).append(File.separator);
        }
        for (n2 = n; n2 < stringArray.length; ++n2) {
            stringBuilder.append(stringArray[n2]).append("_");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '_') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setFilenameChange(int n) {
        if (n > 2 || n < 0) {
            return;
        }
        this.filenameChange = n;
    }

    @Override
    public int getDeviceID() {
        return this.deviceID;
    }

    @Override
    public String[] getNames() {
        return (String[])this.nativeDir.clone();
    }

    @Override
    public void closeAllFiles() {
        for (int i = 0; i < 8; ++i) {
            int n = this.fileNumber[i].length;
            for (int j = 0; j < n; ++j) {
                if (!this.fileNumber[i][j]) continue;
                XfaFile xfaFile = this.fileMap[i].get(j);
                xfaFile.close(this.cpu);
                this.fileMap[i].remove(j);
                this.fileNumber[i][j] = false;
            }
        }
    }

    @Override
    public void setCpu(MC68000Cpu mC68000Cpu) {
        this.cpu = mC68000Cpu;
    }

    @Override
    public String getName(int n) {
        if (this.nativeDir[--n] != null && !this.nativeDir[n].isEmpty()) {
            return this.nativeDir[n];
        }
        return "";
    }

    @Override
    public int getUsage() {
        return this.usage;
    }

    @Override
    public void writeBack(int n) {
        this.cpu.data_regs[0] = -19;
    }
}

