/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu;

import inifile.IniFile;
import java.nio.ByteBuffer;
import smsqmulator.Screen;
import smsqmulator.cpu.MC68000Cpu;

public class CPUforScreenEmulation
extends MC68000Cpu {
    private boolean copyQLScreen = false;

    public CPUforScreenEmulation(int n, Screen screen, IniFile iniFile, int n2) {
        super(n, screen, iniFile, n2);
    }

    public CPUforScreenEmulation(int n, IniFile iniFile, int n2, int n3) {
        super(n, iniFile, n2, n3);
    }

    public CPUforScreenEmulation(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    @Override
    public final void writeMemoryByte(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return;
        }
        int n3 = n / 2;
        int n4 = n2;
        short s = this.mainMemory[n3];
        if ((n & 1) != 0) {
            s = (short)(s & 0xFF00);
            n2 &= 0xFF;
        } else {
            s = (short)(s & 0xFF);
            n2 = n2 << 8 & 0xFF00;
        }
        this.mainMemory[n3] = (short)(n2 |= s);
        if (n >= this.screenStart) {
            this.screen.writeByteToScreen(n, n4, n2);
        }
        if (this.copyQLScreen && n >= 131072 && n < 163840) {
            this.screen.copyScreen(this, n3 * 2, n2);
        }
    }

    @Override
    public final void writeMemoryWord(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForWord) {
            return;
        }
        this.mainMemory[n / 2] = (short)n2;
        if (n >= this.screenStart) {
            this.screen.writeWordToScreen(n, n2);
        }
        if (this.copyQLScreen && n >= 131072 && n < 163840) {
            this.screen.copyScreen(this, n, n2);
        }
    }

    @Override
    public final void writeMemoryShort(int n, short s) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForWord) {
            return;
        }
        this.mainMemory[n / 2] = s;
        if (n >= this.screenStart) {
            this.screen.writeWordToScreen(n, s);
        }
        if (this.copyQLScreen && n >= 131072 && n < 163840) {
            this.screen.copyScreen(this, n, s);
        }
    }

    @Override
    public final void writeMemoryLong(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForLong) {
            return;
        }
        int n3 = n / 2;
        this.mainMemory[n3] = (short)(n2 >>> 16);
        this.mainMemory[n3 + 1] = (short)n2;
        if (n >= this.screenStart) {
            this.screen.writeLongToScreen(n, n2);
        }
        if (this.copyQLScreen && n >= 131072 && n < 163838) {
            this.screen.copyScreen(this, n, n2 >>> 16);
            this.screen.copyScreen(this, n + 2, n2 & 0xFFFF);
        }
    }

    @Override
    public void setCopyScreen(int n, int n2) {
        this.copyQLScreen = n != 0;
        this.screen.setQLEmulationMode(n);
        this.data_regs[0] = 0;
        this.reg_sr |= 4;
    }

    @Override
    protected int readFromBuffer(int n, int n2, ByteBuffer byteBuffer, int n3, boolean bl) {
        short s;
        int n4;
        if (n2 < 1) {
            return 0;
        }
        n &= 0xFFFFFFF;
        if (bl ? n + n2 > this.totMemSize && (n2 = this.totMemSize - n) < 1 : n + n2 > this.totRamSize && (n2 = this.ramSize - n) < 1) {
            return 0;
        }
        boolean bl2 = false;
        if ((n >= this.screenStart && n <= this.screenStop || n + n2 >= this.screenStart && n + n2 <= this.screenStop) && !bl) {
            bl2 = true;
        }
        int n5 = n;
        byteBuffer.limit(byteBuffer.capacity());
        if (n2 + n3 > byteBuffer.capacity()) {
            n2 = byteBuffer.capacity() - n3;
        }
        boolean bl3 = (n & 1) == 1;
        n /= 2;
        if (bl3) {
            --n2;
            n4 = (short)(this.mainMemory[n] & 0xFF00);
            s = (short)(byteBuffer.get(n3) & 0xFF);
            this.mainMemory[n] = (short)(n4 | s);
            ++n;
            ++n3;
        }
        n4 = n3;
        while (n4 < n2 + n3 - 1) {
            this.mainMemory[n] = byteBuffer.getShort(n4);
            n4 += 2;
            ++n;
        }
        if ((n2 & 1) == 1) {
            s = this.mainMemory[n];
            s = (short)(s & 0xFF);
            this.mainMemory[n] = s = (short)(s | byteBuffer.get(n4) << 8);
        }
        if (bl3) {
            ++n2;
        }
        if (bl2) {
            this.screen.displayRegion(this, n5, n2);
        } else if (this.copyQLScreen && !bl && n5 >= 131072 && n + n2 < 163840) {
            this.screen.setDisplayRegion(n5, n2, this.mainMemory);
        }
        return n2;
    }
}

