/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class ABCD
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n;
        int n2;
        int n3;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n >> 9 & 7;
                switch (n & 8) {
                    case 0: {
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFF;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFFFF00;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | this.doCalc(n3, n4, mC68000Cpu);
                        break;
                    }
                    case 8: {
                        int n7 = n & 7;
                        if (n7 == 7) {
                            int n8 = n7;
                            mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] - 2;
                        } else {
                            int n9 = n7;
                            mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] - 1;
                        }
                        if (n2 == 7) {
                            int n10 = n2;
                            mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 2;
                        } else {
                            int n11 = n2;
                            mC68000Cpu.addr_regs[n11] = mC68000Cpu.addr_regs[n11] - 1;
                        }
                        int n12 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n7]);
                        int n13 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n2]);
                        mC68000Cpu.writeMemoryByte(mC68000Cpu.addr_regs[n2], this.doCalc(n12, n13, mC68000Cpu));
                    }
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand;
                DisassembledOperand disassembledOperand2;
                if ((n2 & 8) == 0) {
                    disassembledOperand2 = new DisassembledOperand("d" + (n2 & 7));
                    disassembledOperand = new DisassembledOperand("d" + (n2 >> 9 & 7));
                } else {
                    disassembledOperand2 = new DisassembledOperand("-(a" + (n2 & 7) + ")");
                    disassembledOperand = new DisassembledOperand("-(a" + (n2 >> 9 & 7) + ")");
                }
                return new DisassembledInstruction(n, n2, "abcd", disassembledOperand2, disassembledOperand);
            }

            protected final int doCalc(int n, int n2, MC68000Cpu mC68000Cpu) {
                int n3 = (mC68000Cpu.reg_sr & 0x10) == 0 ? 0 : 1;
                boolean bl = false;
                int n4 = n + n2 + n3;
                if (n4 > 255) {
                    bl = true;
                }
                int n5 = (n & 0xF) + (n2 & 0xF) + n3;
                if (((n4 & 0xF) > 9 || (n5 & 0xF0) != 0) && (n4 += 6) > 255) {
                    bl = true;
                }
                if ((n4 & 0xF0) > 144 || bl) {
                    n4 += 96;
                    bl = true;
                } else {
                    bl = false;
                }
                mC68000Cpu.reg_sr = bl ? (mC68000Cpu.reg_sr |= 0x11) : (mC68000Cpu.reg_sr &= 0xFFEE);
                if ((n4 &= 0xFF) != 0) {
                    mC68000Cpu.reg_sr &= 0xFFFB;
                }
                return n4;
            }
        };
        int n4 = 49408;
        for (n3 = 0; n3 < 8; ++n3) {
            n2 = n3 << 9;
            for (n = 0; n < 8; ++n) {
                mC68000Cpu.addInstruction(n4 + n2 + n, instruction);
            }
        }
        n4 = 49416;
        for (n3 = 0; n3 < 8; ++n3) {
            n2 = n3 << 9;
            for (n = 0; n < 8; ++n) {
                mC68000Cpu.addInstruction(n4 + n2 + n, instruction);
            }
        }
    }
}

