/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class CHK
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 16768;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                mC68000Cpu.reg_sr &= 0xFFF0;
                int n2 = mC68000Cpu.data_regs[n >> 9 & 7] & 0xFFFF;
                if ((n2 & 0x8000) != 0) {
                    mC68000Cpu.reg_sr |= 8;
                    mC68000Cpu.raiseException(6);
                }
                int n3 = 0;
                int n4 = n & 7;
                block0 : switch (n >> 3 & 7) {
                    case 0: {
                        int n5 = mC68000Cpu.data_regs[n4] & 0xFFFF;
                        if ((n5 & 0x8000) != 0 || n2 > n5) {
                            mC68000Cpu.raiseException(6);
                        }
                        return;
                    }
                    case 2: {
                        n3 = mC68000Cpu.addr_regs[n4];
                        break;
                    }
                    case 3: {
                        n3 = mC68000Cpu.addr_regs[n4];
                        int n6 = n4;
                        mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 2;
                        break;
                    }
                    case 4: {
                        int n7 = n4;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 2;
                        n3 = mC68000Cpu.addr_regs[n4];
                        break;
                    }
                    case 5: {
                        n3 = mC68000Cpu.addr_regs[n4] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n3 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n4];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n3 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                                break block0;
                            }
                            case 2: {
                                n3 = mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 3: {
                                n3 = mC68000Cpu.pc_reg * 2 + this.getDisplacement(mC68000Cpu);
                                break block0;
                            }
                            case 4: {
                                n3 = mC68000Cpu.pc_reg * 2;
                                ++mC68000Cpu.pc_reg;
                            }
                        }
                    }
                }
                int n8 = mC68000Cpu.readMemoryWordSigned(n3);
                if ((n2 & 0x8000) != 0) {
                    n2 |= 0xFFFF0000;
                }
                if (n2 > n8) {
                    mC68000Cpu.raiseException(6);
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 >> 9 & 7));
                DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Word);
                return new DisassembledInstruction(n, n2, "chk", disassembledOperand, disassembledOperand2);
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }
        };
        for (int i = 0; i < 8; ++i) {
            int n2 = i << 9;
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n3 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 4); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + n3 + k, instruction);
                }
            }
        }
    }
}

