/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class DIVSW
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 33216;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2;
                int n3 = n >>> 9 & 7;
                int n4 = mC68000Cpu.data_regs[n3];
                int n5 = n & 7;
                int n6 = 0;
                block0 : switch (n >>> 3 & 7) {
                    case 0: {
                        n6 = mC68000Cpu.data_regs[n5] & 0xFFFF;
                        if ((n6 & 0x8000) == 0) break;
                        n6 |= 0xFFFF0000;
                        break;
                    }
                    case 2: {
                        n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n5]);
                        break;
                    }
                    case 3: {
                        n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n5]);
                        int n7 = n5;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 2;
                        break;
                    }
                    case 4: {
                        int n8 = n5;
                        mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] - 2;
                        n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n5]);
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                        n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n5] + n2);
                        break;
                    }
                    case 6: {
                        int n9 = mC68000Cpu.readMemoryWordPCSignedInc();
                        n2 = MC68000Cpu.signExtendByte(n9);
                        n2 = (n9 & 0x8000) != 0 ? ((n9 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n9 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n9 >> 12 & 7])) : ((n9 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n9 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n9 >> 12 & 7]));
                        n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n5] + n2);
                        break;
                    }
                    case 7: {
                        switch (n5) {
                            case 0: {
                                int n10 = mC68000Cpu.readMemoryWordPCSignedInc();
                                n6 = mC68000Cpu.readMemoryWordSigned(n10);
                                break block0;
                            }
                            case 1: {
                                int n11 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                                n6 = mC68000Cpu.readMemoryWordSigned(n11);
                                break block0;
                            }
                            case 2: {
                                n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc());
                                break block0;
                            }
                            case 3: {
                                n6 = mC68000Cpu.pc_reg * 2 + this.getDisplacement(mC68000Cpu);
                                n6 = mC68000Cpu.readMemoryWordSigned(n6);
                                break block0;
                            }
                            case 4: {
                                n6 = mC68000Cpu.readMemoryWordPCSignedInc();
                            }
                        }
                    }
                }
                mC68000Cpu.reg_sr &= 0xFFF0;
                if (n6 == 0) {
                    mC68000Cpu.raiseException(5);
                    return;
                }
                n2 = n4 / n6;
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    mC68000Cpu.reg_sr += 2;
                    return;
                }
                mC68000Cpu.data_regs[n3] = (n4 %= n6) << 16;
                int n12 = n3;
                mC68000Cpu.data_regs[n12] = mC68000Cpu.data_regs[n12] | (n2 &= 0xFFFF);
                if (n2 == 0) {
                    mC68000Cpu.reg_sr += 4;
                } else if ((n2 & 0x8000) != 0) {
                    mC68000Cpu.reg_sr += 8;
                }
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Word);
                DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                return new DisassembledInstruction(n, n2, "divs", disassembledOperand, disassembledOperand2);
            }
        };
        for (int i = 0; i < 8; ++i) {
            if (i == 1) continue;
            for (int j = 0; j < 8 && (i != 7 || j <= 4); ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (k << 9) + (i << 3) + j, instruction);
                }
            }
        }
    }
}

