/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVE;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEAnX1
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 4155;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.pc_reg * 2 + MOVEAnX1.this.getDisplacement(mC68000Cpu);
                        n2 = mC68000Cpu.readMemoryByte(n2);
                        int n3 = n >> 9 & 7;
                        mC68000Cpu.data_regs[n3] = mC68000Cpu.data_regs[n3] & 0xFFFFFF00 | n2;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n2 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnX1.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 12347;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.pc_reg * 2 + MOVEAnX1.this.getDisplacement(mC68000Cpu);
                        n2 = mC68000Cpu.readMemoryWord(n2);
                        int n3 = n >> 9 & 7;
                        mC68000Cpu.data_regs[n3] = mC68000Cpu.data_regs[n3] & 0xFFFF0000 | n2;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n2 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnX1.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 8251;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.pc_reg * 2 + MOVEAnX1.this.getDisplacement(mC68000Cpu);
                        mC68000Cpu.data_regs[n >> 9 & 7] = n2 = mC68000Cpu.readMemoryLong(n2);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (n2 < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnX1.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + (j << 9), instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + disassembledOperand.bytes, n2 >> 6 & 7, n2 >> 9 & 7, size);
        return new DisassembledInstruction(n, n2, "move" + size.ext(), disassembledOperand, disassembledOperand2);
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }
}

