/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class MOVE_USP
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 2; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 20064;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        if (!mC68000Cpu.isSupervisorMode()) {
                            mC68000Cpu.raiseSRException();
                        } else {
                            mC68000Cpu.reg_usp = mC68000Cpu.addr_regs[n & 7];
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        DisassembledOperand disassembledOperand = new DisassembledOperand("a" + (n2 & 7));
                        DisassembledOperand disassembledOperand2 = new DisassembledOperand("usp");
                        return new DisassembledInstruction(n, n2, "move", disassembledOperand, disassembledOperand2);
                    }
                };
            } else {
                n = 20072;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        if (!mC68000Cpu.isSupervisorMode()) {
                            mC68000Cpu.raiseSRException();
                        } else {
                            mC68000Cpu.addr_regs[n & 7] = mC68000Cpu.reg_usp;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        DisassembledOperand disassembledOperand = new DisassembledOperand("a" + (n2 & 7));
                        DisassembledOperand disassembledOperand2 = new DisassembledOperand("usp");
                        return new DisassembledInstruction(n, n2, "move", disassembledOperand2, disassembledOperand);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + j, instruction);
            }
        }
    }
}

