/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class NEG
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 17408;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4;
                                int n5 = n4 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                                n4 = 0 - n4 & 0xFF;
                                int n6 = n & 7;
                                mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFFFF00;
                                int n7 = n & 7;
                                mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | n4;
                                mC68000Cpu.reg_sr &= 0xFFE0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else {
                                    mC68000Cpu.reg_sr |= 0x11;
                                    if ((n4 & 0x80) != 0) {
                                        mC68000Cpu.reg_sr |= 8;
                                        if ((n5 & 0x80) != 0) {
                                            mC68000Cpu.reg_sr |= 2;
                                        }
                                    }
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n8 = n & 7;
                                n3 = mC68000Cpu.addr_regs[n8];
                                if (n8 == 7) {
                                    int n9 = n8;
                                    mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] + 2;
                                    break;
                                }
                                int n10 = n8;
                                mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] + 1;
                                break;
                            }
                            case 4: {
                                int n11 = n & 7;
                                if (n11 == 7) {
                                    int n12 = n11;
                                    mC68000Cpu.addr_regs[n12] = mC68000Cpu.addr_regs[n12] - 2;
                                } else {
                                    int n13 = n11;
                                    mC68000Cpu.addr_regs[n13] = mC68000Cpu.addr_regs[n13] - 1;
                                }
                                n3 = mC68000Cpu.addr_regs[n11];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = NEG.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n14 = n2 = mC68000Cpu.readMemoryByte(n3);
                        n2 = 0 - n2;
                        mC68000Cpu.writeMemoryByte(n3, n2);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else {
                            mC68000Cpu.reg_sr |= 0x11;
                            if ((n2 & 0x80) != 0) {
                                mC68000Cpu.reg_sr |= 8;
                                if ((n14 & 0x80) != 0) {
                                    mC68000Cpu.reg_sr |= 2;
                                }
                            }
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NEG.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 17472;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4;
                                int n5 = n4 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                                n4 = 0 - n4 & 0xFFFF;
                                int n6 = n & 7;
                                mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFF0000;
                                int n7 = n & 7;
                                mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | n4;
                                mC68000Cpu.reg_sr &= 0xFFE0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else {
                                    mC68000Cpu.reg_sr |= 0x11;
                                    if ((n4 & 0x8000) != 0) {
                                        mC68000Cpu.reg_sr |= 8;
                                        if ((n5 & 0x8000) != 0) {
                                            mC68000Cpu.reg_sr |= 2;
                                        }
                                    }
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n8 = n & 7;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 2;
                                break;
                            }
                            case 4: {
                                int n9 = n & 7;
                                mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] - 2;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = NEG.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n10 = n2 = mC68000Cpu.readMemoryWord(n3);
                        n2 = 0 - n2;
                        mC68000Cpu.writeMemoryWord(n3, n2);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else {
                            mC68000Cpu.reg_sr |= 0x11;
                            if ((n2 & 0x8000) != 0) {
                                mC68000Cpu.reg_sr |= 8;
                                if ((n10 & 0x8000) != 0) {
                                    mC68000Cpu.reg_sr |= 2;
                                }
                            }
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NEG.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 17536;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4;
                                int n5 = n4 = mC68000Cpu.data_regs[n & 7];
                                mC68000Cpu.data_regs[n & 7] = n4 = 0 - n4;
                                mC68000Cpu.reg_sr &= 0xFFE0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else {
                                    mC68000Cpu.reg_sr |= 0x11;
                                    if (n4 < 0) {
                                        mC68000Cpu.reg_sr |= 8;
                                        if (n5 < 0) {
                                            mC68000Cpu.reg_sr |= 2;
                                        }
                                    }
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n6 = n & 7;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 4;
                                break;
                            }
                            case 4: {
                                int n7 = n & 7;
                                mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 4;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = NEG.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n8 = n2 = mC68000Cpu.readMemoryLong(n3);
                        n2 = 0 - n2;
                        mC68000Cpu.writeMemoryLong(n3, n2);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else {
                            mC68000Cpu.reg_sr |= 0x11;
                            if (n2 < 0) {
                                mC68000Cpu.reg_sr |= 8;
                                if (n8 < 0) {
                                    mC68000Cpu.reg_sr |= 2;
                                }
                            }
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NEG.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n2 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 1); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "neg" + size.ext(), disassembledOperand);
    }
}

