/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class RTE
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.addInstruction(20083, new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                if (mC68000Cpu.isSupervisorMode()) {
                    int n2 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[7]);
                    mC68000Cpu.pc_reg = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7] + 2) / 2;
                    mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 6;
                    mC68000Cpu.reg_sr = n2;
                    if ((mC68000Cpu.reg_sr & 0x2000) == 0) {
                        mC68000Cpu.reg_ssp = mC68000Cpu.addr_regs[7];
                        mC68000Cpu.addr_regs[7] = mC68000Cpu.reg_usp;
                    }
                    mC68000Cpu.testTrace();
                } else {
                    mC68000Cpu.raiseException(8);
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return new DisassembledInstruction(n, n2, "rte");
            }
        });
    }
}

