/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class TAS
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 19136;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = 0;
                mC68000Cpu.reg_sr &= 0xFFF0;
                block0 : switch (n >> 3 & 7) {
                    case 0: {
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                        int n4 = n & 7;
                        mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] | 0x80;
                        if (n3 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n3 & 0x80) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                        return;
                    }
                    case 2: {
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 3: {
                        int n5 = n & 7;
                        n2 = mC68000Cpu.addr_regs[n5];
                        if (n5 == 7) {
                            int n6 = n & 7;
                            mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 2;
                            break;
                        }
                        int n7 = n & 7;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 1;
                        break;
                    }
                    case 4: {
                        int n8 = n & 7;
                        if (n8 == 7) {
                            int n9 = n & 7;
                            mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] - 2;
                        } else {
                            int n10 = n & 7;
                            mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 1;
                        }
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n2 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n2 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                            }
                        }
                    }
                }
                int n11 = mC68000Cpu.readMemoryByte(n2);
                if (n11 == 0) {
                    mC68000Cpu.reg_sr |= 4;
                } else if ((n11 & 0x80) != 0) {
                    mC68000Cpu.reg_sr |= 8;
                }
                mC68000Cpu.writeMemoryByte(n2, n11 |= 0x80);
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Byte);
                return new DisassembledInstruction(n, n2, "tas", disassembledOperand);
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }
        };
        for (int i = 0; i < 8; ++i) {
            if (i == 1) continue;
            int n2 = i << 3;
            for (int j = 0; j < 8 && !(i == 7 & j > 1); ++j) {
                mC68000Cpu.addInstruction(n + n2 + j, instruction);
            }
        }
    }
}

