/*
 * Decompiled with CFR 0.152.
 */
package inifile;

import inifile.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class IniFile
implements Serializable {
    private final Map<String, Option> options = new LinkedHashMap<String, Option>();
    private String filename = null;
    private static final String[] trueValues = new String[]{"ja", "s\u00ed", "yes", "oui", "wahr", "verdadero", "true", "vrai", "1"};

    public IniFile() {
    }

    public IniFile(String string, String string2, String string3) {
        this.addOption(string, string2, string3);
    }

    public final void readIniFile() throws Exception {
        if (this.filename == null || this.filename.isEmpty()) {
            throw new FileNotFoundException();
        }
        this.readIniFile(new File(this.filename), true);
    }

    public final void readIniFile(boolean bl) throws Exception {
        if (this.filename == null || this.filename.isEmpty()) {
            throw new FileNotFoundException();
        }
        this.readIniFile(new File(this.filename), bl);
    }

    public void readIniFile(String string) throws Exception {
        this.readIniFile(new File(string), true);
    }

    public void readIniFile(String string, boolean bl) throws Exception {
        this.readIniFile(new File(string), bl);
    }

    public void readIniFile(File file) throws Exception {
        this.readIniFile(file, true);
    }

    public void readIniFile(File file, boolean bl) throws Exception {
        String string;
        if (!file.exists()) {
            string = file.getAbsolutePath();
            string = System.getProperty("user.home") + File.separator + string;
            file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
        }
        this.filename = file.getAbsolutePath();
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.replaceAll("\t", " ").trim()).equals("")) {
                    string2 = null;
                    continue;
                }
                if (string.startsWith("#")) {
                    string2 = string.substring(1).trim();
                    continue;
                }
                String[] stringArray = string.split("=", 2);
                if (stringArray == null || stringArray.length != 2 || stringArray[1].contains("=")) continue;
                stringArray[0] = stringArray[0].trim().toLowerCase();
                if (stringArray[0].equals("wdw_xsize")) {
                    // empty if block
                }
                stringArray[1] = stringArray[1].trim();
                Option option = this.options.get(stringArray[0]);
                if (option != null) {
                    option.setOptionValue(stringArray[1]);
                    if (string2 != null) {
                        option.setDescription(string2);
                    }
                } else if (!bl) {
                    this.addOption(stringArray[0], stringArray[1], string2);
                }
                string2 = null;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new Exception(exception);
        }
    }

    public void writeIniFileNoError() {
        if (this.filename == null || this.filename.isEmpty()) {
            return;
        }
        try {
            this.writeIniFile(new File(this.filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeIniFile() throws Exception {
        if (this.filename == null) {
            throw new FileNotFoundException();
        }
        this.writeIniFile(new File(this.filename));
    }

    public void writeIniFile(String string) throws Exception {
        this.writeIniFile(new File(string));
    }

    public void writeIniFile(File file) throws Exception {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
            for (Option option : this.options.values()) {
                printStream.println("# " + option.getDescription());
                printStream.println(option.getName() + " = " + option.getValue());
                printStream.println();
            }
            printStream.close();
        }
        catch (IOException iOException) {
            try {
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(iOException);
        }
    }

    public final void addOption(String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Option name  must not be null or empty");
        }
        string = string.trim();
        Option option = new Option(string, string2, string3);
        this.options.put(string.toLowerCase(), option);
    }

    public void changeOption(Option option) {
        if (option == null) {
            return;
        }
        String string = option.getName().toLowerCase();
        if (this.options.get(string) != null) {
            this.options.put(string, option);
        }
    }

    public void setOptionValue(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Option option = this.options.get(string.trim().toLowerCase());
        if (option != null) {
            option.setOptionValue(string2);
        }
    }

    public void setOptionDescription(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Option option = this.options.get(string.trim().toLowerCase());
        if (option != null) {
            option.setOptionValue(string2);
        }
    }

    public boolean checkOptionExists(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return this.options.get(string.trim().toLowerCase()) != null;
    }

    public String getOptionValue(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Option option = this.options.get(string.trim().toLowerCase());
        return option == null ? null : option.getValue();
    }

    public String getTrimmedOptionValue(String string) {
        Option option = this.options.get(string.trim().toLowerCase());
        return option == null ? null : option.getValue().trim();
    }

    public String getLowerCasedOptionValue(String string) {
        Option option = this.options.get(string.trim().toLowerCase());
        return option == null ? null : option.getValue().trim().toLowerCase();
    }

    public int getOptionAsInt(String string, int n) {
        Option option = this.options.get(string.trim().toLowerCase());
        if (option == null) {
            return n;
        }
        String string2 = option.getValue().trim();
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean getTrueOrFalse(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        Option option = this.options.get(string.toLowerCase());
        if (option == null) {
            return false;
        }
        String string2 = option.getValue();
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        for (String string3 : trueValues) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public Option getOption(String string) {
        return this.options.get(string.trim().toLowerCase());
    }

    public void parseCommandLine(String[] stringArray) {
        for (String string : stringArray) {
            Option option;
            String[] stringArray2;
            if ((string = string.trim()).isEmpty() || !string.startsWith("-") || (stringArray2 = (string = string.startsWith("--") ? string.substring(2) : string.substring(1)).split("=", 2)).length != 2 || (option = this.options.get(stringArray2[0].trim().toLowerCase())) == null) continue;
            option.setOptionValue(stringArray2[1]);
        }
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }
}

