// Copyright (C) jonny (jonnyleffe AT tuta DOT io) - All Rights Reserved

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version. See also the license.txt file for *
*   additional informations.                                              *
*                                                                         *
***************************************************************************/

#ifndef _DISPLAY_RESOLUTIONS_H_
#define _DISPLAY_RESOLUTIONS_H_

#include "stdafx.h"

struct DisplayResolution
{
	int width;
	int height;
	int refresh;
	struct DisplayResolution *next;
};

struct DisplayResolutions
{
	struct DisplayResolution *first;
};

extern struct DisplayResolutions displayResolutions;

void initResolutions();
void getFirstResolution(int *width, int *height, int *refresh);
void getResolutionFromIndex(int index, int *width, int *height, int *refresh);
int getIndexFromResolutionAndCorrectNotFound(int *width, int *height, int *refresh);

#endif
