// Copyright (C) jonny (jonnyleffe AT tuta DOT io) - All Rights Reserved

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version. See also the license.txt file for *
*   additional informations.                                              *
*                                                                         *
***************************************************************************/

#include "Fonts.h"

void setFontEnvironment(struct FontEnvironment *environment, unsigned char *surface, int width, int height, int depth, int pitch, struct BitmapFont *font)
{
	environment->surface = surface;
	environment->width = width;
	environment->height = height;
	environment->depth = depth;
	environment->pitch = pitch;
	environment->font = font;
}

void drawChar(int xStart, int yStart, char ch, struct FontEnvironment *environment)
{
	if (ch < FONTS_START_CODE) return;
	if (ch > FONTS_END_CODE) return;

	if (xStart < 0) return;
	if (yStart < 0) return;

	if ((xStart + environment->font->width) > environment->width) return;
	if ((yStart + environment->font->height) > environment->height) return;

	int sourceIndex = environment->font->width * environment->font->height * ((int)ch - FONTS_START_CODE);

	if (environment->depth == 32)
	{
		unsigned int *source = &environment->font->raw32[sourceIndex];

		for (int y = 0; y < environment->font->height; y++)
		{
			unsigned char *destination = environment->surface + ((y + yStart) * environment->pitch) + (xStart * 4);

			for (int x = 0; x < environment->font->width; x++)
			{
				*((unsigned int *)destination) = *source;

				source++;
				destination += 4;
			}
		}
	}
	else
	{
		unsigned short *source;

		if (environment->depth == 16)
		{
			source = &environment->font->raw16[sourceIndex];
		}
		else
		{
			source = &environment->font->raw15[sourceIndex];
		}

		for (int y = 0; y < environment->font->height; y++)
		{
			unsigned char *destination = environment->surface + ((y + yStart) * environment->pitch) + (xStart * 2);

			for (int x = 0; x < environment->font->width; x++)
			{
				*((unsigned short *)destination) = *source;

				source++;
				destination += 2;
			}
		}
	}
}

void drawText(int xStart, int yStart, char *text, struct FontEnvironment *environment)
{
	while (*text != 0)
	{
		drawChar(xStart, yStart, *text, environment);

		xStart += environment->font->width;
		text++;
	}
}

void drawBitmap(int xStart, int yStart, int width, int height, unsigned char *sourceBitmap, struct FontEnvironment *environment)
{
	if (xStart < 0) return;
	if (yStart < 0) return;

	if ((xStart + width) > environment->width) return;
	if ((yStart + height) > environment->height) return;

	if (environment->depth == 32)
	{
		unsigned int *source = (unsigned int *)sourceBitmap;

		for (int y = 0; y < height; y++)
		{
			unsigned char *destination = environment->surface + ((y + yStart) * environment->pitch) + (xStart * 4);

			for (int x = 0; x < width; x++)
			{
				*((unsigned int *)destination) = *source;

				source++;
				destination += 4;
			}
		}
	}
	else
	{
		unsigned short *source = (unsigned short *)sourceBitmap;

		for (int y = 0; y < height; y++)
		{
			unsigned char *destination = environment->surface + ((y + yStart) * environment->pitch) + (xStart * 2);

			for (int x = 0; x < width; x++)
			{
				*((unsigned short *)destination) = *source;

				source++;
				destination += 2;
			}
		}
	}
}

void drawPixel(int x, int y, struct ExtraClipper *extraClipper, struct FontEnvironment *environment)
{
	if (x < 0) return;
	if (y < 0) return;

	if (x >= environment->width) return;
	if (y >= environment->height) return;

	if (extraClipper)
	{
		if (x < extraClipper->xStart) return;
		if (y < extraClipper->yStart) return;

		if (x > extraClipper->xEnd) return;
		if (y > extraClipper->yEnd) return;
	}

	if (environment->depth == 32)
	{
		unsigned char *destination = environment->surface + (y * environment->pitch) + (x * 4);

		*((unsigned int *)destination) = 0xffffffff;
	}
	else
	{
		unsigned char *destination = environment->surface + (y * environment->pitch) + (x * 2);

		*((unsigned short *)destination) = 0xffff;
	}
}
