/***************************************************************************
                          draw.c  -  description
                             -------------------
    begin                : Sun Oct 28 2001
    copyright            : (C) 2001 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2008/05/17 - Pete
// - added "visual rumble" stuff to buffer swap func
//
// 2007/10/27 - MxC
// - added HQ2X/HQ3X MMX versions, and fixed stretching
//
// 2005/06/11 - MxC
// - added HQ2X,HQ3X,Scale3X screen filters
//
// 2004/01/31 - Pete
// - added zn stuff
//
// 2003/01/31 - stsp
// - added zn stuff
//
// 2003/12/30 - Stefan Sperling <stsp@guerila.com>
// - improved XF86VM fullscreen switching a little (refresh frequency issues).
//
// 2002/12/30 - Pete
// - added Scale2x display mode - Scale2x (C) 2002 Andrea Mazzoleni - http://scale2x.sourceforge.net
//
// 2002/12/29 - Pete
// - added gun cursor display
//
// 2002/12/21 - linuzappz
// - some more messages for DGA2 errors
// - improved XStretch funcs a little
// - fixed non-streched modes for DGA2
//
// 2002/11/10 - linuzappz
// - fixed 5bit masks for 2xSai/etc
//
// 2002/11/06 - Pete
// - added 2xSai, Super2xSaI, SuperEagle
//
// 2002/08/09 - linuzappz
// - added DrawString calls for DGA2 (FPS display)
//
// 2002/03/10 - lu
// - Initial SDL-only blitting function
// - Initial SDL stretch function (using an undocumented SDL 1.2 func)
// - Boht are triggered by -D_SDL -D_SDL2
//
// 2002/02/18 - linuzappz
// - NoStretch, PIC and Scanlines support for DGA2 (32bit modes untested)
// - Fixed PIC colors in CreatePic for 16/15 bit modes
//
// 2002/02/17 - linuzappz
// - Added DGA2 support, support only with no strecthing disabled (also no FPS display)
//
// 2002/01/13 - linuzappz
// - Added timing for the szDebugText (to 2 secs)
//
// 2002/01/05 - Pete
// - fixed linux stretch centering (no more garbled screens)
//
// 2001/12/30 - Pete
// - Added linux fullscreen desktop switching (non-SDL version, define USE_XF86VM in Makefile)
//
// 2001/12/19 - syo
// - support refresh rate change
// - added  wait VSYNC
//
// 2001/12/16 - Pete
// - Added Windows FPSE RGB24 mode switch
//
// 2001/12/05 - syo (syo68k@geocities.co.jp)
// - modified for "Use system memory" option
//   (Pete: fixed "system memory" save state pic surface)
//
// 2001/11/11 - lu
// - SDL additions
//
// 2001/10/28 - Pete
// - generic cleanup for the Peops release
//
//*************************************************************************//

#include "stdafx.h"

#define _IN_DRAW

#include "externals.h"
#include "gpu.h"
#include "draw.h"
#include "prim.h"
#include "menu.h"
#include "hq.h"

// MOD2!!!
#include "cfg.h" 
#include "Fonts.h"

struct FontEnvironment fontEnvironment;

extern struct BitmapFont defaultFont;
// MOD2!!!

////////////////////////////////////////////////////////////////////////////////////
// misc globals
////////////////////////////////////////////////////////////////////////////////////
int            iResX;
int            iResY;
long           lLowerpart;
BOOL           bIsFirstFrame = TRUE;
BOOL           bCheckMask = FALSE;
unsigned short sSetMask = 0;
unsigned long  lSetMask = 0;
int            iDesktopCol = 16;
int            iShowFPS = 0;
int            iWinSize;
int            iUseNoStretchBlt = 0;
int            iFastFwd = 0;
PSXPoint_t     ptCursorPoint[8];
unsigned short usCursorActive = 0;

// MOD2!!!
#define DEBUG_BITMAP_W 128
#define DEBUG_BITMAP_H 96

int showDebugBitmap = 0;
unsigned char debugBitmap15[DEBUG_BITMAP_W * DEBUG_BITMAP_H * 2];
unsigned char debugBitmap16[DEBUG_BITMAP_W * DEBUG_BITMAP_H * 2];
unsigned char debugBitmap32[DEBUG_BITMAP_W * DEBUG_BITMAP_H * 4];

int monitorW;
int monitorH;
int gameW;
int gameH;
int overscan0;
int overscan1;
int backbufferDepth;
int initialAspectRatio;
int sendKey[SEND_KEYS_MAX];
int keyPressAfter = 1000;
int keyReleaseAfter = 500;

int isStretched = 0;
int showExtendedMenu = 0;
long screenRealScale = 1;
RECT correctedResolution;
RECT correctedResolution2;
RECT stretchedResolution;
int cooperativeLevel = 0;
int escRequest = 0;

int getSurfaceDepth()
{
	return iDesktopCol;
}
// MOD2!!!

////////////////////////////////////////////////////////////////////////
// generic 2xSaI helpers
////////////////////////////////////////////////////////////////////////

// MOD2!!!
#define SMALL_WIDTH 640

void *pSaISmallBuff = NULL;
void *pSaIBigBuff = NULL;

#define GET_RESULT(A, B, C, D) ((A != C || A != D) - (B != C || B != D))

static __inline int GetResult1(DWORD A, DWORD B, DWORD C, DWORD D, DWORD E)
{
    int x = 0;
    int y = 0;
    int r = 0;
    if (A == C) x+=1;
    else if (B == C) y+=1;
    if (A == D) x+=1;
    else if (B == D) y+=1;
    if (x <= 1) r+=1;
    if (y <= 1) r-=1;
    return r;
}

static __inline int GetResult2(DWORD A, DWORD B, DWORD C, DWORD D, DWORD E)
{
    int x = 0;
    int y = 0;
    int r = 0;
    if (A == C) x+=1;
    else if (B == C) y+=1;
    if (A == D) x+=1;
    else if (B == D) y+=1;
    if (x <= 1) r-=1;
    if (y <= 1) r+=1;
    return r;
}

static __inline void FixAspect(RECT* r)
{
    float aspect = (float)PreviousPSXDisplay.DisplayMode.y / (float)PreviousPSXDisplay.DisplayMode.x;
    int width = r->right * aspect;

    r->left = (r->right - width) / 2;
    r->right = r->right - r->left;
}

#define colorMask8     0x00FEFEFE
#define lowPixelMask8  0x00010101
#define qcolorMask8    0x00FCFCFC
#define qlowpixelMask8 0x00030303

#define INTERPOLATE8(A, B) ((((A & colorMask8) >> 1) + ((B & colorMask8) >> 1) + (A & B & lowPixelMask8)))
#define Q_INTERPOLATE8(A, B, C, D) (((((A & qcolorMask8) >> 2) + ((B & qcolorMask8) >> 2) + ((C & qcolorMask8) >> 2) + ((D & qcolorMask8) >> 2) \
                                      + ((((A & qlowpixelMask8) + (B & qlowpixelMask8) + (C & qlowpixelMask8) + (D & qlowpixelMask8)) >> 2) & qlowpixelMask8))))


void Super2xSaI_ex8(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 4; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    DWORD srcPitchHalf    = srcPitch>>1;
    int   finWidth        = srcPitch>>2;
    DWORD line;
    DWORD* dP;
    DWORD* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA0, colorA1, colorA2, colorA3,
          colorB0, colorB1, colorB2, colorB3,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (DWORD*)srcPtr;
            dP = (DWORD*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------    B1 B2
                //                                         4  5  6 S2
                //                                         1  2  3 S1
                //                                           A1 A2
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0)  {iYA=0;}
                else         {iYA=finWidth;}
                if (height>4) {iYB=finWidth; iYC=srcPitchHalf;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorB0 = *(bP- iYA - iXA);
                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);
                colorB3 = *(bP- iYA + iXC);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA0 = *(bP + iYC - iXA);
                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);
                colorA3 = *(bP + iYC + iXC);

                if (color2 == color6 && color5 != color3)
                {
                    product2b = product1b = color2;
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1b = color5;
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (color1&0x00ffffff),  (colorA1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (color4&0x00ffffff),  (colorB1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (colorA2&0x00ffffff), (colorS1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (colorB2&0x00ffffff), (colorS2&0x00ffffff));

                    if (r > 0)
                        product2b = product1b = color6;
                    else if (r < 0)
                        product2b = product1b = color5;
                    else
                    {
                        product2b = product1b = INTERPOLATE8(color5, color6);
                    }
                }
                else
                {
                    if (color6 == color3 && color3 == colorA1 && color2 != colorA2 && color3 != colorA0)
                        product2b = Q_INTERPOLATE8 (color3, color3, color3, color2);
                    else if (color5 == color2 && color2 == colorA2 && colorA1 != color3 && color2 != colorA3)
                        product2b = Q_INTERPOLATE8 (color2, color2, color2, color3);
                    else
                        product2b = INTERPOLATE8 (color2, color3);

                    if (color6 == color3 && color6 == colorB1 && color5 != colorB2 && color6 != colorB0)
                        product1b = Q_INTERPOLATE8 (color6, color6, color6, color5);
                    else if (color5 == color2 && color5 == colorB2 && colorB1 != color6 && color5 != colorB3)
                        product1b = Q_INTERPOLATE8 (color6, color5, color5, color5);
                    else
                        product1b = INTERPOLATE8 (color5, color6);
                }

                if (color5 == color3 && color2 != color6 && color4 == color5 && color5 != colorA2)
                    product2a = INTERPOLATE8(color2, color5);
                else if (color5 == color1 && color6 == color5 && color4 != color2 && color5 != colorA0)
                    product2a = INTERPOLATE8(color2, color5);
                else
                    product2a = color2;

                if (color2 == color6 && color5 != color3 && color1 == color2 && color2 != colorB2)
                    product1a = INTERPOLATE8(color2, color5);
                else if (color4 == color2 && color3 == color2 && color1 != color5 && color2 != colorB0)
                    product1a = INTERPOLATE8(color2, color5);
                else
                    product1a = color5;

                *dP=product1a;
                *(dP+1)=product1b;
                *(dP+(srcPitchHalf))=product2a;
                *(dP+1+(srcPitchHalf))=product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void Std2xSaI_ex8(unsigned char* srcPtr, DWORD srcPitch,
                  unsigned char* dstBitmap, int width, int height)
{
	srcPitch *= 4; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    DWORD srcPitchHalf    = srcPitch>>1;
    int   finWidth        = srcPitch>>2;
    DWORD line;
    DWORD* dP;
    DWORD* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;

    DWORD colorA, colorB;
    DWORD colorC, colorD,
          colorE, colorF, colorG, colorH,
          colorI, colorJ, colorK, colorL,
          colorM, colorN, colorO, colorP;
    DWORD product, product1, product2;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (DWORD*)srcPtr;
            dP = (DWORD*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------
                // Map of the pixels:                    I|E F|J
                //                                       G|A B|K
                //                                       H|C D|L
                //                                       M|N O|P
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0)  {iYA=0;}
                else         {iYA=finWidth;}
                if (height>4) {iYB=finWidth; iYC=srcPitchHalf;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorI = *(bP- iYA - iXA);
                colorE = *(bP- iYA);
                colorF = *(bP- iYA + iXB);
                colorJ = *(bP- iYA + iXC);

                colorG = *(bP  - iXA);
                colorA = *(bP);
                colorB = *(bP  + iXB);
                colorK = *(bP + iXC);

                colorH = *(bP  + iYB  - iXA);
                colorC = *(bP  + iYB);
                colorD = *(bP  + iYB  + iXB);
                colorL = *(bP  + iYB  + iXC);

                colorM = *(bP + iYC - iXA);
                colorN = *(bP + iYC);
                colorO = *(bP + iYC + iXB);
                colorP = *(bP + iYC + iXC);


                if ((colorA == colorD) && (colorB != colorC))
                {
                    if (((colorA == colorE) && (colorB == colorL)) ||
                        ((colorA == colorC) && (colorA == colorF) &&
                         (colorB != colorE) && (colorB == colorJ)))
                    {
                        product = colorA;
                    }
                    else
                    {
                        product = INTERPOLATE8(colorA, colorB);
                    }

                    if (((colorA == colorG) && (colorC == colorO)) ||
                        ((colorA == colorB) && (colorA == colorH) &&
                         (colorG != colorC) && (colorC == colorM)))
                    {
                        product1 = colorA;
                    }
                    else
                    {
                        product1 = INTERPOLATE8(colorA, colorC);
                    }
                    product2 = colorA;
                }
                else if ((colorB == colorC) && (colorA != colorD))
                {
                    if (((colorB == colorF) && (colorA == colorH)) ||
                        ((colorB == colorE) && (colorB == colorD) &&
                         (colorA != colorF) && (colorA == colorI)))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE8(colorA, colorB);
                    }

                    if (((colorC == colorH) && (colorA == colorF)) ||
                        ((colorC == colorG) && (colorC == colorD) &&
                         (colorA != colorH) && (colorA == colorI)))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1=INTERPOLATE8(colorA, colorC);
                    }
                    product2 = colorB;
                }
                else if ((colorA == colorD) && (colorB == colorC))
                {
                    if (colorA == colorB)
                    {
                        product = colorA;
                        product1 = colorA;
                        product2 = colorA;
                    }
                    else
                    {
                        register int r = 0;
                        product1 = INTERPOLATE8(colorA, colorC);
                        product = INTERPOLATE8(colorA, colorB);

                        r += GetResult1 (colorA&0x00FFFFFF, colorB&0x00FFFFFF, colorG&0x00FFFFFF, colorE&0x00FFFFFF, colorI&0x00FFFFFF);
                        r += GetResult2 (colorB&0x00FFFFFF, colorA&0x00FFFFFF, colorK&0x00FFFFFF, colorF&0x00FFFFFF, colorJ&0x00FFFFFF);
                        r += GetResult2 (colorB&0x00FFFFFF, colorA&0x00FFFFFF, colorH&0x00FFFFFF, colorN&0x00FFFFFF, colorM&0x00FFFFFF);
                        r += GetResult1 (colorA&0x00FFFFFF, colorB&0x00FFFFFF, colorL&0x00FFFFFF, colorO&0x00FFFFFF, colorP&0x00FFFFFF);

                        if (r > 0)
                            product2 = colorA;
                        else if (r < 0)
                            product2 = colorB;
                        else
                        {
                            product2 = Q_INTERPOLATE8(colorA, colorB, colorC, colorD);
                        }
                    }
                }
                else
                {
                    product2 = Q_INTERPOLATE8(colorA, colorB, colorC, colorD);

                    if ((colorA == colorC) && (colorA == colorF) &&
                        (colorB != colorE) && (colorB == colorJ))
                    {
                        product = colorA;
                    }
                    else if ((colorB == colorE) && (colorB == colorD) && (colorA != colorF) && (colorA == colorI))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE8(colorA, colorB);
                    }

                    if ((colorA == colorB) && (colorA == colorH) &&
                        (colorG != colorC) && (colorC == colorM))
                    {
                        product1 = colorA;
                    }
                    else if ((colorC == colorG) && (colorC == colorD) &&
                             (colorA != colorH) && (colorA == colorI))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1 = INTERPOLATE8(colorA, colorC);
                    }
                }

                //////////////////////////

                *dP=colorA;
                *(dP+1)=product;
                *(dP+(srcPitchHalf))=product1;
                *(dP+1+(srcPitchHalf))=product2;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void SuperEagle_ex8(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 4; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    DWORD srcPitchHalf    = srcPitch>>1;
    int   finWidth        = srcPitch>>2;
    DWORD line;
    DWORD* dP;
    DWORD* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA1, colorA2,
          colorB1, colorB2,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (DWORD*)srcPtr;
            dP = (DWORD*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0)  {iYA=0;}
                else         {iYA=finWidth;}
                if (height>4) {iYB=finWidth; iYC=srcPitchHalf;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);

                if (color2 == color6 && color5 != color3)
                {
                    product1b = product2a = color2;
                    if ((color1 == color2) ||
                        (color6 == colorB2))
                    {
                        product1a = INTERPOLATE8(color2, color5);
                        product1a = INTERPOLATE8(color2, product1a);
                    }
                    else
                    {
                        product1a = INTERPOLATE8(color5, color6);
                    }

                    if ((color6 == colorS2) ||
                        (color2 == colorA1))
                    {
                        product2b = INTERPOLATE8(color2, color3);
                        product2b = INTERPOLATE8(color2, product2b);
                    }
                    else
                    {
                        product2b = INTERPOLATE8(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1a = color5;

                    if ((colorB1 == color5) ||
                        (color3 == colorS1))
                    {
                        product1b = INTERPOLATE8(color5, color6);
                        product1b = INTERPOLATE8(color5, product1b);
                    }
                    else
                    {
                        product1b = INTERPOLATE8(color5, color6);
                    }

                    if ((color3 == colorA2) ||
                        (color4 == color5))
                    {
                        product2a = INTERPOLATE8(color5, color2);
                        product2a = INTERPOLATE8(color5, product2a);
                    }
                    else
                    {
                        product2a = INTERPOLATE8(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (color1&0x00ffffff),  (colorA1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (color4&0x00ffffff),  (colorB1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (colorA2&0x00ffffff), (colorS1&0x00ffffff));
                    r += GET_RESULT ((color6&0x00ffffff), (color5&0x00ffffff), (colorB2&0x00ffffff), (colorS2&0x00ffffff));

                    if (r > 0)
                    {
                        product1b = product2a = color2;
                        product1a = product2b = INTERPOLATE8(color5, color6);
                    }
                    else if (r < 0)
                    {
                        product2b = product1a = color5;
                        product1b = product2a = INTERPOLATE8(color5, color6);
                    }
                    else
                    {
                        product2b = product1a = color5;
                        product1b = product2a = color2;
                    }
                }
                else
                {
                    product2b = product1a = INTERPOLATE8(color2, color6);
                    product2b = Q_INTERPOLATE8(color3, color3, color3, product2b);
                    product1a = Q_INTERPOLATE8(color5, color5, color5, product1a);

                    product2a = product1b = INTERPOLATE8(color5, color3);
                    product2a = Q_INTERPOLATE8(color2, color2, color2, product2a);
                    product1b = Q_INTERPOLATE8(color6, color6, color6, product1b);
                }

                ////////////////////////////////

                *dP=product1a;
                *(dP+1)=product1b;
                *(dP+(srcPitchHalf))=product2a;
                *(dP+1+(srcPitchHalf))=product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

/////////////////////////

static __inline void scale2x_32_def_whole(unsigned long* dst0, unsigned long* dst1, const unsigned long* src0, const unsigned long* src1, const unsigned long* src2, unsigned count)
{

    // first pixel
    if (src0[0] != src2[0] && src1[0] != src1[1])
    {
        dst0[0] = src1[0] == src0[0] ? src0[0] : src1[0];
        dst0[1] = src1[1] == src0[0] ? src0[0] : src1[0];
        dst1[0] = src1[0] == src2[0] ? src2[0] : src1[0];
        dst1[1] = src1[1] == src2[0] ? src2[0] : src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
    }
    ++src0;
    ++src1;
    ++src2;
    dst0 += 2;
    dst1 += 2;

    // central pixels
    count -= 2;
    while (count)
    {
        if (src0[0] != src2[0] && src1[-1] != src1[1])
        {
            dst0[0] = src1[-1] == src0[0] ? src0[0] : src1[0];
            dst0[1] = src1[1] == src0[0] ? src0[0] : src1[0];
            dst1[0] = src1[-1] == src2[0] ? src2[0] : src1[0];
            dst1[1] = src1[1] == src2[0] ? src2[0] : src1[0];
        }
        else
        {
            dst0[0] = src1[0];
            dst0[1] = src1[0];
            dst1[0] = src1[0];
            dst1[1] = src1[0];
        }

        ++src0;
        ++src1;
        ++src2;
        dst0 += 2;
        dst1 += 2;
        --count;
    }

    // last pixel
    if (src0[0] != src2[0] && src1[-1] != src1[0])
    {
        dst0[0] = src1[-1] == src0[0] ? src0[0] : src1[0];
        dst0[1] = src1[0] == src0[0] ? src0[0] : src1[0];
        dst1[0] = src1[-1] == src2[0] ? src2[0] : src1[0];
        dst1[1] = src1[0] == src2[0] ? src2[0] : src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
    }
}



#ifndef MAX
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#define MIN(a,b)    (((a) < (b)) ? (a) : (b))
#endif

void Scale2x_ex8(unsigned char* srcPtr, DWORD srcPitch,
                 unsigned char*  dstPtr, int width, int height)
{
#ifdef _WINDOWS

	srcPitch *= 4; // MOD2!!!

    const int dstPitch = srcPitch;
    int srcpitch = srcPitch >> 2;
    int count = height;

    unsigned long*  dst0 = (unsigned long*)dstPtr;
    unsigned long*  dst1 = dst0 + (dstPitch >> 1);

    unsigned long*  src0 = (unsigned long*)srcPtr;
    unsigned long*  src1 = src0 + srcpitch;
    unsigned long*  src2 = src1 + srcpitch;
    scale2x_32_def_whole(dst0, dst1, src0, src0, src1, width);
    count -= 2;
    while (count)
    {
        dst0 += dstPitch;
        dst1 += dstPitch;
        scale2x_32_def_whole(dst0, dst1, src0, src1, src2, width);
        src0 = src1;
        src1 = src2;
        src2 += srcpitch;
        --count;
    }
    dst0 += dstPitch;
    dst1 += dstPitch;
    scale2x_32_def_whole(dst0, dst1, src0, src1, src1, width);
#else

    int looph, loopw;

    unsigned char* srcpix = srcPtr;
    unsigned char* dstpix = dstPtr;

    const int srcpitch = srcPitch;
    const int dstpitch = srcPitch<<1;

    unsigned long E0, E1, E2, E3, B, D, E, F, H;
    for (looph = 0; looph < height; ++looph)
    {
        for (loopw = 0; loopw < width; ++ loopw)
        {
            B = *(unsigned long*)(srcpix + (MAX(0,looph-1)*srcpitch) + (4*loopw));
            D = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*MAX(0,loopw-1)));
            E = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*loopw));
            F = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*MIN(width-1,loopw+1)));
            H = *(unsigned long*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (4*loopw));

            if (B != H && D != F)
            {
                E0 = D == B ? D : E;
                E1 = B == F ? F : E;
                E2 = D == H ? D : E;
                E3 = H == F ? F : E;
            }
            else
            {
                E0 = E;
                E1 = E;
                E2 = E;
                E3 = E;
            }


            *(unsigned long*)(dstpix + looph*2*dstpitch + loopw*2*4) = E0;
            *(unsigned long*)(dstpix + looph*2*dstpitch + (loopw*2+1)*4) = E1;
            *(unsigned long*)(dstpix + (looph*2+1)*dstpitch + loopw*2*4) = E2;
            *(unsigned long*)(dstpix + (looph*2+1)*dstpitch + (loopw*2+1)*4) = E3;
        }
    }
#endif
}

static __inline void scale3x_16_def_whole(unsigned short* dst0, unsigned short* dst1, unsigned short* dst2, const unsigned short* src0, const unsigned short* src1, const unsigned short* src2, unsigned count)
{
    // first pixel
    if (src0[0] != src2[0] && src1[0] != src1[1])
    {
        dst0[0] = src1[0];
        dst0[1] = (src1[0] == src0[0] && src1[0] != src0[1]) || (src1[1] == src0[0] && src1[0] != src0[0]) ? src0[0] : src1[0];
        dst0[2] = src1[1] == src0[0] ? src1[1] : src1[0];
        dst1[0] = (src1[0] == src0[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src0[0]) ? src1[0] : src1[0];
        dst1[1] = src1[0];
        dst1[2] = (src1[1] == src0[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src0[1]) ? src1[1] : src1[0];
        dst2[0] = src1[0];
        dst2[1] = (src1[0] == src2[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src2[0]) ? src2[0] : src1[0];
        dst2[2] = src1[1] == src2[0] ? src1[1] : src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst0[2] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
        dst1[2] = src1[0];
        dst2[0] = src1[0];
        dst2[1] = src1[0];
        dst2[2] = src1[0];
    }
    ++src0;
    ++src1;
    ++src2;
    dst0 += 3;
    dst1 += 3;
    dst2 += 3;

    // central pixels
    count -= 2;
    while (count)
    {
        if (src0[0] != src2[0] && src1[-1] != src1[1])
        {
            dst0[0] = src1[-1] == src0[0] ? src1[-1] : src1[0];
            dst0[1] = (src1[-1] == src0[0] && src1[0] != src0[1]) || (src1[1] == src0[0] && src1[0] != src0[-1]) ? src0[0] : src1[0];
            dst0[2] = src1[1] == src0[0] ? src1[1] : src1[0];
            dst1[0] = (src1[-1] == src0[0] && src1[0] != src2[-1]) || (src1[-1] == src2[0] && src1[0] != src0[-1]) ? src1[-1] : src1[0];
            dst1[1] = src1[0];
            dst1[2] = (src1[1] == src0[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src0[1]) ? src1[1] : src1[0];
            dst2[0] = src1[-1] == src2[0] ? src1[-1] : src1[0];
            dst2[1] = (src1[-1] == src2[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src2[-1]) ? src2[0] : src1[0];
            dst2[2] = src1[1] == src2[0] ? src1[1] : src1[0];
        }
        else
        {
            dst0[0] = src1[0];
            dst0[1] = src1[0];
            dst0[2] = src1[0];
            dst1[0] = src1[0];
            dst1[1] = src1[0];
            dst1[2] = src1[0];
            dst2[0] = src1[0];
            dst2[1] = src1[0];
            dst2[2] = src1[0];
        }

        ++src0;
        ++src1;
        ++src2;
        dst0 += 3;
        dst1 += 3;
        dst2 += 3;
        --count;
    }

    // last pixel
    if (src0[0] != src2[0] && src1[-1] != src1[0])
    {
        dst0[0] = src1[-1] == src0[0] ? src1[-1] : src1[0];
        dst0[1] = (src1[-1] == src0[0] && src1[0] != src0[0]) || (src1[0] == src0[0] && src1[0] != src0[-1]) ? src0[0] : src1[0];
        dst0[2] = src1[0];
        dst1[0] = (src1[-1] == src0[0] && src1[0] != src2[-1]) || (src1[-1] == src2[0] && src1[0] != src0[-1]) ? src1[-1] : src1[0];
        dst1[1] = src1[0];
        dst1[2] = (src1[0] == src0[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src0[0]) ? src1[0] : src1[0];
        dst2[0] = src1[-1] == src2[0] ? src1[-1] : src1[0];
        dst2[1] = (src1[-1] == src2[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src2[-1]) ? src2[0] : src1[0];
        dst2[2] = src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst0[2] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
        dst1[2] = src1[0];
        dst2[0] = src1[0];
        dst2[1] = src1[0];
        dst2[2] = src1[0];
    }
}


static __inline void scale3x_32_def_whole(unsigned long* dst0, unsigned long* dst1, unsigned long* dst2, const unsigned long* src0, const unsigned long* src1, const unsigned long* src2, unsigned count)
{

    // first pixel
    if (src0[0] != src2[0] && src1[0] != src1[1])
    {
        dst0[0] = src1[0];
        dst0[1] = (src1[0] == src0[0] && src1[0] != src0[1]) || (src1[1] == src0[0] && src1[0] != src0[0]) ? src0[0] : src1[0];
        dst0[2] = src1[1] == src0[0] ? src1[1] : src1[0];
        dst1[0] = (src1[0] == src0[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src0[0]) ? src1[0] : src1[0];
        dst1[1] = src1[0];
        dst1[2] = (src1[1] == src0[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src0[1]) ? src1[1] : src1[0];
        dst2[0] = src1[0];
        dst2[1] = (src1[0] == src2[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src2[0]) ? src2[0] : src1[0];
        dst2[2] = src1[1] == src2[0] ? src1[1] : src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst0[2] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
        dst1[2] = src1[0];
        dst2[0] = src1[0];
        dst2[1] = src1[0];
        dst2[2] = src1[0];
    }
    ++src0;
    ++src1;
    ++src2;
    dst0 += 3;
    dst1 += 3;
    dst2 += 3;

    // central pixels
    count -= 2;
    while (count)
    {
        if (src0[0] != src2[0] && src1[-1] != src1[1])
        {
            dst0[0] = src1[-1] == src0[0] ? src1[-1] : src1[0];
            dst0[1] = (src1[-1] == src0[0] && src1[0] != src0[1]) || (src1[1] == src0[0] && src1[0] != src0[-1]) ? src0[0] : src1[0];
            dst0[2] = src1[1] == src0[0] ? src1[1] : src1[0];
            dst1[0] = (src1[-1] == src0[0] && src1[0] != src2[-1]) || (src1[-1] == src2[0] && src1[0] != src0[-1]) ? src1[-1] : src1[0];
            dst1[1] = src1[0];
            dst1[2] = (src1[1] == src0[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src0[1]) ? src1[1] : src1[0];
            dst2[0] = src1[-1] == src2[0] ? src1[-1] : src1[0];
            dst2[1] = (src1[-1] == src2[0] && src1[0] != src2[1]) || (src1[1] == src2[0] && src1[0] != src2[-1]) ? src2[0] : src1[0];
            dst2[2] = src1[1] == src2[0] ? src1[1] : src1[0];
        }
        else
        {
            dst0[0] = src1[0];
            dst0[1] = src1[0];
            dst0[2] = src1[0];
            dst1[0] = src1[0];
            dst1[1] = src1[0];
            dst1[2] = src1[0];
            dst2[0] = src1[0];
            dst2[1] = src1[0];
            dst2[2] = src1[0];
        }

        ++src0;
        ++src1;
        ++src2;
        dst0 += 3;
        dst1 += 3;
        dst2 += 3;
        --count;
    }

    // last pixel
    if (src0[0] != src2[0] && src1[-1] != src1[0])
    {
        dst0[0] = src1[-1] == src0[0] ? src1[-1] : src1[0];
        dst0[1] = (src1[-1] == src0[0] && src1[0] != src0[0]) || (src1[0] == src0[0] && src1[0] != src0[-1]) ? src0[0] : src1[0];
        dst0[2] = src1[0];
        dst1[0] = (src1[-1] == src0[0] && src1[0] != src2[-1]) || (src1[-1] == src2[0] && src1[0] != src0[-1]) ? src1[-1] : src1[0];
        dst1[1] = src1[0];
        dst1[2] = (src1[0] == src0[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src0[0]) ? src1[0] : src1[0];
        dst2[0] = src1[-1] == src2[0] ? src1[-1] : src1[0];
        dst2[1] = (src1[-1] == src2[0] && src1[0] != src2[0]) || (src1[0] == src2[0] && src1[0] != src2[-1]) ? src2[0] : src1[0];
        dst2[2] = src1[0];
    }
    else
    {
        dst0[0] = src1[0];
        dst0[1] = src1[0];
        dst0[2] = src1[0];
        dst1[0] = src1[0];
        dst1[1] = src1[0];
        dst1[2] = src1[0];
        dst2[0] = src1[0];
        dst2[1] = src1[0];
        dst2[2] = src1[0];
    }
}

void Scale3x_ex6_5(unsigned char* srcPtr, DWORD srcPitch,
                   unsigned char*  dstPtr, int width, int height)
{
#ifdef _WINDOWS
    int count = height;
	int dstPitch = srcPitch * 3; // MOD2!!!
	int srcpitch = srcPitch; // MOD2!!!

    unsigned short*  dst0 = (unsigned short*)dstPtr;
    unsigned short*  dst1 = dst0 + dstPitch;
    unsigned short*  dst2 = dst1 + dstPitch;

    unsigned short*  src0 = (unsigned short*)srcPtr;
    unsigned short*  src1 = src0 + srcpitch;
    unsigned short*  src2 = src1 + srcpitch;
	scale3x_16_def_whole(dst0, dst1, dst2, src0, src0, src1, width); // MOD2!!!
	dstPitch *= 3;
    count -= 2;
    while (count)
    {

        dst0 += dstPitch;
        dst1 += dstPitch;
        dst2 += dstPitch;

        scale3x_16_def_whole(dst0, dst1, dst2, src0, src1, src2, width);
        src0 = src1;
        src1 = src2;
        src2 += srcpitch;
        --count;
    }
    dst0 += dstPitch;
    dst1 += dstPitch;
    dst2 += dstPitch;

    scale3x_16_def_whole(dst0, dst1, dst2, src0, src1, src1, width);
#else

    int looph, loopw;

    unsigned char* srcpix = srcPtr;
    unsigned char* dstpix = dstPtr;

    const int srcpitch = srcPitch;
    const int dstpitch = srcPitch*3;

    unsigned short E0, E1, E2, E3, E4, E5, E6, E7, E8;
    unsigned short A, B, C, D, E, F, G, H, I;
    for (looph = 0; looph < height; ++looph)
    {
        for (loopw = 0; loopw < width; ++ loopw)
        {
            A = *(unsigned short*)(srcpix + (MAX(0,looph-1)*srcpitch) + (2*MAX(0,loopw-1)));
            B = *(unsigned short*)(srcpix + (MAX(0,looph-1)*srcpitch) + (2*loopw));
            C = *(unsigned short*)(srcpix + (MAX(0,looph-1)*srcpitch) + (2*MIN(width-1,loopw+1)));
            D = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*MAX(0,loopw-1)));
            E = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*loopw));
            F = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*MIN(width-1,loopw+1)));
            G = *(unsigned short*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (2*MAX(0,loopw-1)));
            H = *(unsigned short*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (2*loopw));
            I = *(unsigned short*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (2*MIN(width-1,loopw+1)));

            if (B != H && D != F)
            {
                E0 = D == B ? D : E;
                E1 = (D == B && E != C) || (B == F && E != A) ? B : E;
                E2 = B == F ? F : E;
                E3 = (D == B && E != G) || (D == H && E != A) ? D : E;
                E4 = E;
                E5 = (B == F && E != I) || (H == F && E != C) ? F : E;
                E6 = D == H ? D : E;
                E7 = (D == H && E != I) || (H == F && E != G) ? H : E;
                E8 = H == F ? F : E;
            }
            else
            {
                E0 = E;
                E1 = E;
                E2 = E;
                E3 = E;
                E4 = E;
                E5 = E;
                E6 = E;
                E7 = E;
                E8 = E;
            }


            *(unsigned long*)(dstpix + looph*3*dstpitch + loopw*3*2) = E0;
            *(unsigned long*)(dstpix + looph*3*dstpitch + (loopw*3+1)*2) = E1;
            *(unsigned long*)(dstpix + looph*3*dstpitch + (loopw*3+2)*2) = E2;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + loopw*3*2) = E3;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + (loopw*3+1)*2) = E4;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + (loopw*3+2)*2) = E5;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + loopw*3*2) = E6;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + (loopw*3+1)*2) = E7;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + (loopw*3+2)*2) = E8;
        }
    }
#endif
}

void Scale3x_ex8(unsigned char* srcPtr, DWORD srcPitch,
                 unsigned char*  dstPtr, int width, int height)
{
#ifdef _WINDOWS
    int count = height;

	int srcpitch = srcPitch; // MOD2!!!
	int dstPitch = srcPitch * 3; // MOD2!!!

    unsigned long*  dst0 = (unsigned long*)dstPtr;
    unsigned long*  dst1 = dst0 + dstPitch;
    unsigned long*  dst2 = dst1 + dstPitch;

    unsigned long*  src0 = (unsigned long*)srcPtr;
    unsigned long*  src1 = src0 + srcpitch;
    unsigned long*  src2 = src1 + srcpitch;
    scale3x_32_def_whole(dst0, dst1, dst2, src0, src0, src1, width);
    dstPitch *= 3;
    count -= 2;
    while (count)
    {
        dst0 += dstPitch;
        dst1 += dstPitch;
        dst2 += dstPitch;

        scale3x_32_def_whole(dst0, dst1, dst2, src0, src1, src2, width);
        src0 = src1;
        src1 = src2;
        src2 += srcpitch;
        --count;
    }
    dst0 += dstPitch;
    dst1 += dstPitch;
    dst2 += dstPitch;

    scale3x_32_def_whole(dst0, dst1, dst2, src0, src1, src1, width);

#else

    int looph, loopw;

    unsigned char* srcpix = srcPtr;
    unsigned char* dstpix = dstPtr;

    const int srcpitch = srcPitch;
    const int dstpitch = srcPitch*3;

    unsigned long E0, E1, E2, E3, E4, E5, E6, E7, E8;
    unsigned long A, B, C, D, E, F, G, H, I;
    for (looph = 0; looph < height; ++looph)
    {
        for (loopw = 0; loopw < width; ++ loopw)
        {
            A = *(unsigned long*)(srcpix + (MAX(0,looph-1)*srcpitch) + (4*MAX(0,loopw-1)));
            B = *(unsigned long*)(srcpix + (MAX(0,looph-1)*srcpitch) + (4*loopw));
            C = *(unsigned long*)(srcpix + (MAX(0,looph-1)*srcpitch) + (4*MIN(width-1,loopw+1)));
            D = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*MAX(0,loopw-1)));
            E = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*loopw));
            F = *(unsigned long*)(srcpix + (looph*srcpitch) + (4*MIN(width-1,loopw+1)));
            G = *(unsigned long*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (4*MAX(0,loopw-1)));
            H = *(unsigned long*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (4*loopw));
            I = *(unsigned long*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (4*MIN(width-1,loopw+1)));

            if (B != H && D != F)
            {
                E0 = D == B ? D : E;
                E1 = (D == B && E != C) || (B == F && E != A) ? B : E;
                E2 = B == F ? F : E;
                E3 = (D == B && E != G) || (D == H && E != A) ? D : E;
                E4 = E;
                E5 = (B == F && E != I) || (H == F && E != C) ? F : E;
                E6 = D == H ? D : E;
                E7 = (D == H && E != I) || (H == F && E != G) ? H : E;
                E8 = H == F ? F : E;
            }
            else
            {
                E0 = E;
                E1 = E;
                E2 = E;
                E3 = E;
                E4 = E;
                E5 = E;
                E6 = E;
                E7 = E;
                E8 = E;
            }


            *(unsigned long*)(dstpix + looph*3*dstpitch + loopw*3*4) = E0;
            *(unsigned long*)(dstpix + looph*3*dstpitch + (loopw*3+1)*4) = E1;
            *(unsigned long*)(dstpix + looph*3*dstpitch + (loopw*3+2)*4) = E2;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + loopw*3*4) = E3;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + (loopw*3+1)*4) = E4;
            *(unsigned long*)(dstpix + (looph*3+1)*dstpitch + (loopw*3+2)*4) = E5;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + loopw*3*4) = E6;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + (loopw*3+1)*4) = E7;
            *(unsigned long*)(dstpix + (looph*3+2)*dstpitch + (loopw*3+2)*4) = E8;
        }
    }
#endif
}


////////////////////////////////////////////////////////////////////////

#define colorMask6     0x0000F7DE
#define lowPixelMask6  0x00000821
#define qcolorMask6    0x0000E79c
#define qlowpixelMask6 0x00001863

#define INTERPOLATE6(A, B) ((((A & colorMask6) >> 1) + ((B & colorMask6) >> 1) + (A & B & lowPixelMask6)))
#define Q_INTERPOLATE6(A, B, C, D) (((((A & qcolorMask6) >> 2) + ((B & qcolorMask6) >> 2) + ((C & qcolorMask6) >> 2) + ((D & qcolorMask6) >> 2) \
                                      + ((((A & qlowpixelMask6) + (B & qlowpixelMask6) + (C & qlowpixelMask6) + (D & qlowpixelMask6)) >> 2) & qlowpixelMask6))))

void Super2xSaI_ex6(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA0, colorA1, colorA2, colorA3,
          colorB0, colorB1, colorB2, colorB3,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------    B1 B2
                //                                         4  5  6 S2
                //                                         1  2  3 S1
                //                                           A1 A2
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}


                colorB0 = *(bP- iYA - iXA);
                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);
                colorB3 = *(bP- iYA + iXC);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA0 = *(bP + iYC - iXA);
                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);
                colorA3 = *(bP + iYC + iXC);

                //--------------------------------------
                if (color2 == color6 && color5 != color3)
                {
                    product2b = product1b = color2;
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1b = color5;
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6), (color5), (color1),  (colorA1));
                    r += GET_RESULT ((color6), (color5), (color4),  (colorB1));
                    r += GET_RESULT ((color6), (color5), (colorA2), (colorS1));
                    r += GET_RESULT ((color6), (color5), (colorB2), (colorS2));

                    if (r > 0)
                        product2b = product1b = color6;
                    else if (r < 0)
                        product2b = product1b = color5;
                    else
                    {
                        product2b = product1b = INTERPOLATE6 (color5, color6);
                    }
                }
                else
                {
                    if (color6 == color3 && color3 == colorA1 && color2 != colorA2 && color3 != colorA0)
                        product2b = Q_INTERPOLATE6 (color3, color3, color3, color2);
                    else if (color5 == color2 && color2 == colorA2 && colorA1 != color3 && color2 != colorA3)
                        product2b = Q_INTERPOLATE6 (color2, color2, color2, color3);
                    else
                        product2b = INTERPOLATE6 (color2, color3);

                    if (color6 == color3 && color6 == colorB1 && color5 != colorB2 && color6 != colorB0)
                        product1b = Q_INTERPOLATE6 (color6, color6, color6, color5);
                    else if (color5 == color2 && color5 == colorB2 && colorB1 != color6 && color5 != colorB3)
                        product1b = Q_INTERPOLATE6 (color6, color5, color5, color5);
                    else
                        product1b = INTERPOLATE6 (color5, color6);
                }

                if (color5 == color3 && color2 != color6 && color4 == color5 && color5 != colorA2)
                    product2a = INTERPOLATE6 (color2, color5);
                else if (color5 == color1 && color6 == color5 && color4 != color2 && color5 != colorA0)
                    product2a = INTERPOLATE6(color2, color5);
                else
                    product2a = color2;

                if (color2 == color6 && color5 != color3 && color1 == color2 && color2 != colorB2)
                    product1a = INTERPOLATE6(color2, color5);
                else if (color4 == color2 && color3 == color2 && color1 != color5 && color2 != colorB0)
                    product1a = INTERPOLATE6(color2, color5);
                else
                    product1a = color5;

                *dP=(unsigned short)product1a;
                *(dP+1)=(unsigned short)product1b;
                *(dP+(srcPitch))=(unsigned short)product2a;
                *(dP+1+(srcPitch))=(unsigned short)product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void Std2xSaI_ex6(unsigned char* srcPtr, DWORD srcPitch,
                  unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;

    DWORD colorA, colorB;
    DWORD colorC, colorD,
          colorE, colorF, colorG, colorH,
          colorI, colorJ, colorK, colorL,
          colorM, colorN, colorO, colorP;
    DWORD product, product1, product2;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------
                // Map of the pixels:                    I|E F|J
                //                                       G|A B|K
                //                                       H|C D|L
                //                                       M|N O|P
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorI = *(bP- iYA - iXA);
                colorE = *(bP- iYA);
                colorF = *(bP- iYA + iXB);
                colorJ = *(bP- iYA + iXC);

                colorG = *(bP  - iXA);
                colorA = *(bP);
                colorB = *(bP  + iXB);
                colorK = *(bP + iXC);

                colorH = *(bP  + iYB  - iXA);
                colorC = *(bP  + iYB);
                colorD = *(bP  + iYB  + iXB);
                colorL = *(bP  + iYB  + iXC);

                colorM = *(bP + iYC - iXA);
                colorN = *(bP + iYC);
                colorO = *(bP + iYC + iXB);
                colorP = *(bP + iYC + iXC);

                if ((colorA == colorD) && (colorB != colorC))
                {
                    if (((colorA == colorE) && (colorB == colorL)) ||
                        ((colorA == colorC) && (colorA == colorF) &&
                         (colorB != colorE) && (colorB == colorJ)))
                    {
                        product = colorA;
                    }
                    else
                    {
                        product = INTERPOLATE6(colorA, colorB);
                    }

                    if (((colorA == colorG) && (colorC == colorO)) ||
                        ((colorA == colorB) && (colorA == colorH) &&
                         (colorG != colorC) && (colorC == colorM)))
                    {
                        product1 = colorA;
                    }
                    else
                    {
                        product1 = INTERPOLATE6(colorA, colorC);
                    }
                    product2 = colorA;
                }
                else if ((colorB == colorC) && (colorA != colorD))
                {
                    if (((colorB == colorF) && (colorA == colorH)) ||
                        ((colorB == colorE) && (colorB == colorD) &&
                         (colorA != colorF) && (colorA == colorI)))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE6(colorA, colorB);
                    }

                    if (((colorC == colorH) && (colorA == colorF)) ||
                        ((colorC == colorG) && (colorC == colorD) &&
                         (colorA != colorH) && (colorA == colorI)))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1=INTERPOLATE6(colorA, colorC);
                    }
                    product2 = colorB;
                }
                else if ((colorA == colorD) && (colorB == colorC))
                {
                    if (colorA == colorB)
                    {
                        product = colorA;
                        product1 = colorA;
                        product2 = colorA;
                    }
                    else
                    {
                        register int r = 0;
                        product1 = INTERPOLATE6(colorA, colorC);
                        product = INTERPOLATE6(colorA, colorB);

                        r += GetResult1 (colorA, colorB, colorG, colorE, colorI);
                        r += GetResult2 (colorB, colorA, colorK, colorF, colorJ);
                        r += GetResult2 (colorB, colorA, colorH, colorN, colorM);
                        r += GetResult1 (colorA, colorB, colorL, colorO, colorP);

                        if (r > 0)
                            product2 = colorA;
                        else if (r < 0)
                            product2 = colorB;
                        else
                        {
                            product2 = Q_INTERPOLATE6(colorA, colorB, colorC, colorD);
                        }
                    }
                }
                else
                {
                    product2 = Q_INTERPOLATE6(colorA, colorB, colorC, colorD);

                    if ((colorA == colorC) && (colorA == colorF) &&
                        (colorB != colorE) && (colorB == colorJ))
                    {
                        product = colorA;
                    }
                    else if ((colorB == colorE) && (colorB == colorD) && (colorA != colorF) && (colorA == colorI))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE6(colorA, colorB);
                    }

                    if ((colorA == colorB) && (colorA == colorH) &&
                        (colorG != colorC) && (colorC == colorM))
                    {
                        product1 = colorA;
                    }
                    else if ((colorC == colorG) && (colorC == colorD) &&
                             (colorA != colorH) && (colorA == colorI))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1 = INTERPOLATE6(colorA, colorC);
                    }
                }

                *dP=(unsigned short)colorA;
                *(dP+1)=(unsigned short)product;
                *(dP+(srcPitch))=(unsigned short)product1;
                *(dP+1+(srcPitch))=(unsigned short)product2;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void SuperEagle_ex6(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA1, colorA2,
          colorB1, colorB2,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);

                if (color2 == color6 && color5 != color3)
                {
                    product1b = product2a = color2;
                    if ((color1 == color2) ||
                        (color6 == colorB2))
                    {
                        product1a = INTERPOLATE6(color2, color5);
                        product1a = INTERPOLATE6(color2, product1a);
                    }
                    else
                    {
                        product1a = INTERPOLATE6(color5, color6);
                    }

                    if ((color6 == colorS2) ||
                        (color2 == colorA1))
                    {
                        product2b = INTERPOLATE6(color2, color3);
                        product2b = INTERPOLATE6(color2, product2b);
                    }
                    else
                    {
                        product2b = INTERPOLATE6(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1a = color5;

                    if ((colorB1 == color5) ||
                        (color3 == colorS1))
                    {
                        product1b = INTERPOLATE6(color5, color6);
                        product1b = INTERPOLATE6(color5, product1b);
                    }
                    else
                    {
                        product1b = INTERPOLATE6(color5, color6);
                    }

                    if ((color3 == colorA2) ||
                        (color4 == color5))
                    {
                        product2a = INTERPOLATE6(color5, color2);
                        product2a = INTERPOLATE6(color5, product2a);
                    }
                    else
                    {
                        product2a = INTERPOLATE6(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6), (color5), (color1),  (colorA1));
                    r += GET_RESULT ((color6), (color5), (color4),  (colorB1));
                    r += GET_RESULT ((color6), (color5), (colorA2), (colorS1));
                    r += GET_RESULT ((color6), (color5), (colorB2), (colorS2));

                    if (r > 0)
                    {
                        product1b = product2a = color2;
                        product1a = product2b = INTERPOLATE6(color5, color6);
                    }
                    else if (r < 0)
                    {
                        product2b = product1a = color5;
                        product1b = product2a = INTERPOLATE6(color5, color6);
                    }
                    else
                    {
                        product2b = product1a = color5;
                        product1b = product2a = color2;
                    }
                }
                else
                {
                    product2b = product1a = INTERPOLATE6(color2, color6);
                    product2b = Q_INTERPOLATE6(color3, color3, color3, product2b);
                    product1a = Q_INTERPOLATE6(color5, color5, color5, product1a);

                    product2a = product1b = INTERPOLATE6(color5, color3);
                    product2a = Q_INTERPOLATE6(color2, color2, color2, product2a);
                    product1b = Q_INTERPOLATE6(color6, color6, color6, product1b);
                }

                *dP=(unsigned short)product1a;
                *(dP+1)=(unsigned short)product1b;
                *(dP+(srcPitch))=(unsigned short)product2a;
                *(dP+1+(srcPitch))=(unsigned short)product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

#ifndef MAX
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#define MIN(a,b)    (((a) < (b)) ? (a) : (b))
#endif

void Scale2x_ex6_5(unsigned char* srcPtr, DWORD srcPitch,
                   unsigned char*  dstBitmap, int width, int height)
{
    int looph, loopw;

	srcPitch *= 2; // MOD2!!!

    unsigned char* srcpix = srcPtr;
    unsigned char* dstpix = dstBitmap;

    const int srcpitch = srcPitch;
    const int dstpitch = srcPitch<<1;

    unsigned short E0, E1, E2, E3, B, D, E, F, H;
    for (looph = 0; looph < height; ++looph)
    {
        for (loopw = 0; loopw < width; ++ loopw)
        {
            B = *(unsigned short*)(srcpix + (MAX(0,looph-1)*srcpitch) + (2*loopw));
            D = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*MAX(0,loopw-1)));
            E = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*loopw));
            F = *(unsigned short*)(srcpix + (looph*srcpitch) + (2*MIN(width-1,loopw+1)));
            H = *(unsigned short*)(srcpix + (MIN(height-1,looph+1)*srcpitch) + (2*loopw));

            if (B != H && D != F)
            {
                E0 = D == B ? D : E;
                E1 = B == F ? F : E;
                E2 = D == H ? D : E;
                E3 = H == F ? F : E;
            }
            else
            {
                E0 = E;
                E1 = E;
                E2 = E;
                E3 = E;
            }


            *(unsigned short*)(dstpix + looph*2*dstpitch + loopw*2*2) = E0;
            *(unsigned short*)(dstpix + looph*2*dstpitch + (loopw*2+1)*2) = E1;
            *(unsigned short*)(dstpix + (looph*2+1)*dstpitch + loopw*2*2) = E2;
            *(unsigned short*)(dstpix + (looph*2+1)*dstpitch + (loopw*2+1)*2) = E3;
        }
    }
}

////////////////////////////////////////////////////////////////////////





////////////////////////////////////////////////////////////////////////

/*
#define colorMask5     0x0000F7DE
#define lowPixelMask5  0x00000821
#define qcolorMask5    0x0000E79c
#define qlowpixelMask5 0x00001863
*/

#define colorMask5     0x00007BDE
#define lowPixelMask5  0x00000421
#define qcolorMask5    0x0000739c
#define qlowpixelMask5 0x00000C63

#define INTERPOLATE5(A, B) ((((A & colorMask5) >> 1) + ((B & colorMask5) >> 1) + (A & B & lowPixelMask5)))
#define Q_INTERPOLATE5(A, B, C, D) (((((A & qcolorMask5) >> 2) + ((B & qcolorMask5) >> 2) + ((C & qcolorMask5) >> 2) + ((D & qcolorMask5) >> 2) \
                                      + ((((A & qlowpixelMask5) + (B & qlowpixelMask5) + (C & qlowpixelMask5) + (D & qlowpixelMask5)) >> 2) & qlowpixelMask5))))

void Super2xSaI_ex5(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA0, colorA1, colorA2, colorA3,
          colorB0, colorB1, colorB2, colorB3,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------    B1 B2
                //                                         4  5  6 S2
                //                                         1  2  3 S1
                //                                           A1 A2
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}


                colorB0 = *(bP- iYA - iXA);
                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);
                colorB3 = *(bP- iYA + iXC);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA0 = *(bP + iYC - iXA);
                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);
                colorA3 = *(bP + iYC + iXC);

                //--------------------------------------
                if (color2 == color6 && color5 != color3)
                {
                    product2b = product1b = color2;
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1b = color5;
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6), (color5), (color1),  (colorA1));
                    r += GET_RESULT ((color6), (color5), (color4),  (colorB1));
                    r += GET_RESULT ((color6), (color5), (colorA2), (colorS1));
                    r += GET_RESULT ((color6), (color5), (colorB2), (colorS2));

                    if (r > 0)
                        product2b = product1b = color6;
                    else if (r < 0)
                        product2b = product1b = color5;
                    else
                    {
                        product2b = product1b = INTERPOLATE5 (color5, color6);
                    }
                }
                else
                {
                    if (color6 == color3 && color3 == colorA1 && color2 != colorA2 && color3 != colorA0)
                        product2b = Q_INTERPOLATE5 (color3, color3, color3, color2);
                    else if (color5 == color2 && color2 == colorA2 && colorA1 != color3 && color2 != colorA3)
                        product2b = Q_INTERPOLATE5 (color2, color2, color2, color3);
                    else
                        product2b = INTERPOLATE5 (color2, color3);

                    if (color6 == color3 && color6 == colorB1 && color5 != colorB2 && color6 != colorB0)
                        product1b = Q_INTERPOLATE5 (color6, color6, color6, color5);
                    else if (color5 == color2 && color5 == colorB2 && colorB1 != color6 && color5 != colorB3)
                        product1b = Q_INTERPOLATE5 (color6, color5, color5, color5);
                    else
                        product1b = INTERPOLATE5 (color5, color6);
                }

                if (color5 == color3 && color2 != color6 && color4 == color5 && color5 != colorA2)
                    product2a = INTERPOLATE5 (color2, color5);
                else if (color5 == color1 && color6 == color5 && color4 != color2 && color5 != colorA0)
                    product2a = INTERPOLATE5(color2, color5);
                else
                    product2a = color2;

                if (color2 == color6 && color5 != color3 && color1 == color2 && color2 != colorB2)
                    product1a = INTERPOLATE5(color2, color5);
                else if (color4 == color2 && color3 == color2 && color1 != color5 && color2 != colorB0)
                    product1a = INTERPOLATE5(color2, color5);
                else
                    product1a = color5;

                *dP=(unsigned short)product1a;
                *(dP+1)=(unsigned short)product1b;
                *(dP+(srcPitch))=(unsigned short)product2a;
                *(dP+1+(srcPitch))=(unsigned short)product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void Std2xSaI_ex5(unsigned char* srcPtr, DWORD srcPitch,
                  unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD colorA, colorB;
    DWORD colorC, colorD,
          colorE, colorF, colorG, colorH,
          colorI, colorJ, colorK, colorL,
          colorM, colorN, colorO, colorP;
    DWORD product, product1, product2;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                //---------------------------------------
                // Map of the pixels:                    I|E F|J
                //                                       G|A B|K
                //                                       H|C D|L
                //                                       M|N O|P
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorI = *(bP- iYA - iXA);
                colorE = *(bP- iYA);
                colorF = *(bP- iYA + iXB);
                colorJ = *(bP- iYA + iXC);

                colorG = *(bP  - iXA);
                colorA = *(bP);
                colorB = *(bP  + iXB);
                colorK = *(bP + iXC);

                colorH = *(bP  + iYB  - iXA);
                colorC = *(bP  + iYB);
                colorD = *(bP  + iYB  + iXB);
                colorL = *(bP  + iYB  + iXC);

                colorM = *(bP + iYC - iXA);
                colorN = *(bP + iYC);
                colorO = *(bP + iYC + iXB);
                colorP = *(bP + iYC + iXC);

                if ((colorA == colorD) && (colorB != colorC))
                {
                    if (((colorA == colorE) && (colorB == colorL)) ||
                        ((colorA == colorC) && (colorA == colorF) &&
                         (colorB != colorE) && (colorB == colorJ)))
                    {
                        product = colorA;
                    }
                    else
                    {
                        product = INTERPOLATE5(colorA, colorB);
                    }

                    if (((colorA == colorG) && (colorC == colorO)) ||
                        ((colorA == colorB) && (colorA == colorH) &&
                         (colorG != colorC) && (colorC == colorM)))
                    {
                        product1 = colorA;
                    }
                    else
                    {
                        product1 = INTERPOLATE5(colorA, colorC);
                    }
                    product2 = colorA;
                }
                else if ((colorB == colorC) && (colorA != colorD))
                {
                    if (((colorB == colorF) && (colorA == colorH)) ||
                        ((colorB == colorE) && (colorB == colorD) &&
                         (colorA != colorF) && (colorA == colorI)))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE5(colorA, colorB);
                    }

                    if (((colorC == colorH) && (colorA == colorF)) ||
                        ((colorC == colorG) && (colorC == colorD) &&
                         (colorA != colorH) && (colorA == colorI)))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1=INTERPOLATE5(colorA, colorC);
                    }
                    product2 = colorB;
                }
                else if ((colorA == colorD) && (colorB == colorC))
                {
                    if (colorA == colorB)
                    {
                        product = colorA;
                        product1 = colorA;
                        product2 = colorA;
                    }
                    else
                    {
                        register int r = 0;
                        product1 = INTERPOLATE5(colorA, colorC);
                        product = INTERPOLATE5(colorA, colorB);

                        r += GetResult1 (colorA, colorB, colorG, colorE, colorI);
                        r += GetResult2 (colorB, colorA, colorK, colorF, colorJ);
                        r += GetResult2 (colorB, colorA, colorH, colorN, colorM);
                        r += GetResult1 (colorA, colorB, colorL, colorO, colorP);

                        if (r > 0)
                            product2 = colorA;
                        else if (r < 0)
                            product2 = colorB;
                        else
                        {
                            product2 = Q_INTERPOLATE5(colorA, colorB, colorC, colorD);
                        }
                    }
                }
                else
                {
                    product2 = Q_INTERPOLATE5(colorA, colorB, colorC, colorD);

                    if ((colorA == colorC) && (colorA == colorF) &&
                        (colorB != colorE) && (colorB == colorJ))
                    {
                        product = colorA;
                    }
                    else if ((colorB == colorE) && (colorB == colorD) && (colorA != colorF) && (colorA == colorI))
                    {
                        product = colorB;
                    }
                    else
                    {
                        product = INTERPOLATE5(colorA, colorB);
                    }

                    if ((colorA == colorB) && (colorA == colorH) &&
                        (colorG != colorC) && (colorC == colorM))
                    {
                        product1 = colorA;
                    }
                    else if ((colorC == colorG) && (colorC == colorD) &&
                             (colorA != colorH) && (colorA == colorI))
                    {
                        product1 = colorC;
                    }
                    else
                    {
                        product1 = INTERPOLATE5(colorA, colorC);
                    }
                }

                *dP=(unsigned short)colorA;
                *(dP+1)=(unsigned short)product;
                *(dP+(srcPitch))=(unsigned short)product1;
                *(dP+1+(srcPitch))=(unsigned short)product2;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////

void SuperEagle_ex5(unsigned char* srcPtr, DWORD srcPitch,
                    unsigned char*  dstBitmap, int width, int height)
{
	srcPitch *= 2; // MOD2!!!

    DWORD dstPitch        = srcPitch<<1;
    int   finWidth        = srcPitch>>1;
    DWORD line;
    unsigned short* dP;
    unsigned short* bP;
    int iXA,iXB,iXC,iYA,iYB,iYC,finish;
    DWORD color4, color5, color6;
    DWORD color1, color2, color3;
    DWORD colorA1, colorA2,
          colorB1, colorB2,
          colorS1, colorS2;
    DWORD product1a, product1b,
          product2a, product2b;

    line = 0;

    {
        for (; height; height-=1)
        {
            bP = (unsigned short*)srcPtr;
            dP = (unsigned short*)(dstBitmap + line*dstPitch);
            for (finish = width; finish; finish -= 1 )
            {
                if (finish==finWidth) iXA=0;
                else                 iXA=1;
                if (finish>4) {iXB=1; iXC=2;}
                else if (finish>3) {iXB=1; iXC=1;}
                else         {iXB=0; iXC=0;}
                if (line==0) iYA=0;
                else        iYA=finWidth;
                if (height>4) {iYB=finWidth; iYC=srcPitch;}
                else if (height>3) {iYB=finWidth; iYC=finWidth;}
                else         {iYB=0; iYC=0;}

                colorB1 = *(bP- iYA);
                colorB2 = *(bP- iYA + iXB);

                color4 = *(bP  - iXA);
                color5 = *(bP);
                color6 = *(bP  + iXB);
                colorS2 = *(bP + iXC);

                color1 = *(bP  + iYB  - iXA);
                color2 = *(bP  + iYB);
                color3 = *(bP  + iYB  + iXB);
                colorS1= *(bP  + iYB  + iXC);

                colorA1 = *(bP + iYC);
                colorA2 = *(bP + iYC + iXB);

                if (color2 == color6 && color5 != color3)
                {
                    product1b = product2a = color2;
                    if ((color1 == color2) ||
                        (color6 == colorB2))
                    {
                        product1a = INTERPOLATE5(color2, color5);
                        product1a = INTERPOLATE5(color2, product1a);
                    }
                    else
                    {
                        product1a = INTERPOLATE5(color5, color6);
                    }

                    if ((color6 == colorS2) ||
                        (color2 == colorA1))
                    {
                        product2b = INTERPOLATE5(color2, color3);
                        product2b = INTERPOLATE5(color2, product2b);
                    }
                    else
                    {
                        product2b = INTERPOLATE5(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 != color6)
                {
                    product2b = product1a = color5;

                    if ((colorB1 == color5) ||
                        (color3 == colorS1))
                    {
                        product1b = INTERPOLATE5(color5, color6);
                        product1b = INTERPOLATE5(color5, product1b);
                    }
                    else
                    {
                        product1b = INTERPOLATE5(color5, color6);
                    }

                    if ((color3 == colorA2) ||
                        (color4 == color5))
                    {
                        product2a = INTERPOLATE5(color5, color2);
                        product2a = INTERPOLATE5(color5, product2a);
                    }
                    else
                    {
                        product2a = INTERPOLATE5(color2, color3);
                    }
                }
                else if (color5 == color3 && color2 == color6)
                {
                    register int r = 0;

                    r += GET_RESULT ((color6), (color5), (color1),  (colorA1));
                    r += GET_RESULT ((color6), (color5), (color4),  (colorB1));
                    r += GET_RESULT ((color6), (color5), (colorA2), (colorS1));
                    r += GET_RESULT ((color6), (color5), (colorB2), (colorS2));

                    if (r > 0)
                    {
                        product1b = product2a = color2;
                        product1a = product2b = INTERPOLATE5(color5, color6);
                    }
                    else if (r < 0)
                    {
                        product2b = product1a = color5;
                        product1b = product2a = INTERPOLATE5(color5, color6);
                    }
                    else
                    {
                        product2b = product1a = color5;
                        product1b = product2a = color2;
                    }
                }
                else
                {
                    product2b = product1a = INTERPOLATE5(color2, color6);
                    product2b = Q_INTERPOLATE5(color3, color3, color3, product2b);
                    product1a = Q_INTERPOLATE5(color5, color5, color5, product1a);

                    product2a = product1b = INTERPOLATE5(color5, color3);
                    product2a = Q_INTERPOLATE5(color2, color2, color2, product2a);
                    product1b = Q_INTERPOLATE5(color6, color6, color6, product1b);
                }

                *dP=(unsigned short)product1a;
                *(dP+1)=(unsigned short)product1b;
                *(dP+(srcPitch))=(unsigned short)product2a;
                *(dP+1+(srcPitch))=(unsigned short)product2b;

                bP += 1;
                dP += 2;
            }//end of for ( finish= width etc..)

            line += 2;
            srcPtr += srcPitch;
        }; //endof: for (; height; height--)
    }
}

////////////////////////////////////////////////////////////////////////
// Win code starts here
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////
// own swap buffer func (window/fullscreen)
////////////////////////////////////////////////////////////////////////

sDX            DX;
static DDSURFACEDESC       ddsd;
GUID           guiDev;
BOOL           bDeviceOK;
HWND           hWGPU;
int			   iSysMemory=0;
int            iFPSEInterface=0;
int			   iRefreshRate;
BOOL		   bVsync=FALSE;
BOOL		   bVsync_Key=FALSE;

// MOD2!!!
int getSurfaceWidth()
{
	return ddsd.dwWidth;
}
int getSurfaceHeight()
{
	return ddsd.dwHeight;
}
int getSurfacePitch()
{
	return ddsd.lPitch;
}
// MOD2!!!

void(*BlitScreen) (unsigned char *, long, long);
void(*p2XSaIFunc) (unsigned char *, DWORD, unsigned char *, int, int);

////////////////////////////////////////////////////////////////////////

static __inline void WaitVBlank(void)
{
    if (bVsync_Key)
    {
        IDirectDraw2_WaitForVerticalBlank(DX.DD,DDWAITVB_BLOCKBEGIN,0);
    }
}

// MOD2!!!
void blitScreen15Pitch(unsigned char *surf, long x, long y, LONG lPitch)
{
	unsigned long lu;
	unsigned short row, column;
	unsigned short dx = (unsigned short)PreviousPSXDisplay.Range.x1;
	unsigned short dy = (unsigned short)PreviousPSXDisplay.DisplayMode.y;

	if (PreviousPSXDisplay.Range.y0) // centering needed?
	{
		surf += PreviousPSXDisplay.Range.y0 * lPitch;
		dy -= PreviousPSXDisplay.Range.y0;
	}

	if (PSXDisplay.RGB24)
	{
		unsigned char *pD;
		unsigned int startxy;

		surf += PreviousPSXDisplay.Range.x0 << 1;

		if (iFPSEInterface)
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned short *)((surf)+(column * lPitch) + (row << 1))) = (unsigned short)(((BLUE(lu) << 7) & 0x7c00) | ((GREEN(lu) << 2) & 0x3e0) | (RED(lu) >> 3));
					pD += 3;
				}
			}
		}
		else
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned short *)((surf)+(column * lPitch) + (row << 1))) = (unsigned short)(((RED(lu) << 7) & 0x7c00) | ((GREEN(lu) << 2) & 0x3e0) | (BLUE(lu) >> 3));
					pD += 3;
				}
			}
		}
	}
	else
	{
		unsigned short LineOffset, SurfOffset;
		unsigned long *SRCPtr = (unsigned long *)(psxVuw + (y << 10) + x);
		unsigned long *DSTPtr = ((unsigned long *)surf) + (PreviousPSXDisplay.Range.x0 >> 1);

		dx >>= 1;

		LineOffset = 512 - dx;
		SurfOffset = (lPitch >> 2) - dx;

		for (column = 0; column<dy; column++)
		{
			for (row = 0; row<dx; row++)
			{
				lu = *SRCPtr++;

				*DSTPtr++ = ((lu << 10) & 0x7c007c00) | ((lu)& 0x3e003e0) | ((lu >> 10) & 0x1f001f);
			}
			SRCPtr += LineOffset;
			DSTPtr += SurfOffset;
		}
	}
}

void blitScreen16Pitch(unsigned char *surf, long x, long y, LONG lPitch)
{
	unsigned long lu;
	unsigned short row, column;
	unsigned short dx = (unsigned short)PreviousPSXDisplay.Range.x1;
	unsigned short dy = (unsigned short)PreviousPSXDisplay.DisplayMode.y;

	if (PreviousPSXDisplay.Range.y0) // centering needed?
	{
		surf += PreviousPSXDisplay.Range.y0 * lPitch;
		dy -= PreviousPSXDisplay.Range.y0;
	}

	if (PSXDisplay.RGB24)
	{
		unsigned char *pD;
		unsigned int startxy;

		surf += PreviousPSXDisplay.Range.x0 << 1;

		if (iFPSEInterface)
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned short *)((surf)+(column * lPitch) + (row << 1))) = (unsigned short)(((BLUE(lu) << 8) & 0xf800) | ((GREEN(lu) << 3) & 0x7e0) | (RED(lu) >> 3));
					pD += 3;
				}
			}
		}
		else
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned short *)((surf)+(column * lPitch) + (row << 1))) = (unsigned short)(((RED(lu) << 8) & 0xf800) | ((GREEN(lu) << 3) & 0x7e0) | (BLUE(lu) >> 3));
					pD += 3;
				}
			}
		}
	}
	else
	{
		unsigned short LineOffset, SurfOffset;
		unsigned long *SRCPtr = (unsigned long *)(psxVuw + (y << 10) + x);
		unsigned long *DSTPtr = ((unsigned long *)surf) + (PreviousPSXDisplay.Range.x0 >> 1);

		dx >>= 1;

		LineOffset = 512 - dx;
		SurfOffset = (lPitch >> 2) - dx;

		for (column = 0; column<dy; column++)
		{
			for (row = 0; row<dx; row++)
			{
				lu = *SRCPtr++;

				*DSTPtr++ = ((lu << 11) & 0xf800f800) | ((lu << 1) & 0x7c007c0) | ((lu >> 10) & 0x1f001f);
			}
			SRCPtr += LineOffset;
			DSTPtr += SurfOffset;
		}
	}
}

void blitScreen32Pitch(unsigned char *surf, long x, long y, LONG lPitch)
{
	unsigned char *pD;
	unsigned long lu;
	unsigned short s;
	unsigned int startxy;
	short row, column;
	short dx = (short)PreviousPSXDisplay.Range.x1;
	short dy = (short)PreviousPSXDisplay.DisplayMode.y;

	if (PreviousPSXDisplay.Range.y0) // centering needed?
	{
		surf += PreviousPSXDisplay.Range.y0 * lPitch;
		dy -= PreviousPSXDisplay.Range.y0;
	}

	surf += PreviousPSXDisplay.Range.x0 << 2;

	if (PSXDisplay.RGB24)
	{
		if (iFPSEInterface)
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned long *)((surf)+(column * lPitch) + row * 4)) = 0xff000000 | (BLUE(lu) << 16) | (GREEN(lu) << 8) | (RED(lu));
					pD += 3;
				}
			}
		}
		else
		{
			for (column = 0; column<dy; column++)
			{
				startxy = ((1024)*(column + y)) + x;
				pD = (unsigned char *)&psxVuw[startxy];

				for (row = 0; row<dx; row++)
				{
					lu = *((unsigned long *)pD);
					*((unsigned long *)((surf)+(column * lPitch) + row * 4)) = 0xff000000 | (RED(lu) << 16) | (GREEN(lu) << 8) | (BLUE(lu));
					pD += 3;
				}
			}
		}
	}
	else
	{
		for (column = 0; column<dy; column++)
		{
			startxy = ((1024)*(column + y)) + x;
			for (row = 0; row<dx; row++)
			{
				s = psxVuw[startxy++];
				*((unsigned long *)((surf)+(column * lPitch) + row * 4)) = ((((s << 19) & 0xf80000) | ((s << 6) & 0xf800) | ((s >> 7) & 0xf8)) & 0xffffff) | 0xff000000;
			}
		}
	}
}

unsigned long isMenuOn()
{
	return ulKeybits & KEY_SHOWFPS;
}

extern LPCTSTR getScreenMode();

#define MAX_MENU 128

char menuText[MAX_MENU + 1];

void toggleExtendedMenu()
{
	showExtendedMenu = (showExtendedMenu == 0) ? 1 : 0;

	DoClearScreenBuffer();
}

void drawMenu()
{
	if (!isMenuOn()) return;

	menuText[MAX_MENU] = 0;

	int y = overscan0;
	int height = fontEnvironment.font->height;
	int height2 = height + (height >> 1);

	_snprintf(menuText, MAX_MENU, "%s%s", szDispBuf, szMenuBuf);
	drawText(0, y, menuText, &fontEnvironment);
	y += height2;

	if (!showExtendedMenu) return;

	_snprintf(menuText, MAX_MENU, "Internal resolution: %d x %d%s", PreviousPSXDisplay.DisplayMode.x, PreviousPSXDisplay.DisplayMode.y, PSXDisplay.RGB24 ? " RGB24" : "");
	drawText(0, y, menuText, &fontEnvironment);
	y += height2;

	char *aspectRatioMode = "Custom";
	if (isStretched == 1) aspectRatioMode = "Stretch";
	if (isStretched == 2) aspectRatioMode = "4/3";

	_snprintf(menuText, MAX_MENU, "Resize: %s, %s, %s", aspectRatioMode, getScreenMode(), getResize());
	drawText(0, y, menuText, &fontEnvironment);
	y += height;

	_snprintf(menuText, MAX_MENU, "Backbuffer: %d x %d x %d (%d)", getSurfaceWidth(), getSurfaceHeight(), getSurfaceDepth(), getSurfacePitch());
	drawText(0, y, menuText, &fontEnvironment);
	y += height;

	return;

	if (!iWindowMode)
	{
		if (iRefreshRate == 0)
		{
			_snprintf(menuText, MAX_MENU, "Fullscreen: %d x %d", iResX, iResY);
		}
		else
		{
			_snprintf(menuText, MAX_MENU, "Fullscreen: %d x %d  %d Hz", iResX, iResY, iRefreshRate);
		}
		drawText(0, y, menuText, &fontEnvironment);
		y += height;
	}

	_snprintf(menuText, MAX_MENU, "%s", (cooperativeLevel == 0) ? "DDSCL_NORMAL" : "DDSCL_EXCLUSIVE");
	drawText(0, y, menuText, &fontEnvironment);
	y += height;

	_snprintf(menuText, MAX_MENU, "Blit: %s", getBlit());
	drawText(0, y, menuText, &fontEnvironment);
	y += height;

	_snprintf(menuText, MAX_MENU, "Range: (%d, %d) (%d, %d)", PreviousPSXDisplay.Range.x0, PreviousPSXDisplay.Range.y0, PreviousPSXDisplay.Range.x1, PreviousPSXDisplay.Range.y1);
	drawText(0, y, menuText, &fontEnvironment);
	y += height;

	for (int p = 0; p < 8; p++)
	{
		if (usCursorActive & (1 << p))
		{
			_snprintf(menuText, MAX_MENU, "Gun[%d]: (%d, %d)", p, ptCursorPoint[p].x, ptCursorPoint[p].y);
			drawText(0, y, menuText, &fontEnvironment);
			y += height;
		}
	}
}

void drawDebugBitmap()
{
	if (!showDebugBitmap) return;

	unsigned char *debugBitmap = debugBitmap32;

	if (fontEnvironment.depth == 16)
	{
		debugBitmap = debugBitmap16;
	}
	else if (fontEnvironment.depth == 15)
	{
		debugBitmap = debugBitmap15;
	}

	drawBitmap(PreviousPSXDisplay.DisplayMode.x - DEBUG_BITMAP_W, overscan0, DEBUG_BITMAP_W, DEBUG_BITMAP_H, debugBitmap, &fontEnvironment);
}

long getMin(long a, long b)
{
	if (a < b)
		return a;
	else
		return b;
}

void drawRectangle(int xStart, int yStart, int width, int height, struct ExtraClipper *extraClipper)
{
	for (int y = 0; y < height; y++)
	{
		for (int x = 0; x < width; x++)
		{
			drawPixel(xStart + x, yStart + y, extraClipper, &fontEnvironment);
		}
	}
}

void drawGuns()
{
	if (!usCursorActive) return;

	struct ExtraClipper extraClipper =
	{
		PreviousPSXDisplay.Range.x0,
		PreviousPSXDisplay.Range.y0,
		getMin(PreviousPSXDisplay.Range.x0 + PreviousPSXDisplay.Range.x1 - 1, PreviousPSXDisplay.DisplayMode.x - 1),
		PreviousPSXDisplay.DisplayMode.y - 1
	};

	//drawPixel(extraClipper.xStart, extraClipper.yStart, NULL, &fontEnvironment);
	//drawPixel(extraClipper.xStart, extraClipper.yEnd, NULL, &fontEnvironment);
	//drawPixel(extraClipper.xEnd, extraClipper.yStart, NULL, &fontEnvironment);
	//drawPixel(extraClipper.xEnd, extraClipper.yEnd, NULL, &fontEnvironment);

	for (int p = 0; p < 8; p++)
	{
		if (usCursorActive & (1 << p))
		{
			long x = ptCursorPoint[p].x;
			long y = ptCursorPoint[p].y;

			long maxX = PreviousPSXDisplay.DisplayMode.x - 1;
			long maxY = PreviousPSXDisplay.DisplayMode.y - 1;

			x = x * maxX / 511;
			y = y * maxY / 255;

			drawRectangle(x - 1, y - 1, 3, 3, &extraClipper);
			drawRectangle(x - 1, y - 5, 3, 3, &extraClipper);
			drawRectangle(x - 1, y + 3, 3, 3, &extraClipper);
			drawRectangle(x - 5, y - 1, 3, 3, &extraClipper);
			drawRectangle(x + 3, y - 1, 3, 3, &extraClipper);
		}
	}
}

void drawExtras()
{
	drawMenu();
	drawDebugBitmap();
	drawGuns();
}

int isEnvironmentRequired()
{
	return isMenuOn() || showDebugBitmap || usCursorActive;
}

void setSmallEnvironment(int depth, int pitch)
{
	setFontEnvironment(&fontEnvironment, (unsigned char *)pSaISmallBuff, SMALL_WIDTH, 512, depth, pitch, &defaultFont);
}

void setDirectEnvironment(int depth)
{
	setFontEnvironment(&fontEnvironment, (unsigned char *)ddsd.lpSurface, ddsd.dwWidth, ddsd.dwHeight, depth, ddsd.lPitch, &defaultFont);
}

void smallBlitScreen15(long x, long y)
{
	blitScreen15Pitch((unsigned char *)pSaISmallBuff, x, y, SMALL_WIDTH * 2);

	if (isEnvironmentRequired())
	{
		setSmallEnvironment(15, SMALL_WIDTH * 2);
		drawExtras();
	}
}

void smallBlitScreen16(long x, long y)
{
	blitScreen16Pitch((unsigned char *)pSaISmallBuff, x, y, SMALL_WIDTH * 2);

	if (isEnvironmentRequired())
	{
		setSmallEnvironment(16, SMALL_WIDTH * 2);
		drawExtras();
	}
}

void smallBlitScreen32(long x, long y)
{
	blitScreen32Pitch((unsigned char *)pSaISmallBuff, x, y, SMALL_WIDTH * 4);

	if (isEnvironmentRequired())
	{
		setSmallEnvironment(32, SMALL_WIDTH * 4);
		drawExtras();
	}
}

void BlitScreen15(unsigned char *surf, long x, long y)
{
	blitScreen15Pitch(surf, x, y, ddsd.lPitch);

	if (isEnvironmentRequired())
	{
		setDirectEnvironment(15);
		drawExtras();
	}
}

void BlitScreen16(unsigned char *surf, long x, long y)
{
	blitScreen16Pitch(surf, x, y, ddsd.lPitch);

	if (isEnvironmentRequired())
	{
		setDirectEnvironment(16);
		drawExtras();
	}
}

void BlitScreen32(unsigned char *surf, long x, long y)
{
	blitScreen32Pitch(surf, x, y, ddsd.lPitch);

	if (isEnvironmentRequired())
	{
		setDirectEnvironment(32);
		drawExtras();
	}
}

void resizeAndBlit(unsigned char *surf, long scale, long is16)
{
	p2XSaIFunc((unsigned char *)pSaISmallBuff, SMALL_WIDTH, (unsigned char *)pSaIBigBuff, PreviousPSXDisplay.DisplayMode.x, PreviousPSXDisplay.DisplayMode.y);

	short dx = (short)(PreviousPSXDisplay.DisplayMode.x * scale) >> is16;
	short dy = (short)(PreviousPSXDisplay.DisplayMode.y * scale);

	unsigned int off1 = (ddsd.lPitch >> 2) - dx;
	unsigned int off2 = ((SMALL_WIDTH * scale) >> is16) - dx;

	unsigned long *pS1 = (unsigned long *)surf;
	unsigned long *pS2 = (unsigned long *)pSaIBigBuff;

	short row, column;
	for (column = 0; column<dy; column++)
	{
		for (row = 0; row<dx; row++)
		{
			*(pS1++) = *(pS2++);
		}
		pS1 += off1;
		pS2 += off2;
	}
}

void BlitScreen15_2x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen15(surf, x, y);
		return;
	}

	smallBlitScreen15(x, y);

	resizeAndBlit(surf, 2, 1);
}

void BlitScreen15_3x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen15(surf, x, y);
		return;
	}

	smallBlitScreen15(x, y);

	resizeAndBlit(surf, 3, 1);
}

void BlitScreen16_2x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen16(surf, x, y);
		return;
	}

	smallBlitScreen16(x, y);

	resizeAndBlit(surf, 2, 1);
}

void BlitScreen16_3x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen16(surf, x, y);
		return;
	}

	smallBlitScreen16(x, y);

	resizeAndBlit(surf, 3, 1);
}

void BlitScreen32_2x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen32(surf, x, y);
		return;
	}

	smallBlitScreen32(x, y);

	resizeAndBlit(surf, 2, 0);
}

void BlitScreen32_3x(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen32(surf, x, y);
		return;
	}

	smallBlitScreen32(x, y);

	resizeAndBlit(surf, 3, 0);
}

void BlitScreen32_xbrz(unsigned char *surf, long x, long y)
{
	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		BlitScreen32(surf, x, y);
		return;
	}

	smallBlitScreen16(x, y);

	ddsd_lPitch = ddsd.lPitch;

	p2XSaIFunc((unsigned char *)pSaISmallBuff, SMALL_WIDTH, (unsigned char *)surf, PreviousPSXDisplay.DisplayMode.x, PreviousPSXDisplay.DisplayMode.y);
}
// MOD2!!!

////////////////////////////////////////////////////////////////////////

void DoClearScreenBuffer(void) // CLEAR DX BUFFER
{
	DDBLTFX ddbltfx;

	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0x00000000;

	IDirectDrawSurface_Blt(DX.DDSRender, NULL, NULL, NULL, DDBLT_COLORFILL, &ddbltfx);

	// MOD2!!!
	if (pSaISmallBuff != NULL)
	{
		long smallSize = SMALL_WIDTH * 512 * 4;

		memset(pSaISmallBuff, 0, smallSize);
	}
	// MOD2!!!
}

////////////////////////////////////////////////////////////////////////

void DoClearFrontBuffer(void) // CLEAR PRIMARY BUFFER
{
	DDBLTFX ddbltfx;

	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0x00000000;

	IDirectDrawSurface_Blt(DX.DDSPrimary, NULL, NULL, NULL, DDBLT_COLORFILL, &ddbltfx);
}

////////////////////////////////////////////////////////////////////////

// MOD2!!!
void fullscreenBlit(long scale)
{
	RECT ViewportRect = { 0, 0, PreviousPSXDisplay.DisplayMode.x, PreviousPSXDisplay.DisplayMode.y };

	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		ViewportRect.top += overscan0;
		ViewportRect.bottom -= overscan1;
	}
	else
	{
		ViewportRect.right *= scale;
		ViewportRect.bottom *= scale;
		ViewportRect.top += scale * overscan0;
		ViewportRect.bottom -= scale * overscan1;
	}

	WaitVBlank();
	IDirectDrawSurface_Blt(DX.DDSPrimary, (isStretched == 0) ? &correctedResolution : ((isStretched == 1) ? &stretchedResolution : &correctedResolution2), DX.DDSRender, &ViewportRect, DDBLT_WAIT, NULL);
}
// MOD2!!!

// MOD2!!!
void windowBlit(long scale)
{
	RECT ViewportRect = { 0, 0, PreviousPSXDisplay.DisplayMode.x, PreviousPSXDisplay.DisplayMode.y };

	POINT Point = { 0, 0 };
	ClientToScreen(DX.hWnd, &Point);

	RECT ScreenRect;
	GetClientRect(DX.hWnd, &ScreenRect);
	ScreenRect.left += Point.x;
	ScreenRect.right += Point.x;
	ScreenRect.top += Point.y;
	ScreenRect.bottom += Point.y;

	if (PreviousPSXDisplay.DisplayMode.x > SMALL_WIDTH)
	{
		ViewportRect.top += overscan0;
		ViewportRect.bottom -= overscan1;
	}
	else
	{
		ViewportRect.right *= scale;
		ViewportRect.bottom *= scale;
		ViewportRect.top += scale * overscan0;
		ViewportRect.bottom -= scale * overscan1;
	}

	WaitVBlank();
	IDirectDrawSurface_Blt(DX.DDSPrimary, &ScreenRect, DX.DDSRender, &ViewportRect, DDBLT_WAIT, NULL);
}
// MOD2!!!

// MOD2!!!
void scaledBlit(long scale)
{
	if (iWindowMode)
	{
		windowBlit(scale);
	}
	else
	{
		fullscreenBlit(scale);
	}
}
// MOD2!!!

// MOD2!!!
#define MAX_FPS 16

void showFPS()
{
	if (iWindowMode)
	{
		char fps[MAX_FPS + 1];

		fps[MAX_FPS] = 0;

		_snprintf(fps, MAX_FPS, "%.2f", fps_cur);

		SetWindowText(hWGPU, fps);
	}
}

struct SendKeyProcessor
{
	int isFirstTick;
	DWORD startTick;
	int currentKey;
	int needRelease;
};

struct SendKeyProcessor sendKeyProcessor = { 1, 0, 0, 0 };

void processKey()
{
	int key = sendKey[sendKeyProcessor.currentKey];

	if (sendKeyProcessor.needRelease == 0)
	{
		sendKeyProcessor.needRelease = 1;

		if (key != 0)
		{
			key = VK_F1 + key - 1;

			SendMessage(hWGPU, WM_KEYDOWN, key, 0x00000001);
		}
	}
	else
	{
		sendKeyProcessor.needRelease = 0;
		sendKeyProcessor.currentKey++;

		if (key != 0)
		{
			key = VK_F1 + key - 1;

			SendMessage(hWGPU, WM_KEYUP, key, 0xc0000001);
		}
	}
}

void processKeys()
{
	if (sendKeyProcessor.currentKey == SEND_KEYS_MAX) return;

	DWORD currentTick = GetTickCount();

	if (sendKeyProcessor.isFirstTick)
	{
		sendKeyProcessor.isFirstTick = 0;
		sendKeyProcessor.startTick = currentTick;
	}

	if (currentTick < sendKeyProcessor.startTick)
	{
		sendKeyProcessor.startTick = currentTick;
	}

	DWORD delay = sendKeyProcessor.needRelease ? keyReleaseAfter : keyPressAfter;

	if ((currentTick - sendKeyProcessor.startTick) > delay)
	{
		sendKeyProcessor.startTick = currentTick;
		processKey();
	}
}

void processEscRequest()
{
	if (escRequest)
	{
		escRequest = 0;
		SendMessage(hWGPU, WM_KEYDOWN, VK_ESCAPE, 0x00000001);
	}
}
// MOD2!!!

void DoBufferSwap(void)
{
	// MOD2!!!
	showFPS();
	processKeys();
	processEscRequest();
	// MOD2!!!

	HRESULT ddrval = IDirectDrawSurface_Lock(DX.DDSRender, NULL, &ddsd, DDLOCK_WAIT | DDLOCK_WRITEONLY, NULL);

	if (ddrval == DDERR_SURFACELOST)
	{
		IDirectDrawSurface_Restore(DX.DDSRender);
	}

	if (ddrval != DD_OK)
	{
		IDirectDrawSurface_Unlock(DX.DDSRender, &ddsd);
		return;
	}

	BlitScreen((unsigned char *)ddsd.lpSurface, PSXDisplay.DisplayPosition.x, PSXDisplay.DisplayPosition.y); // fill DDSRender surface

	IDirectDrawSurface_Unlock(DX.DDSRender, &ddsd);

	scaledBlit(screenRealScale); // MOD2!!!
}

////////////////////////////////////////////////////////////////////////
// GAMMA
////////////////////////////////////////////////////////////////////////

int iUseGammaVal=2048;

void DXSetGamma(void)
{
    float g;
    if (iUseGammaVal==2048) return;

    g=(float)iUseGammaVal;
    if (g>512) g=((g-512)*2)+512;
    g=0.5f+((g)/1024.0f);

    // some cards will cheat... so we don't trust the caps here
    // if (DD_Caps.dwCaps2 & DDCAPS2_PRIMARYGAMMA)
    {
        float f;
        DDGAMMARAMP ramp;
        int i;
        LPDIRECTDRAWGAMMACONTROL DD_Gamma = NULL;

        if FAILED(IDirectDrawSurface_QueryInterface(DX.DDSPrimary,&IID_IDirectDrawGammaControl,(void**)&DD_Gamma))
            return;

        for (i=0; i<256; i++)
        {
            f=(((float)(i*256))*g);
            if (f>65535) f=65535;
            ramp.red[i]=ramp.green[i]=ramp.blue[i]=(WORD)f;
        }

        IDirectDrawGammaControl_SetGammaRamp(DD_Gamma,0,&ramp);
        IDirectDrawGammaControl_Release(DD_Gamma);
    }
}

////////////////////////////////////////////////////////////////////////
// MAIN DIRECT DRAW INIT
////////////////////////////////////////////////////////////////////////

// MOD2!!!
char *getBlit()
{
	if (BlitScreen == BlitScreen15)      return "BlitScreen15";
	if (BlitScreen == BlitScreen15_2x)   return "BlitScreen15_2x";
	if (BlitScreen == BlitScreen15_3x)   return "BlitScreen15_3x";

	if (BlitScreen == BlitScreen16)      return "BlitScreen16";
	if (BlitScreen == BlitScreen16_2x)   return "BlitScreen16_2x";
	if (BlitScreen == BlitScreen16_3x)   return "BlitScreen16_3x";

	if (BlitScreen == BlitScreen32)      return "BlitScreen32";
	if (BlitScreen == BlitScreen32_2x)   return "BlitScreen32_2x";
	if (BlitScreen == BlitScreen32_3x)   return "BlitScreen32_3x";
	if (BlitScreen == BlitScreen32_xbrz) return "BlitScreen32_xbrz";

	return "?";
}

char *getResize()
{
	if (p2XSaIFunc == NULL)           return "NULL";
	if (p2XSaIFunc == Std2xSaI_ex5)   return "Std2xSaI_ex5";
	if (p2XSaIFunc == Std2xSaI_ex6)   return "Std2xSaI_ex6";
	if (p2XSaIFunc == Std2xSaI_ex8)   return "Std2xSaI_ex8";
	if (p2XSaIFunc == Super2xSaI_ex5) return "Super2xSaI_ex5";
	if (p2XSaIFunc == Super2xSaI_ex6) return "Super2xSaI_ex6";
	if (p2XSaIFunc == Super2xSaI_ex8) return "Super2xSaI_ex8";
	if (p2XSaIFunc == SuperEagle_ex5) return "SuperEagle_ex5";
	if (p2XSaIFunc == SuperEagle_ex6) return "SuperEagle_ex6";
	if (p2XSaIFunc == SuperEagle_ex8) return "SuperEagle_ex8";
	if (p2XSaIFunc == Scale2x_ex6_5)  return "Scale2x_ex6_5";
	if (p2XSaIFunc == Scale2x_ex8)    return "Scale2x_ex8";
	if (p2XSaIFunc == Scale3x_ex6_5)  return "Scale3x_ex6_5";
	if (p2XSaIFunc == Scale3x_ex8)    return "Scale3x_ex8";
	if (p2XSaIFunc == scale2xbrz)     return "scale2xbrz";
	if (p2XSaIFunc == scale3xbrz)     return "scale3xbrz";
	if (p2XSaIFunc == scale4xbrz)     return "scale4xbrz";
	if (p2XSaIFunc == scale5xbrz)     return "scale5xbrz";
	if (p2XSaIFunc == scale6xbrz)     return "scale6xbrz";

	return "?";
}

int isFirstInitialization = 1;
// MOD2!!!

int DXinitialize()
{
    LPDIRECTDRAW DD;
    int i;
    LPDIRECTDRAWCLIPPER Clipper;
    HRESULT h;
    GUID FAR* guid=0;
    unsigned char* c;
    DDSCAPS ddscaps;
    DDBLTFX ddbltfx;
    DDPIXELFORMAT dd;

    // init some DX vars
	DX.hWnd = (HWND)hWGPU;

    // make guid !
    c=(unsigned char*)&guiDev;
    for (i=0; i<sizeof(GUID); i++,c++)
    {if (*c) {guid=&guiDev; break;}}

    // create dd
    if (DirectDrawCreate(guid,&DD,0))
    {
        MessageBox(NULL, "This GPU requires DirectX!", "Error", MB_OK);
        return 0;
    }

    DX.DD=DD;

    //////////////////////////////////////////////////////// co-op level

	if (iWindowMode)
	{
		if (IDirectDraw_SetCooperativeLevel(DX.DD, DX.hWnd, DDSCL_NORMAL)) return 0;
		cooperativeLevel = 0;
	}
	else
	{
		// If you:
		// - Go fullscreen
		// - Press ESC
		// - Select run/continue
		// - Go fullscreen
		// SetCooperativeLevel will return DDERR_HWNDALREADYSET (?)
		// Instead works just fine when you [alt enter]

		// MOD2!!!
		HRESULT result = IDirectDraw_SetCooperativeLevel(DX.DD, DX.hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);

		if (result == DDERR_HWNDALREADYSET)
		{
			if (IDirectDraw_SetCooperativeLevel(DX.DD, DX.hWnd, DDSCL_NORMAL)) return 0;
			cooperativeLevel = 0;
		}
		else
		{
			if (result != DD_OK) return 0;
			cooperativeLevel = 1;
		}
		// MOD2!!!

		if (iRefreshRate)
		{
			LPDIRECTDRAW2 DD2;
			IDirectDraw_QueryInterface(DX.DD, &IID_IDirectDraw2, (LPVOID *)&DD2);

			if (IDirectDraw2_SetDisplayMode(DD2, iResX, iResY, iColDepth, iRefreshRate, 0)) return 0;
		}
		else
		{
			if (IDirectDraw_SetDisplayMode(DX.DD, iResX, iResY, iColDepth)) return 0;
		}
	}

    //////////////////////////////////////////////////////// main surfaces

	memset(&ddsd, 0, sizeof(DDSURFACEDESC));
	memset(&ddscaps, 0, sizeof(DDSCAPS));
	ddsd.dwSize = sizeof(DDSURFACEDESC);

	ddsd.dwFlags = DDSD_CAPS;                             // front buffer

	if (iSysMemory)
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_SYSTEMMEMORY;
	else
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_VIDEOMEMORY;

	if (IDirectDraw_CreateSurface(DX.DD, &ddsd, &DX.DDSPrimary, NULL))
		return 0;

	//----------------------------------------------------//

	// MOD2!!!
	int useBackbufferDepth = backbufferDepth != 32;
	if (iSysMemory)
	{
		useBackbufferDepth = 0;
	}
	// MOD2!!!

	memset(&ddsd, 0, sizeof(DDSURFACEDESC)); // back buffer
	ddsd.dwSize = sizeof(DDSURFACEDESC);
	ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS | (!useBackbufferDepth ? 0 : DDSD_PIXELFORMAT); // MOD2!!!

	if (iSysMemory)
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	else
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;

	// MOD2!!!
	if (getScreenScale() == 1)
	{
		ddsd.dwWidth = 640;
		ddsd.dwHeight = 512;
	}
	else
	{
		ddsd.dwWidth = getScreenScale() * SMALL_WIDTH;
		ddsd.dwHeight = getScreenScale() * 512;
	}

	const DWORD R_MASK_15 = 0x00007c00;
	const DWORD G_MASK_15 = 0x000003e0;
	const DWORD B_MASK_15 = 0x0000001f;

	const DWORD R_MASK_16 = 0x0000f800;
	const DWORD G_MASK_16 = 0x000007e0;
	const DWORD B_MASK_16 = 0x0000001f;

	if (useBackbufferDepth)
	{
		DDPIXELFORMAT pixelFormat;

		memset(&pixelFormat, 0, sizeof(DDPIXELFORMAT));

		pixelFormat.dwSize = sizeof(DDPIXELFORMAT);
		pixelFormat.dwFlags = DDPF_RGB;
		pixelFormat.dwRGBBitCount = 16;

		if (backbufferDepth == 15)
		{
			pixelFormat.dwRBitMask = R_MASK_15;
			pixelFormat.dwGBitMask = G_MASK_15;
			pixelFormat.dwBBitMask = B_MASK_15;
		}
		else
		{
			pixelFormat.dwRBitMask = R_MASK_16;
			pixelFormat.dwGBitMask = G_MASK_16;
			pixelFormat.dwBBitMask = B_MASK_16;
		}
		ddsd.ddpfPixelFormat = pixelFormat;
	}
	// MOD2!!!

	if (IDirectDraw_CreateSurface(DX.DD, &ddsd, &DX.DDSRender, NULL))
		return 0;

	// check for desktop color depth
	dd.dwSize = sizeof(DDPIXELFORMAT);
	IDirectDrawSurface_GetPixelFormat(DX.DDSRender, &dd);

	// MOD2!!!
	if ((dd.dwRBitMask == R_MASK_15) && (dd.dwGBitMask == G_MASK_15) && (dd.dwBBitMask == B_MASK_15))
	{
		iDesktopCol = 15;
	}
	else if ((dd.dwRBitMask == R_MASK_16) && (dd.dwGBitMask == G_MASK_16) && (dd.dwBBitMask == B_MASK_16))
	{
		iDesktopCol = 16;
	}
	else
	{
		iDesktopCol = 32;
	}

	struct Blitter blitter = getBlitter(iDesktopCol);

	BlitScreen = blitter.blit;
	p2XSaIFunc = blitter.resize;
	// MOD2!!!

    //////////////////////////////////////////////////////// clipper init

	if (FAILED(h = IDirectDraw_CreateClipper(DX.DD, 0, &Clipper, NULL)))
		return 0;

	IDirectDrawClipper_SetHWnd(Clipper, 0, DX.hWnd);

	IDirectDrawSurface_SetClipper(DX.DDSPrimary, Clipper);
	IDirectDrawClipper_Release(Clipper);

    //////////////////////////////////////////////////////// small screen clean up

    DXSetGamma();

    ddbltfx.dwSize = sizeof(ddbltfx);
    ddbltfx.dwFillColor = 0x00000000;

    IDirectDrawSurface_Blt(DX.DDSPrimary,NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
    IDirectDrawSurface_Blt(DX.DDSRender,NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);

    //////////////////////////////////////////////////////// finish init

	// MOD2!!!
	pSaISmallBuff = NULL;
	pSaIBigBuff = NULL;

	screenRealScale = getScreenRealScale(iDesktopCol);

	if (screenRealScale != 1)
	{
		long smallSize = SMALL_WIDTH * 512 * 4;
		pSaISmallBuff = malloc(smallSize);
		memset(pSaISmallBuff, 0, smallSize);

		if (!isXBRZ())
		{
			long bigSize = (screenRealScale * SMALL_WIDTH) * (screenRealScale * 512) * 4;
			pSaIBigBuff = malloc(bigSize);
			memset(pSaIBigBuff, 0, bigSize);
		}
	}
	// MOD2!!!

	bUsingTWin = FALSE;

	// MOD2!!!
	if (isFirstInitialization)
	{
		isFirstInitialization = 0;

		isStretched = initialAspectRatio;

		if (iShowFPS)
		{
			ulKeybits |= KEY_SHOWFPS;
		}
	}

	if (isMenuOn())
	{
		szDispBuf[0] = 0;
		BuildDispMenu(0);
	}
	// MOD2!!!

	bIsFirstFrame = FALSE; // done

	return 0;
}

// MOD2!!!
void cycleAspectRatioModes()
{
	if (isStretched == 2)
	{
		isStretched = 0;
	}
	else
	{
		isStretched++;
	}
}
// MOD2!!!

////////////////////////////////////////////////////////////////////////
// clean up DX stuff
////////////////////////////////////////////////////////////////////////

void DXcleanup() // DX CLEANUP
{
	// MOD2!!!
	if (pSaISmallBuff != NULL)
	{
		free(pSaISmallBuff);
		pSaISmallBuff = NULL;
	}

	if (pSaIBigBuff != NULL)
	{
		free(pSaIBigBuff);
		pSaIBigBuff = NULL;
	}
	// MOD2!!!

	if (!bIsFirstFrame)
	{
		IDirectDrawSurface_Release(DX.DDSRender);
		IDirectDrawSurface_Release(DX.DDSPrimary);
		IDirectDraw_SetCooperativeLevel(DX.DD, DX.hWnd, DDSCL_NORMAL);
		IDirectDraw_RestoreDisplayMode(DX.DD);
		IDirectDraw_Release(DX.DD);

		bIsFirstFrame = TRUE;
	}
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

int allocConsole = 1;

unsigned long ulInitDisplay(void)
{
	HDC hdc;
	RECT r;

	if (allocConsole == 0)
	{
		allocConsole = 1;
		AllocConsole();
		freopen("CON", "w", stdout);

		fprintf(stdout, "Hello!\n\n");
	}

	if (iWindowMode)
	{
		SetWindowLong(hWGPU, GWL_STYLE, WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX);
		SetMenu(hWGPU, NULL);

		iResX = LOWORD(iWinSize);
		iResY = HIWORD(iWinSize);
		ShowWindow(hWGPU, SW_SHOWNORMAL);

		// MOD2!!!
		HDC handle = GetDC(NULL);

		int realW = GetDeviceCaps(handle, DESKTOPHORZRES);

		int virtualW = GetDeviceCaps(handle, HORZRES);
		int virtualH = GetDeviceCaps(handle, VERTRES);

		ReleaseDC(NULL, handle);

		RECT clientRect;
		GetClientRect(hWGPU, &clientRect);

		RECT windowRect;
		GetWindowRect(hWGPU, &windowRect);

		LONG clientW = clientRect.right - clientRect.left;
		LONG clientH = clientRect.bottom - clientRect.top;

		LONG windowW = windowRect.right - windowRect.left;
		LONG windowH = windowRect.bottom - windowRect.top;

		windowW = (windowW - clientW) + (iResX * virtualW / realW);
		windowH = (windowH - clientH) + (iResY * virtualW / realW);

		int windowX = (virtualW - windowW) >> 1;
		int windowY = (virtualH - windowH) >> 1;

		MoveWindow(hWGPU, windowX, windowY, windowW, windowH, TRUE);
		// MOD2!!!

		UpdateWindow(hWGPU); // -> let windows do some update
	}
	else
	{
		SetWindowLong(hWGPU, GWL_STYLE, WS_OVERLAPPED);
		SetMenu(hWGPU, NULL);
		ShowWindow(hWGPU, SW_SHOWMAXIMIZED);
	}

	// init bkg with black
	r.left = r.top = 0;
	r.right = iResX;
	r.bottom = iResY;
	hdc = GetDC(hWGPU);
	FillRect(hdc, &r, (HBRUSH)GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWGPU, hdc);

	DXinitialize();

	if (!iWindowMode) // fullscreen mode?
	{
		ShowWindow(hWGPU, SW_SHOWMAXIMIZED); // -> maximize again (fixes strange DX behavior)

		// MOD2!!!
		RECT windowRect;
		if (GetWindowRect(hWGPU, &windowRect))
		{
			setCorrectedResolution(windowRect.right, windowRect.bottom);
			setCorrectedResolution2(windowRect.right, windowRect.bottom);
			setStretchedResolution(windowRect.right, windowRect.bottom);
		}

		DoClearScreenBuffer();
		DoClearFrontBuffer();
		// MOD2!!!
	}
	return 1;
}

////////////////////////////////////////////////////////////////////////

void CloseDisplay(void)
{
	DXcleanup();
}

////////////////////////////////////////////////////////////////////////

// MOD2!!!
void hideBitmap()
{
	showDebugBitmap = 0;

	DoClearScreenBuffer();
}

void showBitmap(unsigned char *source)
{
	showDebugBitmap = 1;

	unsigned short *destination15 = (unsigned short *)debugBitmap15;
	unsigned short *destination16 = (unsigned short *)debugBitmap16;
	unsigned int *destination32 = (unsigned int *)debugBitmap32;

	for (int y = 0; y < DEBUG_BITMAP_H; y++)
	{
		for (int x = 0; x < DEBUG_BITMAP_W; x++)
		{
			unsigned int p0 = source[0];
			unsigned int p1 = source[1];
			unsigned int p2 = source[2];
			source += 3;

			*destination32 = p0 | (p1 << 8) | (p2 << 16);

			p0 >>= 3;
			p1 >>= 2;
			p2 >>= 3;

			*destination16 = (unsigned short)(p0 | (p1 << 5) | (p2 << (5 + 6)));

			p1 >>= 1;

			*destination15 = (unsigned short)(p0 | (p1 << 5) | (p2 << (5 + 5)));

			destination15++;
			destination16++;
			destination32++;
		}
	}
}
// MOD2!!!
