// Copyright (C) jonny (jonnyleffe AT tuta DOT io) - All Rights Reserved

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version. See also the license.txt file for *
*   additional informations.                                              *
*                                                                         *
***************************************************************************/

#include "stdafx.h"
#include "DisplayResolutions.h"

struct DisplayResolutions displayResolutions = { NULL };

int cmpResolutions(struct DisplayResolution *resolution, int width, int height, int refresh)
{
	if (resolution->width < width) return -1;
	if (resolution->width > width) return 1;

	if (resolution->height < height) return -1;
	if (resolution->height > height) return 1;

	if (resolution->refresh < refresh) return -1;
	if (resolution->refresh > refresh) return 1;

	return 0;
}

struct DisplayResolution *newResolution(int width, int height, int refresh)
{
	struct DisplayResolution *resolution = (struct DisplayResolution *)malloc(sizeof(struct DisplayResolution));

	resolution->width = width;
	resolution->height = height;
	resolution->refresh = refresh;
	resolution->next = NULL;

	return resolution;
}

void addResolution(struct DisplayResolutions *resolutions, int width, int height, int refresh)
{
	struct DisplayResolution **first = &resolutions->first;

	while (1)
	{
		if (*first == NULL)
		{
			*first = newResolution(width, height, refresh);
			return;
		}

		int cmp = cmpResolutions(*first, width, height, refresh);

		if (cmp == 0)
		{
			return;
		}

		if (cmp == 1)
		{
			struct DisplayResolution *resolution = newResolution(width, height, refresh);

			resolution->next = *first;
			*first = resolution;
			return;
		}

		first = &(*first)->next;
	}
}

void getResolutions(struct DisplayResolutions *resolutions)
{
	if (resolutions->first) return;

	DEVMODE devMode;
	memset(&devMode, 0, sizeof(DEVMODE));
	devMode.dmSize = sizeof(DEVMODE);

	int index = 0;

	while (EnumDisplaySettings(NULL, index, &devMode))
	{
		index++;

		int width = devMode.dmPelsWidth;
		int height = devMode.dmPelsHeight;
		int refresh = devMode.dmDisplayFrequency;

		if (refresh == 1) refresh = 0;

		addResolution(resolutions, width, height, refresh);
	}

	if (resolutions->first == NULL)
	{
		addResolution(resolutions, 640, 480, 0);
	}
}

void initResolutions()
{
	getResolutions(&displayResolutions);
}

void getResolutionFromIndex(int index, int *width, int *height, int *refresh)
{
	initResolutions();

	struct DisplayResolution *first = displayResolutions.first;

	int p = 0;
	while (first)
	{
		if (p == index)
		{
			*width = first->width;
			*height = first->height;
			*refresh = first->refresh;
		}
		first = first->next;
		p++;
	}
}

void getFirstResolution(int *width, int *height, int *refresh)
{
	getResolutionFromIndex(0, width, height, refresh);
}

int getIndexFromResolutionAndCorrectNotFound(int *width, int *height, int *refresh)
{
	initResolutions();

	struct DisplayResolution *first = displayResolutions.first;

	int p = 0;
	while (first)
	{
		int cmp = cmpResolutions(first, *width, *height, *refresh);
		if (cmp == 0)
		{
			return p;
		}

		first = first->next;
		p++;
	}

	getFirstResolution(width, height, refresh);
	return 0;
}
