// Copyright (C) jonny (jonnyleffe AT tuta DOT io) - All Rights Reserved

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version. See also the license.txt file for *
*   additional informations.                                              *
*                                                                         *
***************************************************************************/

#ifndef _FONTS_H_
#define _FONTS_H_

#define FONTS_START_CODE 32
#define FONTS_END_CODE 126

struct BitmapFont
{
	int width;
	int height;
	unsigned int *raw32;
	unsigned short *raw16;
	unsigned short *raw15;
};

struct FontEnvironment
{
	unsigned char *surface;
	int width;
	int height;
	int depth;
	int pitch;
	struct BitmapFont *font;
};

struct ExtraClipper
{
	int xStart;
	int yStart;
	int xEnd;
	int yEnd;
};

void setFontEnvironment(struct FontEnvironment *environment, unsigned char *surface, int width, int height, int depth, int pitch, struct BitmapFont *font);
void drawChar(int xStart, int yStart, char ch, struct FontEnvironment *environment);
void drawText(int xStart, int yStart, char *text, struct FontEnvironment *environment);
void drawBitmap(int xStart, int yStart, int width, int height, unsigned char *sourceBitmap, struct FontEnvironment *environment);
void drawPixel(int x, int y, struct ExtraClipper *extraClipper, struct FontEnvironment *environment);

#endif
