/***************************************************************************
                          cfg.h  -  description
                             -------------------
    begin                : Sun Oct 28 2001
    copyright            : (C) 2001 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2001/10/28 - Pete
// - generic cleanup for the Peops release
//
//*************************************************************************//

#ifndef _GPU_CFG_H_
#define _GPU_CFG_H_

void ReadConfig(void);
void WriteConfig(void);
void ReadWinSizeConfig(void);

// MOD2!!!
struct Blitter
{
	void(*blit) (unsigned char *, long, long);
	void(*resize) (unsigned char *, DWORD, unsigned char *, int, int);
};

struct ScreenMode
{
	long scale32;
	long scale16;
	int isXBRZ;
	LPCTSTR description;
};

#define SEND_KEYS_MAX 7

extern int sendKey[SEND_KEYS_MAX];

void setCorrectedResolution(LONG resolutionW, LONG resolutionH);
void setCorrectedResolution2(LONG resolutionW, LONG resolutionH);
void setStretchedResolution(LONG resolutionW, LONG resolutionH);
long getScreenScale();
long getScreenRealScale(int depth);
int isXBRZ();
struct Blitter getBlitter(int depth);
// MOD2!!!

#ifdef _WINDOWS
BOOL CALLBACK SoftDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
#else // LINUX
void SoftDlgProc(void);
void AboutDlgProc(void);
#endif

#endif // _GPU_CFG_H_

