#include <stdio.h>
#include "z80.h"
#include "emufns.h"

FILE *F;

int readroms(byte *ROM, const char *basename,struct RomModule *romp)
{
	FILE *F;
	char name[20];


	while (romp->name)
	{
		sprintf(name,"%s/%s",basename,romp->name);

		if (!(F = fopen(name,"rb")))
		{
			printf("Unable to open file %s\n",name);
			return -1;
		}
		if (fread(ROM + romp->address,1,romp->size,F) != romp->size)
		{
			printf("Unable to read file %s\n",name);
			fclose(F);
			return -1;
		}
		fclose(F);

		romp++;
	}

	return 0;
}

void
warning(void)
{
	printf("\nPLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
		 "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
		 "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
		 "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n"
		 "\n\n");
}

