// Moon Cresta Instructions:
//
// The ROM images must be located in a directory called MOONCRST under the
// directory where the MOON.EXE is located.
//
// Command line options:
//
// -d    Displays the graphics of the game in all the palettes available (16)
//       press any key to step through the different palettes.
//
// -s    Turns on really crappy sound from the speaker (not worth trying yet).
//
// Keys used to play the game:
//
// 3     Inserts coins.
//
// 1     Selects 1 player game.
//
// 2     Selects 2 player game.
//
// Left  Moves your ship left.
//
// Right Moves your ship right.
//
// Ctrl  Fires.
//
// F10 Pause and resume.
//
// ESC to exit.
//
// Things to be done:
//
// Fix the colours.
// Add REAL sound.
// Add Stars.
// Check the speed of game play.
// Do something about the RUB and END when entering your name and maybe when the
// Atomic piles are forming (not sure about this last bit though).
// Clean up this code.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <unistd.h>
#include <pc.h>
#include "Z80.h"
#include <allegro.h>
#include "emufns.h"

#define XLEN 256
#define YLEN 256

#define MAXCHARS 512
#define MAXSPRITES 128
#define MAXPALETTES 16

extern volatile char key[128];

word base = 0x9000;
int	Sprite = 0;
byte *RAM;

BITMAP *piccie;
BITMAP *chars[MAXCHARS][MAXPALETTES];         // All the characters
BITMAP *sprites[MAXSPRITES][MAXPALETTES];        // All the sprites

int dirtyrec[0x1000];      // Possible optimization for screen refreshes.
			   // Currently not used.

unsigned char pal[3*256];

struct RomModule MoonCrestaGFXROMs[] =
{
	{"EPR202",0x0000,0x0800},
	{"EPR203",0x0800,0x0800},
	{"EPR171",0x1000,0x0800},
	{"EPR172",0x1800,0x0800},
	{0,0,0}	// end of table
};

struct RomModule MoonCrestaROMs[] =
{
	{"EPR194",0x0000,0x0800},
	{"EPR195",0x0800,0x0800},
	{"EPR196",0x1000,0x0800},
	{"EPR197",0x1800,0x0800},
	{"EPR198",0x2000,0x0800},
	{"EPR199",0x2800,0x0800},
	{"EPR200",0x3000,0x0800},
	{"EPR201",0x3800,0x0800},
	{0,0,0}	// end of table
};

FILE *F;
reg StartRegs;

int	Sound = 0;
void setcolor(char red, char green, char blue, unsigned short color)
{
 color = 3*color;
 pal[color++]=red;
 pal[color++]=green;
 pal[color]=blue;
}

void setpalette () {

  int count;

  outportb(0x3c8,0x00);
  for(count=0;count<768;count++)
    outportb(0x3c9,pal[count]);
}

void setupvideo () {
int teller;
int  count1,count2;

  set_gfx_mode(GFX_AUTODETECT,XLEN,YLEN,0,0);  // Allegro routine to start video

  for (teller=0;teller<256;teller+=4)           // set all colors to black
    setcolor(0,0,0,teller);

  // 0
  setcolor(255,0,0,2);                 // Set 3 colors just to notice 'em
  setcolor(255,255,255,3);             // Totaly wrong ,but will be fixed
  setcolor(0,0,255,1);
  // 1
  setcolor(0,0,0,4);
  setcolor(0,0,255,5);
  setcolor(255,0,0,6);
  setcolor(255,255,0,7);
  // 2
  setcolor(0,0,0,8);
  setcolor(128,0,255,9);
  setcolor(255,128,0,10);
  setcolor(255,0,128,11);
  // 3
  setcolor(0,0,0,12);
  setcolor(28,20,0,13);
  setcolor(0,28,20,14);
  setcolor(23,30,23,15);
  // 4
  setcolor(0,0,0,16);
  setcolor(0,200,128,17);
  setcolor(200,128,200,18);
  setcolor(128,255,128,19);
  // 5
  setcolor(0,0,0,20);
  setcolor(200,200,64,21);
  setcolor(255,255,0,22);
  setcolor(200,64,255,23);

  // 6
  setcolor(0,0,0,24);
  setcolor(0,0,255,25);
  setcolor(255,255,0,27);
  setcolor(255,0,0,26);

  // 7
  setcolor(0,0,0,28);
  setcolor(200,255,0,29);
  setcolor(0,255,200,30);
  setcolor(255,0,255,31);

  // 8
  setcolor(0,0,0,32);
  setcolor(200,255,0,33);
  setcolor(0,255,200,34);
  setcolor(255,0,255,35);

  // 9
  setcolor(0,0,0,36);
  setcolor(200,255,0,37);
  setcolor(0,255,200,38);
  setcolor(255,0,255,39);

  // 10
  setcolor(0,0,0,40);
  setcolor(200,255,0,41);
  setcolor(0,255,200,42);
  setcolor(255,0,255,43);

  // 11
  setcolor(0,0,0,44);
  setcolor(200,255,0,45);
  setcolor(0,255,200,46);
  setcolor(255,0,255,47);

  // 12
  setcolor(0,0,0,48);
  setcolor(200,255,0,49);
  setcolor(0,255,200,50);
  setcolor(255,0,255,51);

  // 13
  setcolor(0,0,0,52);
  setcolor(200,255,0,53);
  setcolor(0,255,200,54);
  setcolor(255,0,255,55);

  // 14
  setcolor(0,0,0,56);
  setcolor(200,255,0,57);
  setcolor(0,255,200,58);
  setcolor(255,0,255,59);

  // 15
  setcolor(0,0,0,60);
  setcolor(200,255,0,61);
  setcolor(0,255,200,62);
  setcolor(255,0,255,63);

  piccie = create_bitmap(256,256);             // Allocate memory for temp screen (in memory)
  for(count2=0;count2<MAXPALETTES;count2++)
  for(count1=0;count1<MAXCHARS;count1++)
	{
	chars[count1][count2]=create_bitmap(8,8);      // Allocate memory for charset
	clear(chars[count1][count2]);
	}
  for(count2=0;count2<MAXPALETTES;count2++)
  for(count1=0;count1<MAXSPRITES;count1++)
  {
   sprites[count1][count2]=create_bitmap(16,16);  // Allocate memory for sprites
  }

  for (count1=0;count1<256;count1++)
    for (count2=0;count2<256;count2++)
      piccie->line[count1][count2] = 0;        // Clear the temp screen

  setpalette();                                // Set the colors
}

void warpchars (int DumpChars) {

  byte byte1,byte2,tempbyte;
  word offset;
  word y;
  int teller,no;
  int count,count1,count2,count3;
  word line,colum;

  for(count3=0;count3<2;count3++)
  for(count2=0;count2<MAXPALETTES;count2++)
  for (teller=0;teller<256;teller++) {

    offset = teller * 8;
    no=teller + count3*256;
    for (y=0;y<8;y++) {

      byte1=RAM[count3*0x1000 + offset+ y];
      byte2=RAM[count3*0x1000 + offset+ y + 0x800];

      tempbyte = byte1 & 0x80;
      tempbyte = tempbyte >> 6;
      tempbyte = tempbyte + ((byte2 & 0x80) >> 7);
      if(tempbyte)
      chars[no][count2]->line[0][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x40;
      tempbyte = tempbyte >> 5;
      tempbyte = tempbyte + ((byte2 & 0x40) >> 6);
      if(tempbyte)
      chars[no][count2]->line[1][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x20;
      tempbyte = tempbyte >> 4;
      tempbyte = tempbyte + ((byte2 & 0x20) >> 5);
      if(tempbyte)
      chars[no][count2]->line[2][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x10;
      tempbyte = tempbyte >> 3;
      tempbyte = tempbyte + ((byte2 & 0x10) >> 4);
      if(tempbyte)
      chars[no][count2]->line[3][7-y]=count2*4+tempbyte;


      tempbyte = byte1 & 0x08;
      tempbyte = tempbyte >> 2;
      tempbyte = tempbyte + ((byte2 & 0x8) >> 3);
      if(tempbyte)
      chars[no][count2]->line[4][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x04;
      tempbyte = tempbyte >> 1;
      tempbyte = tempbyte + ((byte2 & 0x4) >> 2);
      if(tempbyte)
      chars[no][count2]->line[5][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x02;
      tempbyte = tempbyte + ((byte2 & 0x2) >> 1);
      if(tempbyte)
      chars[no][count2]->line[6][7-y]=count2*4+tempbyte;

      tempbyte = byte1 & 0x01;
      tempbyte = tempbyte << 1;
      tempbyte = tempbyte + (byte2 & 0x1);
      if(tempbyte)
      chars[no][count2]->line[7][7-y]=count2*4+tempbyte;
   
    }
  }

  // Build sprites from the characters
  // Moon Cresta uses only 256 characters and 64 sprites.
  for(count2=0;count2<MAXPALETTES;count2++)
    for(count1=0;count1<MAXSPRITES;count1++){
	blit(chars[count1*4][count2], sprites[count1][count2],0,0,8,0,8,8);
	blit(chars[count1*4+1][count2], sprites[count1][count2],0,0,8,8,8,8);
	blit(chars[count1*4+2][count2], sprites[count1][count2],0,0,0,0,8,8);
	blit(chars[count1*4+3][count2], sprites[count1][count2],0,0,0,8,8,8);
    }

//  Routine to show all the 16x16 sprites.
//
	if (DumpChars)
	{
		for (count2=0;count2<MAXPALETTES;count2++)
		{
			for (count=0;count<MAXSPRITES;count++)
			{
				colum = (count*16) % 256;
				line  = (count / 16)*16;
				draw_sprite(piccie,sprites[count][count2], colum, line);
			}
			blit(piccie,screen,0,0,0,0,256,256);
			getch();
		}
	}

/* Now would be a nice time to clear the screen...
   -V-
*/
  clear(piccie);
  blit(piccie,screen,0,0,0,0,256,256);
}

int main(int argc, char *argv[]) {  

	int	c;
	int	DumpChars = 0;

	while ((c = getopt(argc, argv, "ds?")) != -1)
	{
		switch(c)
		{
			case 'd':
				DumpChars++;
				break;
			case 's':
				Sound++;
				break;
			case '?':
				printf("Options are:\n\td - dump chars\n\ts - sound\n\n");
				exit(0);
				break;
		}
	}
	warning();

	printf("Keys : 3 Insert coin\n"
		   "       1 Start 1 player game\n"
		   "       2 Start 2 player game\n"
		   "       Left and Right Arrow keys to move around\n"
		   "       Ctrl key to fire\n"
           "       F10 Pause the game, F10 again to resume\n"
		   "       ESC to exit\n"
		   "\n\nPress any key to continue\n");
	getch();

	allegro_init();

	if(!(RAM=malloc(0x10000)))
	{
		puts("FAILED");return(0);
	}

	if (readroms(RAM, "MOONCRST", MoonCrestaGFXROMs))
			exit(1);

	setupvideo ();
	warpchars (DumpChars);

  	memset(RAM, 0, 0x10000);

	if (readroms(RAM, "MOONCRST", MoonCrestaROMs))
			exit(1);

	install_keyboard();

#if	DEBUG
	Trap = 0;
#endif
	IPeriod = 100000;		// Number of T-states per interrupt			
	ResetZ80(&StartRegs);	// Reset the register set.

	Z80(&StartRegs);		// start the CPU emulation.

	destroy_bitmap(piccie);  
	set_gfx_mode(GFX_TEXT,80,25,0,0);   

	nosound();

	exit(1);
}

byte M_RDMEM (dword A)
{
	byte rv = 0;

	switch (A)
	{
		case 0xA000:	// Switch 0
			if (key[KEY_3])
				rv |= 1;
			if (key[KEY_LEFT])
				rv |= 4;
			if (key[KEY_RIGHT])
				rv |= 8;
			if (key[KEY_CONTROL])
				rv |= 16;
			break;
		case 0xA800:	// Switch 1
// Top two bits are bottom two bits of the Dip Switch
// 7 - 1 = English docking messages
// 6 - ????
			rv = 0x80;

			if (key[KEY_1])
				rv |= 1;
			if (key[KEY_2])
				rv |= 2;
			break;
		case 0xB000:	// Dip Switch
// For the Dip Switch the Bottom four bits only are used
// 3 \
// 2 /	- 3 = Free Play
//	- 2 = one coin = 3 credits
//	- 1 = one coin = 2 credits
//	- 0 = one coin = 1 credits
//
// 1 - ???
// 0 - ???
			rv = 0;
			break;
		default:
			rv = RAM[A];
	}
	return(rv);
}

void M_WRMEM (dword A,byte V)
{ 
// Ignore writes to ROM
	if(A < 0x4000) {
		return;
	}
	switch (A)
	{
// Writes to 0xA000 to 0xA7FF decode to /LAMP
// This selects the extra character ROMs.
		case 0xA000:
			if (V)
				Sprite |= 0x10;
			else
				Sprite &= ~0x10;
			break;
		case 0xA001:
			if (V)
				Sprite |= 0x20;
			else
				Sprite &= ~0x20;
			break;
		case 0xA002:
			if (V)
				Sprite |= 0x40;
			else
				Sprite &= ~0x40;
			break;

// Sound to be added here (/SOUND)
		case 0xA800:		// FS1
			if (Sound)
				sound(1000);
			break;
		case 0xA801:		// FS2
			if (Sound)
				sound(2000);
			break;
		case 0xA802:		// FS3
			if (Sound)
				sound(3000);
			break;
		case 0xA803:		// ???
			break;
		case 0xA804:
			break;
		case 0xA805:		// MSHOOT
			if (Sound)
				sound(5000);
			break;
		case 0xA806:		// VOL 1
			break;
		case 0xA807:		// VOL 2
			break;
		case 0xB000:		// NMION
			if (RAM[A] == 0x80)
				RAM[A] = 0x00;
			else
				RAM[A] = 0x80;
			break;
		case 0xB004:		// STARS ON
			break;
		case 0xB006:		// HFLIP
			break;
		case 0xB007:		// VFLIP
			break;
		case 0xB800:		// /PITCH
			if (Sound)
			{
				if (V)
				{
					sound(V * 80);
				}
				else
				{
					nosound();
				}
			}
			break;
	}
	RAM[A] = V; 
}

int Interrupt(void)
{
	int X,Y;
	int count1,spritenum,colour,direction;
	int offset;
  

// show something on the screen !
// It's slow, but will do for now
	clear(piccie);

// Blit the sprites. Since the background is cleared and updated every time
// there's really no need to copy the backgrounds.

// First the alien sprites
// Data format is X, num/orientation, colour, Y
	for(count1 = 0x9840; count1 < 0x9860; count1 += 4)
	{
		X=RAM[count1];
		spritenum=RAM[count1 + 1];
		colour=RAM[count1 + 2];
		Y=RAM[count1 + 3];
		
// direction holds the flipping info 0x80 vertical 0x40 horiz, or was
// it the other way around...
		direction = spritenum >> 6;

// Took me ages to figure out that the extra sprites are selected
// via the /LAMP output.

		spritenum &= 0x3f;
		if (Sprite & 0x40)
		{
			if ((spritenum > 31) && (spritenum < 48))
			{
				spritenum = (spritenum & 0x1f) | Sprite;
			}
		}

		if(X && Y && spritenum)
		{
			switch(direction)
			{
				case (0):
					draw_sprite(piccie,sprites[spritenum][colour], X, Y);
					break;
				case (1):
					draw_sprite_v_flip(piccie,sprites[spritenum][colour],X, Y);
					break;
				case (2):
					draw_sprite_h_flip(piccie,sprites[spritenum][colour],X, Y);
					break;
				default:
					draw_sprite_vh_flip(piccie,sprites[spritenum][colour],X, Y);
					break;
			}
		}
	}

// Next the players bullets (Not sure how big they should be)
// Data format is ??, X, ??, -Y
	for(count1=0x9860;count1<0x9880;count1+=4)
	{
		X=RAM[count1 + 1];
		Y = 256 - RAM[count1 + 3];    // Y is inverted
		if(X && Y)
			vline(piccie, X, Y, Y+8, 1);
	}

// Finally the characters themselves, shifted into the correct place.
// The are done as sprites so that they can overlay the real sprites.
	for (Y=0;Y<32;Y++)
	{
		for (X=0;X<32;X++)
		{
			offset = RAM[base + (31-Y)*32 + X];
			draw_sprite(piccie, chars[offset][RAM[0x9801+X*2]],
				((Y*8+(unsigned char)RAM[0x9800+X*2])%256), X*8);
		}
	}

//OK, all done with screen buffer, now let's blast it on screen...

	blit(piccie,screen,0,0,0,0,256,256);

	if(key[KEY_ESC])
		CPURunning = 0;
	if(key[KEY_F10])
	{
		clear_keybuf();
		while(!key[KEY_F10])
			continue;
		clear_keybuf();
	}

//And back to our scheduled program... i.e NMI at address 0x0066
	if (RAM[0xB000])
		return(NMI_INT);
	else
		return(IGNORE_INT);
}

byte DoIn(byte A)
{ 
	return 0;
}

void DoOut(byte A,byte V)
{
}

void Patch (reg *R)
{
}

int InterruptsEnabled(void) {
	return(NMI_INT);
}

