/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import jtrrntzip.AbstractTorrentZipOptions;
import jtrrntzip.LogCallback;
import jtrrntzip.Messages;
import jtrrntzip.TorrentZip;
import org.apache.commons.io.FilenameUtils;

public final class Program
extends AbstractTorrentZipOptions
implements LogCallback {
    private TorrentZip tz;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("");
            System.out.println(Messages.getString("Program.MissingPath"));
            System.out.println(Messages.getString("Program.Usage"));
            return;
        }
        new Program(args);
    }

    public Program(String[] args) {
        super(args);
        if (this.argfiles != null && !this.argfiles.isEmpty()) {
            this.tz = new TorrentZip(this, this);
            for (File argfile : this.argfiles) {
                if (argfile.isDirectory()) {
                    try {
                        this.processDir(argfile);
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                    }
                    continue;
                }
                String dir = argfile.getParent();
                if (dir == null) {
                    dir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                }
                String filename = argfile.getName();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(dir, new String[0]), filename);){
                    dirStream.forEach(path -> {
                        String ext = FilenameUtils.getExtension((String)path.getFileName().toString());
                        if (ext != null && ext.equalsIgnoreCase("zip")) {
                            try {
                                this.processFile(path.toFile());
                            }
                            catch (IOException e) {
                                System.err.println(e.getMessage());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        if (this.guiLaunch) {
            System.out.format(Messages.getString("Program.Complete"), new Object[0]);
            try (Scanner scanner = new Scanner(System.in);){
                scanner.nextLine();
            }
        }
    }

    private void processDir(File dir) throws IOException {
        File[] files;
        if (this.isVerboseLogging()) {
            System.out.println(Messages.getString("Program.CheckingDir") + dir);
        }
        if ((files = dir.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if (this.noRecursion) continue;
                    this.processDir(f);
                    continue;
                }
                String ext = FilenameUtils.getExtension((String)f.getName());
                if (ext == null || !ext.equalsIgnoreCase("zip")) continue;
                this.tz.process(f);
            }
        }
    }

    private void processFile(File file) throws IOException {
        this.tz.process(file);
    }

    @Override
    public final void statusLogCallBack(String log) {
        System.out.format("%s%n", log);
    }

    @Override
    public final void statusCallBack(int percent) {
        System.out.format("%03d%% ", percent);
    }

    @Override
    public final boolean isVerboseLogging() {
        return this.verboseLogging;
    }
}

