/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jtrrntzip.LogCallback;
import jtrrntzip.Messages;
import jtrrntzip.TrrntZipStatus;
import jtrrntzip.ZippedFile;

public class TorrentZipCheck {
    private TorrentZipCheck() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<TrrntZipStatus> checkZipFiles(List<ZippedFile> zippedFiles, LogCallback StatusLogCallBack) {
        EnumSet<TrrntZipStatus> tzStatus = EnumSet.noneOf(TrrntZipStatus.class);
        boolean error1 = false;
        for (ZippedFile t : zippedFiles) {
            char[] bytes = t.getName().toCharArray();
            boolean fixDir = false;
            for (int j = 0; j < bytes.length; ++j) {
                if (bytes[j] != '\\') continue;
                fixDir = true;
                bytes[j] = 47;
                tzStatus.add(TrrntZipStatus.BADDIRECTORYSEPARATOR);
                if (error1 || !StatusLogCallBack.isVerboseLogging()) continue;
                error1 = true;
                StatusLogCallBack.statusLogCallBack(Messages.getString("TorrentZipCheck.IncorrectDirectorySeparatoreFound"));
            }
            if (!fixDir) continue;
            t.setName(new String(bytes));
        }
        boolean error2 = false;
        boolean thisSortFound = true;
        while (thisSortFound) {
            thisSortFound = false;
            for (int i = 0; i < zippedFiles.size() - 1; ++i) {
                int c = zippedFiles.get(i).getName().compareToIgnoreCase(zippedFiles.get(i + 1).getName());
                if (c <= 0) continue;
                ZippedFile zf = zippedFiles.get(i);
                zippedFiles.set(i, zippedFiles.get(i + 1));
                zippedFiles.set(i + 1, zf);
                tzStatus.add(TrrntZipStatus.UNSORTED);
                thisSortFound = true;
                if (error2 || !StatusLogCallBack.isVerboseLogging()) continue;
                error2 = true;
                StatusLogCallBack.statusLogCallBack(Messages.getString("TorrentZipCheck.IncorrectFileOrderFound"));
            }
        }
        boolean error3 = false;
        for (int i = 0; i < zippedFiles.size() - 1; ++i) {
            if (zippedFiles.get(i).getName().charAt(zippedFiles.get(i).getName().length() - 1) != '/' || zippedFiles.get(i + 1).getName().length() <= zippedFiles.get(i).getName().length()) continue;
            boolean delete = true;
            for (int j = 0; j < zippedFiles.get(i).getName().length(); ++j) {
                if (zippedFiles.get(i).getName().charAt(j) == zippedFiles.get(i + 1).getName().charAt(j)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            zippedFiles.remove(i);
            tzStatus.add(TrrntZipStatus.EXTRADIRECTORYENTRIES);
            if (!error3 && StatusLogCallBack.isVerboseLogging()) {
                error3 = true;
                StatusLogCallBack.statusLogCallBack(Messages.getString("TorrentZipCheck.UnneededDirectoryRecordsFound"));
            }
            --i;
        }
        boolean error4 = false;
        for (int i = 0; i < zippedFiles.size() - 1; ++i) {
            if (!zippedFiles.get(i).getName().equals(zippedFiles.get(i + 1).getName())) continue;
            tzStatus.add(TrrntZipStatus.REPEATFILESFOUND);
            if (error4 || !StatusLogCallBack.isVerboseLogging()) continue;
            error4 = true;
            StatusLogCallBack.statusLogCallBack(Messages.getString("TorrentZipCheck.DuplicateFileEntriesFound"));
        }
        return tzStatus;
    }
}

