/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jrm.locale.Messages;
import jrm.misc.ProfileSettingsEnum;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JFileDropList;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JFileDropTextField;
import jrm.ui.basic.JListHintUI;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JTextFieldHintUI;
import jrm.ui.basic.Popup;
import org.apache.commons.lang3.StringUtils;

public class ScannerDirPanel
extends JPanel {
    private static final String MAIN_FRAME_CHOOSE_SAMPLES_DESTINATION = "MainFrame.ChooseSamplesDestination";
    private static final String MAIN_FRAME_CHOOSE_BACKUP_DESTINATION = "MainFrame.ChooseBackupDestination";
    private static final String MAIN_FRAME_CHOOSE_SW_DISKS_DESTINATION = "MainFrame.ChooseSWDisksDestination";
    private static final String MAIN_FRAME_CHOOSE_SW_ROMS_DESTINATION = "MainFrame.ChooseSWRomsDestination";
    private static final String MAIN_FRAME_CHOOSE_DISKS_DESTINATION = "MainFrame.ChooseDisksDestination";
    private static final String MAIN_FRAME_CHOOSE_ROMS_DESTINATION = "MainFrame.ChooseRomsDestination";
    private static final String MAIN_FRAME_DROP_DIR_HINT = "MainFrame.DropDirHint";
    private static final String ICONS_DISK = "/jrm/resicons/icons/disk.png";
    private JCheckBox lblDisksDest;
    private JCheckBox lblSamplesDest;
    private JCheckBox lblBackupDest;
    private JCheckBox lblSWDest;
    private JCheckBox lblSWDisksDest;
    private JFileDropList listSrcDir;
    private JMenuItem mntmDeleteSelected;
    private JFileDropTextField tfDisksDest;
    private JFileDropTextField tfSamplesDest;
    private JFileDropTextField tfBackupDest;
    private JFileDropTextField tfSWDest;
    private JFileDropTextField tfSWDisksDest;
    JFileDropTextField txtRomsDest;
    JButton btnRomsDest;

    public ScannerDirPanel(Session session) {
        GridBagLayout gblScannerDirectories = new GridBagLayout();
        gblScannerDirectories.columnWidths = new int[]{109, 65, 0, 0};
        gblScannerDirectories.rowHeights = new int[]{26, 0, 0, 0, 0, 0, 0};
        gblScannerDirectories.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblScannerDirectories.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gblScannerDirectories);
        this.buildRomsDestDir(session);
        this.buildDisksDestDir(session);
        this.buildSWDestDir(session);
        this.buildSWDisksDestDir(session);
        this.buildSamplesDestDir(session);
        this.buildBackupDestDir(session);
        this.buildSrcDirs(session);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ScannerDirPanel.this.mntmDeleteSelected.setEnabled(!ScannerDirPanel.this.listSrcDir.getSelectedValuesList().isEmpty());
            }
        });
        Popup.addPopup(this.listSrcDir, popupMenu);
        this.mntmDeleteSelected = new JMenuItem(Messages.getString((String)"MainFrame.mntmDeleteSelected.text"));
        this.mntmDeleteSelected.addActionListener(e -> this.listSrcDir.del(this.listSrcDir.getSelectedValuesList()));
        this.mntmDeleteSelected.setIcon(MainFrame.getIcon("/jrm/resicons/icons/folder_delete.png"));
        popupMenu.add(this.mntmDeleteSelected);
        JMenuItem mntmAddDirectory = new JMenuItem(Messages.getString((String)"MainFrame.mntmAddDirectory.text"));
        mntmAddDirectory.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(session.getCurrProfile().getProperty("MainFrame.ChooseRomsSource", workdir.getAbsolutePath())), null, null, null, true).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty("MainFrame.ChooseRomsSource", chooser.getCurrentDirectory().getAbsolutePath());
                this.listSrcDir.add(chooser.getSelectedFiles());
                return true;
            });
        });
        mntmAddDirectory.setIcon(MainFrame.getIcon("/jrm/resicons/icons/folder_add.png"));
        popupMenu.add(mntmAddDirectory);
    }

    private void buildSrcDirs(Session session) {
        JLabel lblSrcDir = new JLabel(Messages.getString((String)"MainFrame.lblSrcDir.text"));
        lblSrcDir.setHorizontalAlignment(11);
        GridBagConstraints gbcLblSrcDir = new GridBagConstraints();
        gbcLblSrcDir.fill = 2;
        gbcLblSrcDir.anchor = 11;
        gbcLblSrcDir.insets = new Insets(0, 0, 0, 5);
        gbcLblSrcDir.gridx = 0;
        gbcLblSrcDir.gridy = 6;
        this.add((Component)lblSrcDir, gbcLblSrcDir);
        this.listSrcDir = new JFileDropList(files -> session.getCurrProfile().setProperty(ProfileSettingsEnum.src_dir, String.join((CharSequence)"|", files.stream().map(File::getAbsolutePath).toList())));
        this.listSrcDir.setMode(JFileDropMode.DIRECTORY);
        this.listSrcDir.setUI(new JListHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        GridBagConstraints gbcListSrcDir = new GridBagConstraints();
        gbcListSrcDir.insets = new Insets(0, 0, 5, 5);
        gbcListSrcDir.gridwidth = 2;
        gbcListSrcDir.fill = 1;
        gbcListSrcDir.gridx = 1;
        gbcListSrcDir.gridy = 6;
        this.add((Component)this.listSrcDir, gbcListSrcDir);
        this.listSrcDir.setBorder(new BevelBorder(1, null, null, null, null));
    }

    private void buildSWDisksDestDir(Session session) throws HeadlessException {
        JButton btnSWDisksDest = new JButton("");
        btnSWDisksDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_SW_DISKS_DESTINATION, workdir.getAbsolutePath())), new File(this.tfSWDisksDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_SW_DISKS_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_SW_DISKS_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSWDisksDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.swdisks_dest_dir, this.tfSWDisksDest.getText());
                return true;
            });
        });
        btnSWDisksDest.setEnabled(false);
        btnSWDisksDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        this.lblSWDisksDest = new JCheckBox(Messages.getString((String)"MainFrame.chckbxSwdisksdest.text"));
        this.lblSWDisksDest.addItemListener(e -> {
            this.tfSWDisksDest.setEnabled(e.getStateChange() == 1);
            btnSWDisksDest.setEnabled(e.getStateChange() == 1);
            session.getCurrProfile().setProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, e.getStateChange() == 1);
        });
        GridBagConstraints gbcLblSWDisksDest = new GridBagConstraints();
        gbcLblSWDisksDest.insets = new Insets(0, 0, 5, 5);
        gbcLblSWDisksDest.gridx = 0;
        gbcLblSWDisksDest.gridy = 3;
        this.add((Component)this.lblSWDisksDest, gbcLblSWDisksDest);
        this.tfSWDisksDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.swdisks_dest_dir, txt));
        this.tfSWDisksDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSWDisksDest.setEnabled(false);
        this.tfSWDisksDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.tfSWDisksDest.setText("");
        GridBagConstraints gbcTFSWDisksDest = new GridBagConstraints();
        gbcTFSWDisksDest.insets = new Insets(0, 0, 5, 0);
        gbcTFSWDisksDest.fill = 1;
        gbcTFSWDisksDest.gridx = 1;
        gbcTFSWDisksDest.gridy = 3;
        this.add((Component)this.tfSWDisksDest, gbcTFSWDisksDest);
        this.tfSWDisksDest.setColumns(10);
        GridBagConstraints gbcBtnSWDisksDest = new GridBagConstraints();
        gbcBtnSWDisksDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnSWDisksDest.gridx = 2;
        gbcBtnSWDisksDest.gridy = 3;
        this.add((Component)btnSWDisksDest, gbcBtnSWDisksDest);
    }

    private void buildSWDestDir(Session session) throws HeadlessException {
        JButton btnSWDest = new JButton("");
        btnSWDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_SW_ROMS_DESTINATION, workdir.getAbsolutePath())), new File(this.tfSWDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_SW_ROMS_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_SW_ROMS_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSWDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.swroms_dest_dir, this.tfSWDest.getText());
                return null;
            });
        });
        btnSWDest.setEnabled(false);
        btnSWDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        this.lblSWDest = new JCheckBox(Messages.getString((String)"MainFrame.chckbxSoftwareDest.text"));
        this.lblSWDest.addItemListener(e -> {
            this.tfSWDest.setEnabled(e.getStateChange() == 1);
            btnSWDest.setEnabled(e.getStateChange() == 1);
            session.getCurrProfile().setProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, e.getStateChange() == 1);
        });
        this.lblSWDest.setHorizontalAlignment(11);
        GridBagConstraints gbcLblSWDest = new GridBagConstraints();
        gbcLblSWDest.fill = 2;
        gbcLblSWDest.insets = new Insets(0, 0, 5, 5);
        gbcLblSWDest.gridx = 0;
        gbcLblSWDest.gridy = 2;
        this.add((Component)this.lblSWDest, gbcLblSWDest);
        this.tfSWDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.swroms_dest_dir, txt));
        this.tfSWDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSWDest.setEnabled(false);
        this.tfSWDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.tfSWDest.setText("");
        GridBagConstraints gbcTFSWDest = new GridBagConstraints();
        gbcTFSWDest.insets = new Insets(0, 0, 5, 0);
        gbcTFSWDest.fill = 1;
        gbcTFSWDest.gridx = 1;
        gbcTFSWDest.gridy = 2;
        this.add((Component)this.tfSWDest, gbcTFSWDest);
        this.tfSWDest.setColumns(10);
        GridBagConstraints gbcBtnSWDest = new GridBagConstraints();
        gbcBtnSWDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnSWDest.gridx = 2;
        gbcBtnSWDest.gridy = 2;
        this.add((Component)btnSWDest, gbcBtnSWDest);
    }

    private void buildDisksDestDir(Session session) throws HeadlessException {
        JButton btnDisksDest = new JButton("");
        btnDisksDest.setEnabled(false);
        btnDisksDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        btnDisksDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_DISKS_DESTINATION, workdir.getAbsolutePath())), new File(this.tfDisksDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_DISKS_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_DISKS_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDisksDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.disks_dest_dir, this.tfDisksDest.getText());
                return null;
            });
        });
        this.lblDisksDest = new JCheckBox(Messages.getString((String)"MainFrame.lblDisksDest.text"));
        this.lblDisksDest.addItemListener(e -> {
            this.tfDisksDest.setEnabled(e.getStateChange() == 1);
            btnDisksDest.setEnabled(e.getStateChange() == 1);
            session.getCurrProfile().setProperty(ProfileSettingsEnum.disks_dest_dir_enabled, e.getStateChange() == 1);
        });
        this.lblDisksDest.setHorizontalAlignment(11);
        GridBagConstraints gbcLblDisksDest = new GridBagConstraints();
        gbcLblDisksDest.fill = 2;
        gbcLblDisksDest.insets = new Insets(0, 0, 5, 5);
        gbcLblDisksDest.gridx = 0;
        gbcLblDisksDest.gridy = 1;
        this.add((Component)this.lblDisksDest, gbcLblDisksDest);
        this.tfDisksDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.disks_dest_dir, txt));
        this.tfDisksDest.setMode(JFileDropMode.DIRECTORY);
        this.tfDisksDest.setEnabled(false);
        this.tfDisksDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.tfDisksDest.setText("");
        GridBagConstraints gbcTFDisksDest = new GridBagConstraints();
        gbcTFDisksDest.insets = new Insets(0, 0, 5, 0);
        gbcTFDisksDest.fill = 1;
        gbcTFDisksDest.gridx = 1;
        gbcTFDisksDest.gridy = 1;
        this.add((Component)this.tfDisksDest, gbcTFDisksDest);
        this.tfDisksDest.setColumns(10);
        GridBagConstraints gbcBtnDisksDest = new GridBagConstraints();
        gbcBtnDisksDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnDisksDest.gridx = 2;
        gbcBtnDisksDest.gridy = 1;
        this.add((Component)btnDisksDest, gbcBtnDisksDest);
    }

    private void buildRomsDestDir(Session session) throws HeadlessException {
        JLabel lblRomsDest = new JLabel(Messages.getString((String)"MainFrame.lblRomsDest.text"));
        lblRomsDest.setHorizontalAlignment(11);
        GridBagConstraints gbcLblRomsDest = new GridBagConstraints();
        gbcLblRomsDest.fill = 2;
        gbcLblRomsDest.insets = new Insets(5, 0, 5, 5);
        gbcLblRomsDest.gridx = 0;
        gbcLblRomsDest.gridy = 0;
        this.add((Component)lblRomsDest, gbcLblRomsDest);
        this.txtRomsDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.roms_dest_dir, txt));
        this.txtRomsDest.setMode(JFileDropMode.DIRECTORY);
        this.txtRomsDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.txtRomsDest.setColumns(10);
        GridBagConstraints gbcTxtRomsDest = new GridBagConstraints();
        gbcTxtRomsDest.fill = 1;
        gbcTxtRomsDest.insets = new Insets(5, 0, 5, 0);
        gbcTxtRomsDest.gridx = 1;
        gbcTxtRomsDest.gridy = 0;
        this.add((Component)this.txtRomsDest, gbcTxtRomsDest);
        this.btnRomsDest = new JButton("");
        this.btnRomsDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        this.btnRomsDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_ROMS_DESTINATION, workdir.getAbsolutePath())), new File(this.txtRomsDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_ROMS_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_ROMS_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.txtRomsDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.roms_dest_dir, this.txtRomsDest.getText());
                return null;
            });
        });
        GridBagConstraints gbcBtnRomsDest = new GridBagConstraints();
        gbcBtnRomsDest.anchor = 18;
        gbcBtnRomsDest.insets = new Insets(5, 0, 5, 5);
        gbcBtnRomsDest.gridx = 2;
        gbcBtnRomsDest.gridy = 0;
        this.add((Component)this.btnRomsDest, gbcBtnRomsDest);
    }

    private void buildSamplesDestDir(Session session) throws HeadlessException {
        JButton btnSamplesDest = new JButton("");
        btnSamplesDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_SAMPLES_DESTINATION, workdir.getAbsolutePath())), new File(this.tfSamplesDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_SAMPLES_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_SAMPLES_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfSamplesDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.samples_dest_dir, this.tfSamplesDest.getText());
                return true;
            });
        });
        btnSamplesDest.setEnabled(false);
        btnSamplesDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        this.lblSamplesDest = new JCheckBox(Messages.getString((String)"MainFrame.lblSamplesDest.text"));
        this.lblSamplesDest.addItemListener(e -> {
            this.tfSamplesDest.setEnabled(e.getStateChange() == 1);
            btnSamplesDest.setEnabled(e.getStateChange() == 1);
            session.getCurrProfile().setProperty(ProfileSettingsEnum.samples_dest_dir_enabled, e.getStateChange() == 1);
        });
        this.lblSamplesDest.setHorizontalAlignment(11);
        GridBagConstraints gbcLblSamplesDest = new GridBagConstraints();
        gbcLblSamplesDest.fill = 2;
        gbcLblSamplesDest.insets = new Insets(0, 0, 5, 5);
        gbcLblSamplesDest.gridx = 0;
        gbcLblSamplesDest.gridy = 4;
        this.add((Component)this.lblSamplesDest, gbcLblSamplesDest);
        this.tfSamplesDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.samples_dest_dir, txt));
        this.tfSamplesDest.setMode(JFileDropMode.DIRECTORY);
        this.tfSamplesDest.setEnabled(false);
        this.tfSamplesDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.tfSamplesDest.setText("");
        GridBagConstraints gbcTFSamplesDest = new GridBagConstraints();
        gbcTFSamplesDest.insets = new Insets(0, 0, 5, 0);
        gbcTFSamplesDest.fill = 1;
        gbcTFSamplesDest.gridx = 1;
        gbcTFSamplesDest.gridy = 4;
        this.add((Component)this.tfSamplesDest, gbcTFSamplesDest);
        this.tfSamplesDest.setColumns(10);
        GridBagConstraints gbcBtnSamplesDest = new GridBagConstraints();
        gbcBtnSamplesDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnSamplesDest.gridx = 2;
        gbcBtnSamplesDest.gridy = 4;
        this.add((Component)btnSamplesDest, gbcBtnSamplesDest);
    }

    private void buildBackupDestDir(Session session) throws HeadlessException {
        JButton btnBackupDest = new JButton("");
        btnBackupDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(session.getCurrProfile().getProperty(MAIN_FRAME_CHOOSE_BACKUP_DESTINATION, workdir.getAbsolutePath())), new File(this.tfBackupDest.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_BACKUP_DESTINATION), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getCurrProfile().setProperty(MAIN_FRAME_CHOOSE_BACKUP_DESTINATION, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfBackupDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getCurrProfile().setProperty(ProfileSettingsEnum.backup_dest_dir, this.tfBackupDest.getText());
                return true;
            });
        });
        btnBackupDest.setEnabled(false);
        btnBackupDest.setIcon(MainFrame.getIcon(ICONS_DISK));
        this.lblBackupDest = new JCheckBox(Messages.getString((String)"MainFrame.lblBackupDest.text"));
        this.lblBackupDest.addItemListener(e -> {
            this.tfBackupDest.setEnabled(e.getStateChange() == 1);
            btnBackupDest.setEnabled(e.getStateChange() == 1);
            session.getCurrProfile().setProperty(ProfileSettingsEnum.backup_dest_dir_enabled, e.getStateChange() == 1);
        });
        this.lblBackupDest.setHorizontalAlignment(11);
        GridBagConstraints gbcLblBackupDest = new GridBagConstraints();
        gbcLblBackupDest.fill = 2;
        gbcLblBackupDest.insets = new Insets(0, 0, 5, 5);
        gbcLblBackupDest.gridx = 0;
        gbcLblBackupDest.gridy = 5;
        this.add((Component)this.lblBackupDest, gbcLblBackupDest);
        this.tfBackupDest = new JFileDropTextField(txt -> session.getCurrProfile().setProperty(ProfileSettingsEnum.backup_dest_dir, txt));
        this.tfBackupDest.setMode(JFileDropMode.DIRECTORY);
        this.tfBackupDest.setEnabled(false);
        this.tfBackupDest.setUI(new JTextFieldHintUI(Messages.getString((String)MAIN_FRAME_DROP_DIR_HINT), Color.gray));
        this.tfBackupDest.setText("");
        GridBagConstraints gbcTFBackupDest = new GridBagConstraints();
        gbcTFBackupDest.insets = new Insets(0, 0, 5, 0);
        gbcTFBackupDest.fill = 1;
        gbcTFBackupDest.gridx = 1;
        gbcTFBackupDest.gridy = 5;
        this.add((Component)this.tfBackupDest, gbcTFBackupDest);
        this.tfBackupDest.setColumns(10);
        GridBagConstraints gbcBtnBackupDest = new GridBagConstraints();
        gbcBtnBackupDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnBackupDest.gridx = 2;
        gbcBtnBackupDest.gridy = 5;
        this.add((Component)btnBackupDest, gbcBtnBackupDest);
    }

    public void initProfileSettings(Session session) {
        this.txtRomsDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.roms_dest_dir));
        this.lblDisksDest.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class));
        this.tfDisksDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.disks_dest_dir));
        this.lblSWDest.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, Boolean.class));
        this.tfSWDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.swroms_dest_dir));
        this.lblSWDisksDest.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, Boolean.class));
        this.tfSWDisksDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.swdisks_dest_dir));
        this.lblSamplesDest.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.samples_dest_dir_enabled, Boolean.class));
        this.tfSamplesDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.samples_dest_dir));
        this.lblBackupDest.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class));
        this.tfBackupDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.backup_dest_dir));
        ((DefaultListModel)this.listSrcDir.getModel()).removeAllElements();
        for (String s : StringUtils.split((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.src_dir), (char)'|')) {
            if (s.isEmpty()) continue;
            ((DefaultListModel)this.listSrcDir.getModel()).addElement(new File(s));
        }
    }
}

