/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jrm.locale.Messages;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.SettingsCompressorsPanel;
import jrm.ui.SettingsDbgPanel;
import jrm.ui.SettingsGenPanel;

public class SettingsPanel
extends JPanel {
    private JTabbedPane settingsPane;

    public SettingsPanel(Session session) {
        this.setLayout(new BorderLayout(0, 0));
        this.settingsPane = new JTabbedPane(1);
        this.add(this.settingsPane);
        this.buildSettingsGenTab(session);
        this.buildSettingsCompressorsTab(session);
        this.buildSettingsDebugTab(session);
    }

    private void buildSettingsGenTab(Session session) {
        SettingsGenPanel panel = new SettingsGenPanel(session);
        this.settingsPane.addTab("General", MainFrame.getIcon("/jrm/resicons/icons/cog.png"), panel, null);
    }

    private void buildSettingsCompressorsTab(Session session) {
        SettingsCompressorsPanel compressors = new SettingsCompressorsPanel(session);
        this.settingsPane.addTab(Messages.getString((String)"MainFrame.Compressors"), MainFrame.getIcon("/jrm/resicons/icons/compress.png"), compressors, null);
    }

    private void buildSettingsDebugTab(Session session) {
        SettingsDbgPanel debug = new SettingsDbgPanel(session);
        this.settingsPane.addTab(Messages.getString((String)"MainFrame.Debug"), MainFrame.getIcon("/jrm/resicons/icons/bug.png"), debug, null);
    }
}

