/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Predicate;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jrm.misc.Ideone;
import jrm.ui.basic.JTristateCheckBox;

public class JCheckBoxList<E>
extends JList<E> {
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    JTristateCheckBox[] checkboxes = null;

    public JCheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = JCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1 && e.getButton() == 1) {
                    JCheckBoxList.this.checkboxes[index].setSelected(!JCheckBoxList.this.checkboxes[index].isSelected());
                    for (ListSelectionListener l : JCheckBoxList.this.getListSelectionListeners()) {
                        l.valueChanged(new ListSelectionEvent(this, index, index, false));
                    }
                    JCheckBoxList.this.repaint();
                }
                super.mousePressed(e);
            }
        });
        this.setSelectionMode(0);
    }

    @Override
    public void setModel(ListModel<E> model) {
        super.setModel(model);
        this.setEnabled(model.getSize() > 0);
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.checkboxes[index].isSelected();
    }

    public void selectAll() {
        for (JTristateCheckBox checkbox : this.checkboxes) {
            checkbox.setSelected(true);
        }
        for (ListSelectionListener l : this.getListSelectionListeners()) {
            l.valueChanged(new ListSelectionEvent(this, 0, this.checkboxes.length - 1, false));
        }
        this.repaint();
    }

    public void selectNone() {
        for (JTristateCheckBox checkbox : this.checkboxes) {
            checkbox.setSelected(false);
        }
        for (ListSelectionListener l : this.getListSelectionListeners()) {
            l.valueChanged(new ListSelectionEvent(this, 0, this.checkboxes.length - 1, false));
        }
        this.repaint();
    }

    public void selectInvert() {
        for (JTristateCheckBox checkbox : this.checkboxes) {
            checkbox.setSelected(!checkbox.isSelected());
        }
        for (ListSelectionListener l : this.getListSelectionListeners()) {
            l.valueChanged(new ListSelectionEvent(this, 0, this.checkboxes.length - 1, false));
        }
        this.repaint();
    }

    public void select(Predicate<E> predicate, boolean selected) {
        Ideone ideone = new Ideone();
        for (int i2 = 0; i2 < this.checkboxes.length; ++i2) {
            if (!predicate.test(this.getModel().getElementAt(i2))) continue;
            this.checkboxes[i2].setSelected(selected);
            ideone.add(i2, i2 + 1);
        }
        ideone.merge().forEach(i -> {
            for (ListSelectionListener l : this.getListSelectionListeners()) {
                l.valueChanged(new ListSelectionEvent(this, i.getStart(), i.getEnd() - 1, false));
            }
        });
        this.repaint();
    }

    public class CellRenderer
    implements ListCellRenderer<E> {
        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            if (JCheckBoxList.this.checkboxes == null || JCheckBoxList.this.checkboxes.length != list.getModel().getSize()) {
                JCheckBoxList.this.checkboxes = new JTristateCheckBox[list.getModel().getSize()];
            }
            if (JCheckBoxList.this.checkboxes[index] == null) {
                JCheckBoxList.this.checkboxes[index] = new JTristateCheckBox();
                JCheckBoxList.this.checkboxes[index].setFont(JCheckBoxList.this.getFont());
                JCheckBoxList.this.checkboxes[index].setFocusPainted(false);
                JCheckBoxList.this.checkboxes[index].setBorderPainted(true);
            }
            JCheckBoxList.this.checkboxes[index].setText(value.toString());
            JCheckBoxList.this.checkboxes[index].setEnabled(JCheckBoxList.this.isEnabled());
            JCheckBoxList.this.checkboxes[index].setBackground(isSelected ? JCheckBoxList.this.getSelectionBackground() : JCheckBoxList.this.getBackground());
            JCheckBoxList.this.checkboxes[index].setForeground(isSelected ? JCheckBoxList.this.getSelectionForeground() : JCheckBoxList.this.getForeground());
            JCheckBoxList.this.checkboxes[index].setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return JCheckBoxList.this.checkboxes[index];
        }
    }
}

