/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import jrm.aui.progress.ProgressHandler;
import jrm.aui.status.StatusRendererFactory;
import jrm.batch.Compressor;
import jrm.batch.CompressorFormat;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.MultiThreadingVirtual;
import jrm.misc.SettingsEnum;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.AbstractEnhTableModel;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.batch.FileCellRenderer;
import jrm.ui.batch.StatusCellRenderer;
import jrm.ui.progress.SwingWorkerProgress;
import org.apache.commons.io.FilenameUtils;

public class BatchCompressorPanel
extends JPanel
implements StatusRendererFactory {
    private BatchCompressorTable table;
    private JCheckBox chckbxForce;
    private JComboBox<CompressorFormat> comboBox;
    private JButton btnClear;
    private JPopupMenu popupMenu;
    private JMenuItem mntmAddArchive;
    private JMenuItem mntmRemoveSelectedArchives;

    public BatchCompressorPanel(Session session) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{450, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{300, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.gridwidth = 5;
        gbcScrollPane.insets = new Insets(0, 0, 5, 0);
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 0;
        this.add((Component)scrollPane, gbcScrollPane);
        this.table = new BatchCompressorTable(new BatchCompressorTableModel(), files -> {});
        scrollPane.setViewportView(this.table);
        this.popupMenu = new JPopupMenu();
        BatchCompressorPanel.addPopup(this.table, this.popupMenu);
        this.mntmAddArchive = new JMenuItem(Messages.getString((String)"BatchCompressorPanel.mntmAddArchive.text"));
        this.mntmAddArchive.addActionListener(e -> {
            String[] extensions = new String[]{"zip", "7z", "rar", "arj", "tar", "lzh", "lha", "tgz", "tbz", "tbz2", "rpm", "iso", "deb", "cab"};
            new JRMFileChooser<Void>(0, 2, null, null, Collections.singletonList(this.getFileFilter(extensions)), Messages.getString((String)"BatchCompressorPanel.mntmAddArchive.text"), true).showOpen(SwingUtilities.windowForComponent(this), chooser -> {
                File[] files = chooser.getSelectedFiles();
                this.addArchiveChooser(extensions, files);
                return null;
            });
        });
        this.popupMenu.add(this.mntmAddArchive);
        this.mntmRemoveSelectedArchives = new JMenuItem(Messages.getString((String)"BatchCompressorPanel.mntmRemoveSelectedArchives.text"));
        this.mntmRemoveSelectedArchives.addActionListener(e -> this.table.del(this.table.getSelectedValuesList()));
        this.popupMenu.add(this.mntmRemoveSelectedArchives);
        this.comboBox = new JComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<CompressorFormat>(CompressorFormat.values()));
        this.comboBox.setSelectedIndex(1);
        if (session != null) {
            this.comboBox.setSelectedItem(CompressorFormat.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_format)));
        }
        this.comboBox.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.compressor_format, this.comboBox.getSelectedItem().toString()));
        GridBagConstraints gbcComboBox = new GridBagConstraints();
        gbcComboBox.insets = new Insets(0, 0, 0, 5);
        gbcComboBox.fill = 2;
        gbcComboBox.gridx = 1;
        gbcComboBox.gridy = 1;
        this.add(this.comboBox, gbcComboBox);
        this.chckbxForce = new JCheckBox(Messages.getString((String)"BatchCompressorPanel.Force"));
        this.chckbxForce.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.compressor_force, this.chckbxForce.isSelected()));
        if (session != null) {
            this.chckbxForce.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_force, Boolean.class));
        }
        GridBagConstraints gbcChckbxForce = new GridBagConstraints();
        gbcChckbxForce.insets = new Insets(0, 0, 0, 5);
        gbcChckbxForce.gridx = 2;
        gbcChckbxForce.gridy = 1;
        this.add((Component)this.chckbxForce, gbcChckbxForce);
        JButton btnStart = new JButton(Messages.getString((String)"BatchCompressorPanel.Start"));
        btnStart.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_go.png"));
        btnStart.addActionListener(e -> this.start(session));
        this.btnClear = new JButton(Messages.getString((String)"BatchCompressorPanel.btnClear.text"));
        this.btnClear.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bin.png"));
        this.btnClear.addActionListener(e -> this.table.model.setData(new ArrayList<Compressor.FileResult>()));
        GridBagConstraints gbcBtnClear = new GridBagConstraints();
        gbcBtnClear.insets = new Insets(0, 0, 0, 5);
        gbcBtnClear.gridx = 3;
        gbcBtnClear.gridy = 1;
        this.add((Component)this.btnClear, gbcBtnClear);
        GridBagConstraints gbcBtnStart = new GridBagConstraints();
        gbcBtnStart.gridx = 4;
        gbcBtnStart.gridy = 1;
        this.add((Component)btnStart, gbcBtnStart);
    }

    private void start(final Session session) {
        new SwingWorkerProgress<Void, Void>(SwingUtilities.getWindowAncestor(this)){

            @Override
            protected Void doInBackground() throws Exception {
                this.setInfos(Runtime.getRuntime().availableProcessors(), true);
                for (int i = 0; i < BatchCompressorPanel.this.table.getRowCount(); ++i) {
                    BatchCompressorPanel.this.table.setValueAt("", i, 1);
                }
                AtomicInteger cnt = new AtomicInteger();
                Compressor compressor = new Compressor(session, cnt, BatchCompressorPanel.this.table.getRowCount(), (ProgressHandler)this);
                Boolean use_parallelism = (Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_parallelism, Boolean.class);
                int nThreads = Boolean.TRUE.equals(use_parallelism) ? (Integer)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.thread_count, Integer.class) : 1;
                try (MultiThreadingVirtual mt = new MultiThreadingVirtual("compressor", (ProgressHandler)this, nThreads, fr -> {
                    if (this.isCancel()) {
                        return;
                    }
                    BatchCompressorPanel.this.compress(cnt, compressor, (Compressor.FileResult)fr);
                });){
                    mt.start(BatchCompressorPanel.this.table.model.getData().stream());
                }
                return null;
            }

            @Override
            protected void done() {
                this.close();
            }
        }.execute();
    }

    private void addArchiveChooser(String[] extensions, File[] files) {
        BatchCompressorTableModel model = (BatchCompressorTableModel)this.table.getModel();
        if (files.length > 0) {
            int startSize = model.getData().size();
            for (File f : files) {
                if (f.isDirectory()) {
                    try (Stream<Path> stream = Files.walk(f.toPath(), new FileVisitOption[0]);){
                        stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.isExtension((String)p.getFileName().toString(), (String[])extensions)).forEachOrdered(p -> model.getData().add(new Compressor.FileResult(p)));
                    }
                    catch (IOException ex) {
                        Log.err((String)ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                model.getData().add(new Compressor.FileResult(f.toPath()));
            }
            if (startSize != model.getData().size()) {
                model.fireTableChanged(new TableModelEvent(model, startSize, model.getData().size() - 1, -1, 1));
            }
        }
    }

    private javax.swing.filechooser.FileFilter getFileFilter(final String[] extensions) {
        return new javax.swing.filechooser.FileFilter(this){

            @Override
            public String getDescription() {
                return "Archive files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || FilenameUtils.isExtension((String)f.getName(), (String[])extensions);
            }
        };
    }

    private void compress(AtomicInteger cnt, Compressor compressor, Compressor.FileResult fr) throws IllegalArgumentException {
        int i = this.table.model.getData().indexOf(fr);
        File file = fr.getFile().toFile();
        cnt.incrementAndGet();
        Compressor.UpdResultCallBack cb = txt -> this.table.setValueAt(txt, i, 1);
        Compressor.UpdSrcCallBack scb = src -> this.table.setValueAt(src, i, 0);
        switch ((CompressorFormat)this.comboBox.getSelectedItem()) {
            case SEVENZIP: {
                this.toSevenZip(compressor, file, cb, scb);
                break;
            }
            case ZIP: {
                this.toZip(compressor, file, cb, scb);
                break;
            }
            case TZIP: {
                this.toTZip(compressor, file, cb, scb);
            }
        }
    }

    private void toSevenZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        switch (FilenameUtils.getExtension((String)file.getName())) {
            case "zip": {
                compressor.zip2SevenZip(file, cb, scb);
                break;
            }
            case "7z": {
                if (this.chckbxForce.isSelected()) {
                    compressor.sevenZip2SevenZip(file, cb, scb);
                    break;
                }
                cb.apply("Skipped");
                break;
            }
            default: {
                compressor.sevenZip2SevenZip(file, cb, scb);
            }
        }
    }

    private void toZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            if (this.chckbxForce.isSelected()) {
                compressor.zip2Zip(file, cb, scb);
            } else {
                cb.apply("Skipped");
            }
        } else {
            compressor.sevenZip2Zip(file, false, cb, scb);
        }
    }

    private void toTZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            compressor.zip2TZip(file, this.chckbxForce.isSelected(), cb);
        } else if ((file = compressor.sevenZip2Zip(file, true, cb, scb)) != null && file.exists()) {
            compressor.zip2TZip(file, this.chckbxForce.isSelected(), cb);
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    static class BatchCompressorTable
    extends JTable
    implements DropTargetListener {
        private transient BatchCompressorTableModel model;
        private transient Color color;
        private final transient AddCallBack callback;

        public BatchCompressorTable(BatchCompressorTableModel model, AddCallBack callback) {
            super(model);
            this.model = model;
            this.callback = callback;
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setCellRenderer(model.getCellRenderer(i));
            }
            this.color = this.getBackground();
            new DropTarget(this, this);
            this.model.addTableModelListener(e -> {
                if (e.getColumn() >= 0 && model.getColumnClass(e.getColumn()).equals(Boolean.class) && e.getType() == 0) {
                    callback.call(model.getData());
                }
            });
            this.setFillsViewportHeight(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.setBackground(Color.decode("#DDFFDD"));
                this.model.fireTableChanged(new TableModelEvent(this.model));
                dtde.acceptDrag(1);
            } else {
                this.setBackground(Color.decode("#FFDDDD"));
                this.model.fireTableChanged(new TableModelEvent(this.model));
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.setBackground(this.color);
            this.model.fireTableChanged(new TableModelEvent(this.model));
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            this.setBackground(this.color);
            this.model.fireTableChanged(new TableModelEvent(this.model));
            try {
                Transferable transferable = dtde.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(1);
                    String[] extensions = new String[]{"zip", "7z", "rar", "arj", "tar", "lzh", "lha", "tgz", "tbz", "tbz2", "rpm", "iso", "deb", "cab"};
                    FileFilter filter = pathname -> pathname.isDirectory() || FilenameUtils.isExtension((String)pathname.getName(), (String[])extensions);
                    List<File> files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(filter::accept).toList();
                    if (!files.isEmpty()) {
                        this.addFiles(files, extensions);
                        dtde.getDropTargetContext().dropComplete(true);
                    } else {
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException e) {
                dtde.rejectDrop();
            }
            catch (Exception e) {
                Log.err((String)e.getMessage(), (Throwable)e);
                dtde.rejectDrop();
            }
        }

        private void addFiles(List<File> files, String[] extensions) throws IOException {
            int startSize = this.model.getData().size();
            for (File f : files) {
                if (f.isDirectory()) {
                    Stream<Path> stream = Files.walk(f.toPath(), new FileVisitOption[0]);
                    try {
                        stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.isExtension((String)p.getFileName().toString(), (String[])extensions)).forEachOrdered(p -> this.model.getData().add(new Compressor.FileResult(p)));
                        continue;
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                        continue;
                    }
                }
                this.model.getData().add(new Compressor.FileResult(f.toPath()));
            }
            if (startSize != this.model.getData().size()) {
                this.model.fireTableChanged(new TableModelEvent(this.model, startSize, this.model.getData().size() - 1, -1, 1));
            }
            this.callback.call(this.model.getData());
        }

        public void del(List<Compressor.FileResult> sdrl) {
            for (Compressor.FileResult sdr : sdrl) {
                this.model.getData().remove(sdr);
            }
            this.model.fireTableChanged(new TableModelEvent(this.model));
            this.callback.call(this.model.getData());
        }

        public List<Compressor.FileResult> getSelectedValuesList() {
            int[] rows = this.getSelectedRows();
            ArrayList<Compressor.FileResult> list = new ArrayList<Compressor.FileResult>();
            for (int row : rows) {
                list.add(this.model.getData().get(row));
            }
            return list;
        }

        @FunctionalInterface
        public static interface AddCallBack {
            public void call(List<Compressor.FileResult> var1);
        }
    }

    static class BatchCompressorTableModel
    extends AbstractEnhTableModel {
        private List<Compressor.FileResult> data = new ArrayList<Compressor.FileResult>();
        private final String[] columnNames = new String[]{Messages.getString((String)"BatchCompressorPanel.File"), Messages.getString((String)"BatchCompressorPanel.Status")};
        private final Class<?>[] columnTypes = new Class[]{Object.class, String.class};
        private final TableCellRenderer[] cellRenderers = new TableCellRenderer[]{new FileCellRenderer(), new StatusCellRenderer()};
        private final int[] widths = new int[]{0, 0};
        private final String[] headersTT = this.columnNames;

        BatchCompressorTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnTypes.length;
        }

        public List<Compressor.FileResult> getData() {
            return this.data;
        }

        public void setData(List<Compressor.FileResult> data) {
            this.data = data;
            this.fireTableChanged(new TableModelEvent(this));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getData().get(rowIndex).getFile();
            }
            if (columnIndex == 1) {
                return this.getData().get(rowIndex).getResult();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public TableCellRenderer getCellRenderer(int column) {
            return this.cellRenderers[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.getData().get(rowIndex).setFile(((File)aValue).toPath());
            }
            if (columnIndex == 1) {
                this.getData().get(rowIndex).setResult((String)aValue);
            }
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
        }

        @Override
        public TableCellRenderer[] getCellRenderers() {
            return this.cellRenderers;
        }

        @Override
        public int getColumnWidth(int columnIndex) {
            return this.widths[columnIndex];
        }

        @Override
        public String getColumnTT(int columnIndex) {
            return this.headersTT[columnIndex];
        }
    }
}

