/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.TorrentChecker;
import jrm.batch.TrntChkReport;
import jrm.io.torrent.options.TrntChkMode;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.SettingsEnum;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JSDRDropTable;
import jrm.ui.basic.Popup;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.batch.BatchTableModel;
import jrm.ui.batch.BatchTrrntChkResultsDialog;
import jrm.ui.progress.SwingWorkerProgress;
import org.apache.commons.io.FilenameUtils;

public class BatchTrrntChkPanel
extends JPanel {
    private JSDRDropTable tableTrntChk;
    private JComboBox<TrntChkMode> cbbxTrntChk;
    private JCheckBox cbRemoveUnknownFiles;
    private JCheckBox cbRemoveWrongSizedFiles;
    private Point popupPoint;
    private JCheckBox chckbxDetectArchivedFolder;

    public BatchTrrntChkPanel(Session session) {
        GridBagLayout gblPanelBatchToolsDir2Torrent = new GridBagLayout();
        gblPanelBatchToolsDir2Torrent.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblPanelBatchToolsDir2Torrent.rowHeights = new int[]{0, 0, 0};
        gblPanelBatchToolsDir2Torrent.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblPanelBatchToolsDir2Torrent.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gblPanelBatchToolsDir2Torrent);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.gridwidth = 6;
        gbcScrollPane.insets = new Insets(0, 0, 5, 0);
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 0;
        this.add((Component)scrollPane, gbcScrollPane);
        BatchTableModel model = new BatchTableModel(new String[]{Messages.getString((String)"MainFrame.TorrentFiles"), Messages.getString((String)"MainFrame.DstDirs"), Messages.getString((String)"MainFrame.Result"), "Details", "Selected"});
        this.tableTrntChk = new JSDRDropTable(model, files -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)files)));
        model.setButtonHandler((row, column) -> new BatchTrrntChkResultsDialog(session, SwingUtilities.getWindowAncestor(this), TrntChkReport.load((Session)session, (File)PathAbstractor.getAbsolutePath((Session)session, (String)((SrcDstResult)model.getData().get(row)).getSrc()).toFile())));
        this.tableTrntChk.addMouseListener(this.getTableTrntChkMouseListener());
        ((BatchTableModel)this.tableTrntChk.getModel()).applyColumnsWidths(this.tableTrntChk);
        SDRList sdrl2 = new SDRList();
        if (session != null) {
            for (JsonValue arrv : Json.parse((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr)).asArray()) {
                JsonValue dst;
                SrcDstResult sdr = new SrcDstResult();
                JsonObject jso = arrv.asObject();
                JsonValue src = jso.get("src");
                if (src != Json.NULL) {
                    sdr.setSrc(src.asString());
                }
                if ((dst = jso.get("dst")) != Json.NULL) {
                    sdr.setDst(dst.asString());
                }
                JsonValue result = jso.get("result");
                sdr.setResult(result.asString());
                sdr.setSelected(jso.getBoolean("selected", true));
                sdrl2.add((Object)sdr);
            }
        }
        this.tableTrntChk.getSDRModel().setData((SDRList<SrcDstResult>)sdrl2);
        this.tableTrntChk.setCellSelectionEnabled(false);
        this.tableTrntChk.setRowSelectionAllowed(true);
        this.tableTrntChk.getSDRModel().setSrcFilter(file -> {
            List<String> exts = Arrays.asList("torrent");
            if (file.isFile()) {
                return exts.contains(FilenameUtils.getExtension((String)file.getName()));
            }
            return false;
        });
        this.tableTrntChk.getSDRModel().setDstFilter(File::isDirectory);
        this.tableTrntChk.setSelectionMode(2);
        this.tableTrntChk.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.tableTrntChk);
        JPopupMenu pmTrntChk = new JPopupMenu();
        Popup.addPopup(this.tableTrntChk, pmTrntChk);
        final JMenuItem mntmAddTorrent = new JMenuItem(Messages.getString((String)"BatchToolsTrrntChkPanel.mntmAddTorrent.text"));
        mntmAddTorrent.addActionListener(e -> this.addTorrent());
        pmTrntChk.add(mntmAddTorrent);
        pmTrntChk.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                mntmAddTorrent.setEnabled(BatchTrrntChkPanel.this.tableTrntChk.columnAtPoint(BatchTrrntChkPanel.this.popupPoint) <= 1);
            }
        });
        JMenuItem mntmDelTorrent = new JMenuItem(Messages.getString((String)"BatchToolsTrrntChkPanel.mntmDelTorrent.text"));
        mntmDelTorrent.addActionListener(e -> this.tableTrntChk.del(this.tableTrntChk.getSelectedValuesList()));
        pmTrntChk.add(mntmDelTorrent);
        JLabel lblCheckMode = new JLabel(Messages.getString((String)"BatchToolsTrrntChkPanel.lblCheckMode.text"));
        GridBagConstraints gbcLblCheckMode = new GridBagConstraints();
        gbcLblCheckMode.insets = new Insets(0, 0, 0, 5);
        gbcLblCheckMode.anchor = 13;
        gbcLblCheckMode.gridx = 0;
        gbcLblCheckMode.gridy = 1;
        this.add((Component)lblCheckMode, gbcLblCheckMode);
        this.cbbxTrntChk = new JComboBox();
        this.cbbxTrntChk.setModel(new DefaultComboBoxModel<TrntChkMode>(TrntChkMode.values()));
        if (session != null) {
            this.cbbxTrntChk.setSelectedItem(TrntChkMode.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_mode)));
        }
        this.cbbxTrntChk.addActionListener(e -> {
            session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_mode, this.cbbxTrntChk.getSelectedItem().toString());
            this.cbRemoveWrongSizedFiles.setEnabled(this.cbbxTrntChk.getSelectedItem() != TrntChkMode.FILENAME);
        });
        GridBagConstraints gbcCbbxTrntChk = new GridBagConstraints();
        gbcCbbxTrntChk.anchor = 13;
        gbcCbbxTrntChk.insets = new Insets(0, 0, 0, 5);
        gbcCbbxTrntChk.gridx = 1;
        gbcCbbxTrntChk.gridy = 1;
        this.add(this.cbbxTrntChk, gbcCbbxTrntChk);
        JButton btnBatchToolsTrntChkStart = new JButton(Messages.getString((String)"BatchToolsTrrntChkPanel.TrntCheckStart.text"));
        btnBatchToolsTrntChkStart.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_go.png"));
        btnBatchToolsTrntChkStart.addActionListener(e -> this.trrntChk(session));
        this.chckbxDetectArchivedFolder = new JCheckBox(Messages.getString((String)"BatchTrrntChkPanel.chckbxDetectArchivedFolder.text"));
        this.chckbxDetectArchivedFolder.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_detect_archived_folders, this.chckbxDetectArchivedFolder.isSelected()));
        if (session != null) {
            this.chckbxDetectArchivedFolder.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_detect_archived_folders, Boolean.class));
        }
        GridBagConstraints gbcChckbxDetectArchivedFolder = new GridBagConstraints();
        gbcChckbxDetectArchivedFolder.insets = new Insets(0, 0, 0, 5);
        gbcChckbxDetectArchivedFolder.gridx = 2;
        gbcChckbxDetectArchivedFolder.gridy = 1;
        this.add((Component)this.chckbxDetectArchivedFolder, gbcChckbxDetectArchivedFolder);
        this.cbRemoveUnknownFiles = new JCheckBox(Messages.getString((String)"BatchToolsTrrntChkPanel.chckbxRemoveUnknownFiles.text"));
        this.cbRemoveUnknownFiles.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_remove_unknown_files, this.cbRemoveUnknownFiles.isSelected()));
        if (session != null) {
            this.cbRemoveUnknownFiles.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_unknown_files, Boolean.class));
        }
        GridBagConstraints gbcCbRemoveUnknownFiles = new GridBagConstraints();
        gbcCbRemoveUnknownFiles.insets = new Insets(0, 0, 0, 5);
        gbcCbRemoveUnknownFiles.gridx = 3;
        gbcCbRemoveUnknownFiles.gridy = 1;
        this.add((Component)this.cbRemoveUnknownFiles, gbcCbRemoveUnknownFiles);
        this.cbRemoveWrongSizedFiles = new JCheckBox(Messages.getString((String)"BatchToolsTrrntChkPanel.chckbxRemoveWrongSized.text"));
        this.cbRemoveWrongSizedFiles.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_remove_wrong_sized_files, this.cbRemoveWrongSizedFiles.isSelected()));
        if (session != null) {
            this.cbRemoveWrongSizedFiles.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_wrong_sized_files, Boolean.class));
        }
        this.cbRemoveWrongSizedFiles.setEnabled(this.cbbxTrntChk.getSelectedItem() != TrntChkMode.FILENAME);
        GridBagConstraints gbcCbRemoveWrongSizedFiles = new GridBagConstraints();
        gbcCbRemoveWrongSizedFiles.anchor = 17;
        gbcCbRemoveWrongSizedFiles.insets = new Insets(0, 0, 0, 5);
        gbcCbRemoveWrongSizedFiles.gridx = 4;
        gbcCbRemoveWrongSizedFiles.gridy = 1;
        this.add((Component)this.cbRemoveWrongSizedFiles, gbcCbRemoveWrongSizedFiles);
        GridBagConstraints gbcBtnBatchToolsTrntChkStart = new GridBagConstraints();
        gbcBtnBatchToolsTrntChkStart.anchor = 13;
        gbcBtnBatchToolsTrntChkStart.gridx = 5;
        gbcBtnBatchToolsTrntChkStart.gridy = 1;
        this.add((Component)btnBatchToolsTrntChkStart, gbcBtnBatchToolsTrntChkStart);
    }

    private void addTorrent() {
        int mode;
        int col = this.tableTrntChk.columnAtPoint(this.popupPoint);
        int row = this.tableTrntChk.rowAtPoint(this.popupPoint);
        SDRList<SrcDstResult> list = this.tableTrntChk.getSelectedValuesList();
        int type = col == 0 ? 0 : 1;
        int n = mode = col == 0 ? 2 : 1;
        File currdir = !list.isEmpty() ? (File)Optional.ofNullable(col == 0 ? ((SrcDstResult)list.get(0)).getSrc() : ((SrcDstResult)list.get(0)).getDst()).map(File::new).map(File::getParentFile).orElse(null) : null;
        new JRMFileChooser<Void>(type, mode, currdir, null, Collections.singletonList(this.getAddTorrentFileFilter(col)), col == 0 ? "Choose torrent files" : "Choose destination directories", true).show(SwingUtilities.windowForComponent(this), chooser -> {
            File[] files = chooser.getSelectedFiles();
            this.addTorrent(col, row, files);
            return null;
        });
    }

    private void addTorrent(int col, int row, File[] files) {
        SDRTableModel model = this.tableTrntChk.getSDRModel();
        if (files.length <= 0) {
            return;
        }
        int startSize = model.getData().size();
        FileFilter filter = col == 0 ? model.getSrcFilter() : model.getDstFilter();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!filter.accept(file)) continue;
            model.addFile(file, row, col, i);
        }
        if (row != -1) {
            model.fireTableChanged(new TableModelEvent(model, row, startSize - 1, col));
        }
        if (startSize != model.getData().size()) {
            model.fireTableChanged(new TableModelEvent(model, startSize, model.getData().size() - 1, -1, 1));
        }
        this.tableTrntChk.call();
    }

    private javax.swing.filechooser.FileFilter getAddTorrentFileFilter(final int col) {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                FileFilter filter = null;
                if (col == 1) {
                    filter = BatchTrrntChkPanel.this.tableTrntChk.getSDRModel().getDstFilter();
                } else if (col == 0) {
                    filter = file -> {
                        List<String> exts = Arrays.asList("torrent");
                        if (file.isFile()) {
                            return exts.contains(FilenameUtils.getExtension((String)file.getName()));
                        }
                        return true;
                    };
                }
                if (filter != null) {
                    return filter.accept(f);
                }
                return true;
            }

            @Override
            public String getDescription() {
                return col == 0 ? "Torrent files" : "Destination directories";
            }
        };
    }

    private MouseAdapter getTableTrntChkMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BatchTrrntChkPanel.this.popupPoint = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BatchTrrntChkPanel.this.popupPoint = e.getPoint();
                }
            }
        };
    }

    private void trrntChk(final Session session) {
        final SDRList<SrcDstResult> sdrl = ((SDRTableModel)this.tableTrntChk.getModel()).getData();
        final TrntChkMode mode = (TrntChkMode)this.cbbxTrntChk.getSelectedItem();
        final JSDRDropTable updater = this.tableTrntChk;
        final EnumSet<TorrentChecker.Options> opts = EnumSet.noneOf(TorrentChecker.Options.class);
        if (this.cbRemoveUnknownFiles.isSelected()) {
            opts.add(TorrentChecker.Options.REMOVEUNKNOWNFILES);
        }
        if (this.cbRemoveWrongSizedFiles.isSelected()) {
            opts.add(TorrentChecker.Options.REMOVEWRONGSIZEDFILES);
        }
        if (this.chckbxDetectArchivedFolder.isSelected()) {
            opts.add(TorrentChecker.Options.DETECTARCHIVEDFOLDERS);
        }
        new SwingWorkerProgress<TorrentChecker<SrcDstResult>, Void>(this, SwingUtilities.getWindowAncestor(this)){

            @Override
            protected TorrentChecker<SrcDstResult> doInBackground() throws Exception {
                return new TorrentChecker(session, (ProgressHandler)this, (List)sdrl, mode, updater, (Set)opts);
            }

            @Override
            protected void done() {
                this.close();
            }
        }.execute();
    }
}

