/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jrm.batch.TrntChkReport;
import jrm.misc.Log;
import jrm.ui.MainFrame;
import jrm.ui.batch.BatchTrrntChkReportNode;

public class BatchTrrntChkReportTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            if (!(value instanceof BatchTrrntChkReportNode.ChildNode)) {
                super.getTreeCellRendererComponent(tree, "Root", sel, expanded, leaf, row, hasFocus);
                return this;
            }
            TrntChkReport.Child node = ((BatchTrrntChkReportNode.ChildNode)value).getChild();
            Object title = node.getData().getTitle();
            if (node.getData().getLength() != null) {
                title = (String)title + " (" + node.getData().getLength() + ")";
            }
            title = (String)title + " [" + String.valueOf(node.getData().getStatus()) + "]";
            super.getTreeCellRendererComponent(tree, title, sel, expanded, leaf, row, hasFocus);
            if (!leaf) {
                this.setIcon(MainFrame.getIcon("/jrm/resicons/folder" + (expanded ? "_open" : "_closed") + this.statusColor(node.getData().getStatus()) + ".png"));
            } else {
                this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet" + this.statusColor(node.getData().getStatus()) + ".png"));
            }
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        return this;
    }

    protected String statusColor(TrntChkReport.Status status) {
        switch (status) {
            case OK: {
                return "_green";
            }
            case MISSING: {
                return "_red";
            }
            case SHA1: {
                return "_purple";
            }
            case SIZE: {
                return "_blue";
            }
            case SKIPPED: {
                return "_orange";
            }
            case UNKNOWN: {
                return "_gray";
            }
        }
        return "";
    }
}

