/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.ui.MainFrame;

public final class AnywareRenderer {
    protected static final String[] columns = new String[]{Messages.getString((String)"AnywareRenderer.Status"), Messages.getString((String)"AnywareRenderer.Name"), Messages.getString((String)"AnywareRenderer.Size"), Messages.getString((String)"AnywareRenderer.CRC"), Messages.getString((String)"AnywareRenderer.MD5"), Messages.getString((String)"AnywareRenderer.SHA-1"), Messages.getString((String)"AnywareRenderer.Merge"), Messages.getString((String)"AnywareRenderer.DumpStatus")};
    protected static final Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, Long.class, String.class, String.class, String.class, String.class, Object.class};
    protected static final int[] columnsWidths = new int[]{-3, 256, -12, -10, -34, -42, 100, -3};
    protected static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){
        ImageIcon bulletGreen = MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png");
        ImageIcon bulletRed = MainFrame.getIcon("/jrm/resicons/icons/bullet_red.png");
        ImageIcon bulletBlack = MainFrame.getIcon("/jrm/resicons/icons/bullet_black.png");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(AnywareRenderer.getBackground(row, column));
            super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            if (value != null) {
                switch (((EntityBase)value).getStatus()) {
                    case OK: {
                        this.setIcon(this.bulletGreen);
                        break;
                    }
                    case KO: {
                        this.setIcon(this.bulletRed);
                        break;
                    }
                    default: {
                        this.setIcon(this.bulletBlack);
                    }
                }
            }
            return this;
        }
    }, new DefaultTableCellRenderer(){
        ImageIcon romSmall = MainFrame.getIcon("/jrm/resicons/rom_small.png");
        ImageIcon drive = MainFrame.getIcon("/jrm/resicons/icons/drive.png");
        ImageIcon sound = MainFrame.getIcon("/jrm/resicons/icons/sound.png");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String val;
            this.setBackground(AnywareRenderer.getBackground(row, column));
            if (value != null) {
                if (value instanceof EntityBase) {
                    EntityBase eb = (EntityBase)value;
                    val = eb.getBaseName();
                } else {
                    val = value.toString();
                }
            } else {
                val = null;
            }
            super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
            if (value instanceof Rom) {
                this.setIcon(this.romSmall);
            } else if (value instanceof Disk) {
                this.setIcon(this.drive);
            } else if (value instanceof Sample) {
                this.setIcon(this.sound);
            }
            this.setToolTipText(this.getText());
            return this;
        }
    }, new AlignedTableCellRenderer(11){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Long l;
            this.setBackground(AnywareRenderer.getBackground(row, column));
            String val = value != null ? (value instanceof Long ? ((l = (Long)value) > 0L ? value.toString() : null) : value.toString()) : null;
            return super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
        }
    }, new CodeTableCellRenderer(), new CodeTableCellRenderer(), new CodeTableCellRenderer(), new AlignedTableCellRenderer(10){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(AnywareRenderer.getBackground(row, column));
            super.getTableCellRendererComponent(table, value != null ? value.toString() : null, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getText());
            return this;
        }
    }, new AlignedTableCellRenderer(0){
        ImageIcon verified = MainFrame.getIcon("/jrm/resicons/icons/star.png");
        ImageIcon good = MainFrame.getIcon("/jrm/resicons/icons/tick.png");
        ImageIcon baddump = MainFrame.getIcon("/jrm/resicons/icons/delete.png");
        ImageIcon nodump = MainFrame.getIcon("/jrm/resicons/icons/error.png");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(AnywareRenderer.getBackground(row, column));
            super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            if (value instanceof Entity.Status) {
                Entity.Status s = (Entity.Status)value;
                switch (s) {
                    case verified: {
                        this.setIcon(this.verified);
                        break;
                    }
                    case good: {
                        this.setIcon(this.good);
                        break;
                    }
                    case baddump: {
                        this.setIcon(this.baddump);
                        break;
                    }
                    case nodump: {
                        this.setIcon(this.nodump);
                    }
                }
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(value != null ? value.toString() : null);
            return this;
        }
    }};

    private static Color getBackground(int row, int col) {
        if (col % 2 == 0) {
            if (row % 2 == 0) {
                return Color.decode("0xDDDDEE");
            }
            return Color.decode("0xEEEEEE");
        }
        if (row % 2 == 0) {
            return Color.decode("0xEEEEFF");
        }
        return Color.decode("0xFFFFFF");
    }

    private AnywareRenderer() {
    }

    private static class CodeTableCellRenderer
    extends AlignedTableCellRenderer {
        public CodeTableCellRenderer() {
            super(11);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(AnywareRenderer.getBackground(row, column));
            super.getTableCellRendererComponent(table, value != null ? value.toString() : null, isSelected, hasFocus, row, column);
            this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
            return this;
        }
    }

    private static abstract class AlignedTableCellRenderer
    extends DefaultTableCellRenderer {
        public AlignedTableCellRenderer(int align) {
            this.setHorizontalAlignment(align);
        }
    }
}

