/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.util.Optional;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.ui.profile.data.AnywareListModel;
import jrm.ui.profile.data.MachineListRenderer;

public class MachineListModel
extends AnywareListModel<Machine> {
    MachineList machineList;

    public MachineListModel(MachineList machineList) {
        this.machineList = machineList;
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return MachineListRenderer.columnsRenderers;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return MachineListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public String getColumnTT(int columnIndex) {
        return MachineListRenderer.columns[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.machineList.getFilteredList().size();
    }

    @Override
    public int getColumnCount() {
        return MachineListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return MachineListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return MachineListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Machine machine = (Machine)this.machineList.getFilteredList().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return machine;
            }
            case 1: {
                return machine;
            }
            case 2: {
                return machine.description.toString();
            }
            case 3: {
                return String.format("%d/%d", machine.countHave(), machine.countAll());
            }
            case 4: {
                return Optional.ofNullable(machine.getCloneof()).map(cloneof -> this.machineList.containsName(cloneof) ? this.machineList.getByName(cloneof) : cloneof).orElse(null);
            }
            case 5: {
                return Optional.ofNullable(machine.getRomof()).filter(romof -> !romof.equals(machine.getCloneof())).map(romof -> this.machineList.containsName(romof) ? this.machineList.getByName(romof) : romof).orElse(null);
            }
            case 6: {
                return Optional.ofNullable(machine.getSampleof()).map(sampleof -> this.machineList.samplesets.containsName(sampleof) ? this.machineList.samplesets.getByName(sampleof) : sampleof).orElse(null);
            }
            case 7: {
                return machine.isSelected();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 7 && aValue instanceof Boolean) {
            Boolean b = (Boolean)aValue;
            Machine machine = (Machine)this.machineList.getFilteredList().get(rowIndex);
            machine.setSelected(b.booleanValue());
        }
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return MachineListRenderer.columnsRenderers[columnIndex];
    }

    @Override
    public void reset() {
        this.machineList.resetCache();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public MachineList getList() {
        return this.machineList;
    }

    @Override
    public void setFilter(Set<AnywareStatus> filter) {
        this.machineList.setFilterCache(filter);
        this.reset();
    }
}

