/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import jrm.locale.Messages;
import jrm.profile.manager.ProfileNFO;
import jrm.ui.profile.manager.FileTableModel;

public class FileTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel tableModel;
        if (column == 0 && (tableModel = table.getModel()) instanceof FileTableModel) {
            FileTableModel ftm = (FileTableModel)tableModel;
            ProfileNFO nfo = ftm.getNfoAt(row);
            super.getTableCellRendererComponent(table, nfo.getName(), isSelected, hasFocus, row, column);
            switch (nfo.getMame().getStatus()) {
                case UPTODATE: {
                    this.setForeground(Color.decode("0x00aa00"));
                    this.setToolTipText(String.format(Messages.getString((String)"FileTableCellRenderer.IsUpToDate"), nfo.getName()));
                    break;
                }
                case NEEDUPDATE: {
                    this.setForeground(Color.decode("0xcc8800"));
                    this.setToolTipText(String.format(Messages.getString((String)"FileTableCellRenderer.NeedUpdateFromMame"), nfo.getName()));
                    break;
                }
                case NOTFOUND: {
                    this.setForeground(Color.decode("0xcc0000"));
                    this.setToolTipText(String.format(Messages.getString((String)"FileTableCellRenderer.StatusUnknownMameNotFound"), nfo.getName()));
                    break;
                }
                default: {
                    this.setForeground(Color.black);
                    this.setToolTipText(this.getText());
                    break;
                }
            }
        } else {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(Color.black);
            if (column > 1) {
                this.setHorizontalAlignment(0);
            } else {
                this.setToolTipText(this.getText());
            }
        }
        this.setBackground(isSelected ? Color.decode("0xBBBBDD") : Color.white);
        return this;
    }
}

