/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import jrm.aui.progress.StatusHandler;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.report.FilterOptions;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.profile.report.ReportView;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;

public class ReportFrame
extends JDialog
implements StatusHandler {
    private final JLabel lblStatus = new JLabel("");
    private final ReportView view;
    private boolean needUpdate = false;

    public ReportFrame(final Session session, Window owner) throws HeadlessException {
        this.setTitle(Messages.getString((String)"ReportFrame.Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                session.getUser().getSettings().setProperty("ReportFrame.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)ReportFrame.this.getBounds())));
            }

            @Override
            public void windowOpened(WindowEvent e) {
                session.getReport().getHandler().filter(session.getReport().getHandler().getFilterOptions().toArray(new FilterOptions[0]));
            }
        });
        this.setTitle(Messages.getString((String)"ReportFrame.Title"));
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setIconImage(MainFrame.getIcon("/jrm/resicons/rom.png").getImage());
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{784, 0};
        gridBagLayout.rowHeights = new int[]{280, 24, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.view = new ReportView(session.getReport());
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 0;
        this.getContentPane().add((Component)this.view, gbcScrollPane);
        session.getReport().setStatusHandler((StatusHandler)this);
        GridBagConstraints gbcLblStatus = new GridBagConstraints();
        gbcLblStatus.ipadx = 2;
        gbcLblStatus.insets = new Insets(2, 2, 2, 2);
        gbcLblStatus.fill = 1;
        gbcLblStatus.gridx = 0;
        gbcLblStatus.gridy = 1;
        this.lblStatus.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)this.lblStatus, gbcLblStatus);
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex((String)session.getUser().getSettings().getProperty("ReportFrame.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)new Rectangle(10, 10, 800, 600)))))));
        }
        catch (DecoderException e1) {
            Log.err((String)e1.getMessage(), (Throwable)e1);
        }
    }

    public void setStatus(String text) {
        this.lblStatus.setText(text);
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
        if (this.isVisible()) {
            this.update();
        }
    }

    private void update() {
        if (this.needUpdate) {
            this.view.update();
            this.needUpdate = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.update();
        super.setVisible(b);
    }
}

