/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jrm.aui.status.StatusRendererFactory;
import jrm.misc.Log;
import jrm.profile.report.ContainerTZip;
import jrm.profile.report.ContainerUnknown;
import jrm.profile.report.ContainerUnneeded;
import jrm.profile.report.EntryAdd;
import jrm.profile.report.EntryMissing;
import jrm.profile.report.EntryMissingDuplicate;
import jrm.profile.report.EntryOK;
import jrm.profile.report.EntryUnneeded;
import jrm.profile.report.EntryWrongHash;
import jrm.profile.report.EntryWrongName;
import jrm.profile.report.Note;
import jrm.profile.report.RomSuspiciousCRC;
import jrm.profile.report.Subject;
import jrm.profile.report.SubjectSet;
import jrm.ui.MainFrame;
import jrm.ui.profile.report.ReportNode;

public class ReportTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            if (value instanceof ReportNode) {
                ReportNode rn = (ReportNode)value;
                value = rn.getReport();
            } else if (value instanceof ReportNode.SubjectNode) {
                ReportNode.SubjectNode sn = (ReportNode.SubjectNode)value;
                value = sn.getSubject();
            } else if (value instanceof ReportNode.SubjectNode.NoteNode) {
                ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)value;
                value = nn.getNote();
            }
            if (value instanceof Subject) {
                Subject s = (Subject)value;
                super.getTreeCellRendererComponent(tree, s.getDocument(), sel, expanded, leaf, row, hasFocus);
            } else if (value instanceof Note) {
                Note n = (Note)value;
                super.getTreeCellRendererComponent(tree, n.getDocument(), sel, expanded, leaf, row, hasFocus);
            } else if (value instanceof StatusRendererFactory) {
                StatusRendererFactory srf = (StatusRendererFactory)value;
                super.getTreeCellRendererComponent(tree, srf.getDocument(), sel, expanded, leaf, row, hasFocus);
            }
            this.setIcon(value, expanded, leaf);
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        return this;
    }

    private void setIcon(Object value, boolean expanded, boolean leaf) {
        SubjectSet ss;
        if (value instanceof RomSuspiciousCRC) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/information.png"));
        } else if (value instanceof ContainerUnknown) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/error.png"));
        } else if (value instanceof ContainerUnneeded) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/error.png"));
        } else if (value instanceof ContainerTZip) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/compress.png"));
        } else if (value instanceof EntryOK) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png"));
        } else if (value instanceof EntryAdd) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_blue.png"));
        } else if (value instanceof EntryMissingDuplicate) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_purple.png"));
        } else if (value instanceof EntryMissing) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_red.png"));
        } else if (value instanceof EntryUnneeded) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_black.png"));
        } else if (value instanceof EntryWrongHash) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_orange.png"));
        } else if (value instanceof EntryWrongName) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_pink.png"));
        } else if (!leaf) {
            this.setIcon(MainFrame.getIcon(this.getFolderIcon(value, expanded)));
        } else if (value instanceof SubjectSet && SubjectSet.Status.FOUND.equals((Object)(ss = (SubjectSet)value).getStatus())) {
            this.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png"));
        }
    }

    private String getFolderIcon(Object value, boolean expanded) {
        Object icon = "/jrm/resicons/folder";
        icon = (String)icon + (expanded ? "_open" : "_closed");
        if (value instanceof SubjectSet) {
            SubjectSet ss = (SubjectSet)value;
            switch (ss.getStatus()) {
                case FOUND: {
                    if (ss.hasNotes()) {
                        icon = (String)icon + (ss.isFixable() ? "_purple" : "_orange");
                        break;
                    }
                    icon = (String)icon + "_green";
                    break;
                }
                case CREATE: 
                case CREATEFULL: {
                    icon = (String)icon + (ss.isFixable() ? "_blue" : "_orange");
                    break;
                }
                case MISSING: {
                    icon = (String)icon + "_red";
                    break;
                }
                case UNNEEDED: {
                    icon = (String)icon + "_gray";
                    break;
                }
            }
        }
        icon = (String)icon + ".png";
        return icon;
    }
}

