/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.datasources;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import jrm.fullserver.security.CryptCredential;
import jrm.fullserver.security.Login;
import jrm.fullserver.security.UserCredential;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class AdminXMLResponse
extends XMLResponse {
    private static final String CAN_T_DO_THAT = "Can't do that!";
    private static final String ROLES = "Roles";
    private static final String PASSWORD = "Password";
    private static final String LOGIN = "Login";
    private static final String RESPONSE = "response";
    private static final String STATUS = "status";

    public AdminXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    public void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        if (this.request.getSession().getUser().isAdmin()) {
            try (Login login = new Login();){
                List rows = (List)login.queryHandler("SELECT * FROM USERS", new BeanListHandler(UserCredential.class), new Object[0]);
                this.writer.writeStartElement(RESPONSE);
                this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                this.fetchList(operation, rows, (row, idx) -> this.writeRecord((UserCredential)row));
                this.writer.writeEndElement();
            }
            catch (Exception e) {
                this.failure(e.getMessage());
            }
        } else {
            this.failure(CAN_T_DO_THAT);
        }
    }

    private void writeRecord(UserCredential user) throws XMLStreamException {
        this.writer.writeStartElement("record");
        this.writer.writeAttribute(LOGIN, user.getLogin());
        this.writer.writeAttribute(PASSWORD, user.getPassword());
        this.writer.writeAttribute(ROLES, user.getRoles());
        this.writer.writeEndElement();
    }

    @Override
    public void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (this.request.getSession().getUser().isAdmin()) {
            if (operation.hasData(LOGIN) && operation.hasData(PASSWORD)) {
                try (Login login = new Login();){
                    login.update("INSERT INTO USERS VALUES(?, ?, ?)", operation.getData(LOGIN), CryptCredential.hash(operation.getData(PASSWORD)), Optional.ofNullable(operation.getData(ROLES)).orElse("admin"));
                    this.fetchSingle(operation, login);
                }
                catch (Exception e) {
                    this.failure(e.getMessage());
                }
            } else {
                this.failure();
            }
        } else {
            this.failure(CAN_T_DO_THAT);
        }
    }

    @Override
    public void update(XMLRequest.Operation operation) throws XMLStreamException {
        if (this.request.getSession().getUser().isAdmin()) {
            if (operation.hasData(LOGIN) && operation.hasData(PASSWORD)) {
                try (Login login = new Login();){
                    login.update("UPDATE USERS SET PASSWORD=?, ROLES=? WHERE LOGIN=?", CryptCredential.hash(operation.getData(PASSWORD)), Optional.ofNullable(operation.getData(ROLES)).orElse("admin"), operation.getData(LOGIN));
                    this.fetchSingle(operation, login);
                }
                catch (Exception e) {
                    this.failure(e.getMessage());
                }
            } else {
                this.failure();
            }
        } else {
            this.failure(CAN_T_DO_THAT);
        }
    }

    @Override
    public void remove(XMLRequest.Operation operation) throws XMLStreamException {
        if (this.request.getSession().getUser().isAdmin()) {
            if (operation.hasData(LOGIN)) {
                try (Login login = new Login();){
                    if (0 != login.update("DELETE FROM USERS WHERE LOGIN=?", operation.getData(LOGIN))) {
                        this.writer.writeStartElement(RESPONSE);
                        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                        this.writer.writeStartElement("data");
                        this.writer.writeStartElement("record");
                        this.writer.writeAttribute(LOGIN, operation.getData(LOGIN));
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                    } else {
                        this.failure();
                    }
                }
                catch (Exception e) {
                    this.failure(e.getMessage());
                }
            } else {
                this.failure();
            }
        } else {
            this.failure(CAN_T_DO_THAT);
        }
    }

    private void fetchSingle(XMLRequest.Operation operation, Login login) throws SQLException, XMLStreamException {
        UserCredential user = (UserCredential)login.queryHandler("SELECT * FROM USERS WHERE LOGIN=?", new BeanHandler(UserCredential.class), new Object[]{operation.getData(LOGIN)});
        if (user != null) {
            this.writeSingle(user);
        } else {
            this.failure();
        }
    }

    private void writeSingle(UserCredential user) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writeRecord(user);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }
}

