/*
 * Decompiled with CFR 0.152.
 */
package jrm.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.misc.DefaultEnvironmentProperties;
import jrm.misc.Log;
import jrm.server.AbstractServer;
import jrm.server.SessionListener;
import jrm.server.handlers.SessionServlet;
import jrm.server.shared.WebSession;
import jrm.server.shared.handlers.ActionServlet;
import jrm.server.shared.handlers.DataSourceServlet;
import jrm.server.shared.handlers.DownloadServlet;
import jrm.server.shared.handlers.ImageServlet;
import jrm.server.shared.handlers.UploadServlet;
import org.apache.commons.daemon.DaemonContext;
import org.eclipse.jetty.ee9.servlet.FilterHolder;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class Server
extends AbstractServer {
    private static final int HTTP_PORT_DEFAULT = 8080;
    private static int httpPort = 8080;
    private static final String BIND_DEFAULT = "0.0.0.0";
    private static String bind = "0.0.0.0";
    private static int connLimit = 50;
    static final Map<String, WebSession> sessions = new HashMap<String, WebSession>();
    private static final DefaultEnvironmentProperties env = DefaultEnvironmentProperties.getInstance(Server.class);

    private static void initFromEnv(Args jArgs) {
        Optional.ofNullable(env.getProperty("jrm.server.clientpath", jArgs.clientPath)).ifPresent(v -> {
            jArgs.clientPath = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.workpath", jArgs.workPath)).ifPresent(v -> {
            jArgs.workPath = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.debug", Boolean.valueOf(jArgs.debug))).ifPresent(v -> {
            jArgs.debug = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.http", Integer.valueOf(jArgs.httpPort))).ifPresent(v -> {
            jArgs.httpPort = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.bind", jArgs.bind)).ifPresent(v -> {
            jArgs.bind = v;
        });
    }

    public static void parseArgs(String ... args) throws NumberFormatException, IOException, URISyntaxException {
        Args jArgs = new Args();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            Server.initFromEnv(jArgs);
            cmd.parse(args);
            debug = jArgs.debug;
            clientPath = jArgs.clientPath;
            bind = jArgs.bind;
            httpPort = jArgs.httpPort;
            Optional.ofNullable(jArgs.workPath).map(s -> s.replace("%HOMEPATH%", System.getProperty("user.home"))).ifPresent(s -> System.setProperty("jrommanager.dir", s));
            Locale.setDefault(Locale.US);
            System.setProperty("file.encoding", "UTF-8");
            Log.init((String)(Server.getLogPath() + "/Server.%g.log"), (boolean)debug, (int)0x100000, (int)5);
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            cmd.usage();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        try {
            Server.parseArgs(args);
            Server.initialize();
            Server.waitStop();
        }
        catch (InterruptedException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            System.exit(1);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public static void initialize() throws Exception {
        if (jettyserver == null) {
            jettyserver = new org.eclipse.jetty.server.Server();
            ServletContextHandler context = new ServletContextHandler(1);
            ResourceFactory resourceFactory = ResourceFactory.of((Container)context);
            context.setBaseResource(Server.getClientPath(resourceFactory, clientPath));
            context.setContextPath("/");
            context.addServlet(new ServletHolder("datasources", DataSourceServlet.class), "/datasources/*");
            context.addServlet(new ServletHolder("images", ImageServlet.class), "/images/*");
            context.addServlet(new ServletHolder("session", SessionServlet.class), "/session");
            context.addServlet(new ServletHolder("actions", ActionServlet.class), "/actions/*");
            context.addServlet(new ServletHolder("upload", UploadServlet.class), "/upload/*");
            context.addServlet(new ServletHolder("download", DownloadServlet.class), "/download/*");
            context.addFilter(new FilterHolder((request, response, chain) -> {
                if (request instanceof HttpServletRequest) {
                    HttpServletRequest httprequest = (HttpServletRequest)request;
                    if (response instanceof HttpServletResponse) {
                        HttpServletResponse httpresponse = (HttpServletResponse)response;
                        if (httprequest.getRequestURI().endsWith(".nocache.js")) {
                            httpresponse.setHeader("cache-control", "no-store");
                        } else if (!httprequest.getRequestURI().endsWith(".cache.js")) {
                            httpresponse.setHeader("cache-control", "public, max-age=0, must-revalidate");
                        }
                    }
                }
                chain.doFilter(request, response);
            }), "*.js", EnumSet.of(DispatcherType.REQUEST));
            context.addServlet(Server.holderStatic(), "/");
            context.getSessionHandler().setMaxInactiveInterval(300);
            context.getSessionHandler().addEventListener((EventListener)((Object)new SessionListener(false)));
            GzipHandler gh = Server.gzipHandler();
            gh.setHandler((Supplier)context);
            jettyserver.setHandler((Handler)gh);
            jettyserver.setStopAtShutdown(true);
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
            ServerConnector httpConnector = new ServerConnector(jettyserver, new ConnectionFactory[]{httpConnectionFactory});
            httpConnector.setPort(httpPort);
            httpConnector.setHost(bind);
            httpConnector.setName("HTTP");
            jettyserver.addConnector((Connector)httpConnector);
            jettyserver.addBean((Object)new ConnectionLimit(connLimit, jettyserver));
            jettyserver.start();
            Log.config((Object)"Start server");
            for (Connector connector : jettyserver.getConnectors()) {
                Log.config((Object)(((ServerConnector)connector).getName() + " with port on " + ((ServerConnector)connector).getPort() + " binded to " + ((ServerConnector)connector).getHost()));
            }
            Log.config((Object)("clientPath: " + clientPath));
            Log.config((Object)("workPath: " + String.valueOf(Server.getWorkPath())));
        } else {
            Log.err((Object)"Already initialized");
        }
    }

    public void init(DaemonContext context) throws Exception {
        Server.parseArgs(context.getArguments());
        Server.initialize();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() {
        try {
            Server.terminate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void windowsService(String[] args) throws Exception {
        Log.info(() -> "WINDOW SERVICE " + Stream.of(args).collect(Collectors.joining(" ")));
        String cmd = "start";
        if (args.length > 0) {
            cmd = args[0];
        }
        try {
            Server.parseArgs(Arrays.copyOfRange(args, 1, args.length));
            if ("start".equals(cmd)) {
                Server.windowsStart();
            } else {
                Server.windowsStop();
            }
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void windowsStart() throws Exception {
        Log.info((Object)"WIN START");
        Server.initialize();
        while (Server.isStopped()) {
            Class<Server> clazz = Server.class;
            // MONITORENTER : jrm.server.Server.class
            Server.class.wait(60000L);
            // MONITOREXIT : clazz
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void windowsStop() throws Exception {
        Log.info((Object)"WIN STOP");
        Server.terminate();
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            Server.class.notifyAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Parameters(separators=" =")
    public static class Args {
        @Parameter(names={"-c", "--client", "--clientPath"}, arity=1, description="Client path")
        private String clientPath = null;
        @Parameter(names={"-w", "--work", "--workpath"}, arity=1, description="Working path")
        private String workPath = null;
        @Parameter(names={"-d", "--debug"}, description="Activate debug mode")
        private boolean debug = false;
        @Parameter(names={"-p", "--http"}, arity=1, description="http port")
        private int httpPort = 8080;
        @Parameter(names={"-b", "--bind"}, arity=1, description="bind to address or host")
        private String bind = "0.0.0.0";
    }
}

