/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared;

import java.io.Closeable;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import jrm.batch.Compressor;
import jrm.batch.TrntChkReport;
import jrm.profile.report.Report;
import jrm.security.Session;
import jrm.server.shared.Worker;
import lombok.Generated;

public class WebSession
extends Session
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Map<String, WebSession> allSessions = new ConcurrentHashMap<String, WebSession>();
    private static boolean terminate = false;
    private BlockingDeque<String> lprMsg = new LinkedBlockingDeque<String>();
    private transient Worker worker = null;
    private Date lastAction = new Date();
    private transient Report tmpReport = null;
    private transient TrntChkReport tmpTCReport = null;
    private transient TreeMap<Integer, Path> cachedProfileList = null;
    private transient TreeMap<String, Compressor.FileResult> cachedCompressorList = new TreeMap();

    public Worker setWorker(Worker worker) {
        this.worker = worker;
        return this.worker;
    }

    public WebSession(String sessionId) {
        super(sessionId);
        allSessions.put(sessionId, this);
    }

    public WebSession(String sessionId, String user, String[] roles) {
        super(sessionId, user, roles);
        allSessions.put(sessionId, this);
    }

    @Override
    public void close() {
        if (this.lprMsg.isEmpty()) {
            this.lprMsg.add("");
        }
        allSessions.remove(this.getSessionId());
    }

    public static void closeAll() {
        terminate = true;
        allSessions.forEach((k, s) -> s.close());
    }

    public void putProfileList(Integer id, Path path) {
        this.cachedProfileList.put(id, path);
    }

    public void removeProfileList(Integer id) {
        this.cachedProfileList.remove(id);
    }

    public void newProfileList() {
        this.cachedProfileList = new TreeMap();
    }

    public Integer getLastProfileListKey() {
        return this.cachedProfileList != null && !this.cachedProfileList.isEmpty() ? this.cachedProfileList.lastKey() : 0;
    }

    public Path getProfileList(Integer id) {
        return this.cachedProfileList.get(id);
    }

    @Generated
    public static boolean isTerminate() {
        return terminate;
    }

    @Generated
    public BlockingDeque<String> getLprMsg() {
        return this.lprMsg;
    }

    @Generated
    public Worker getWorker() {
        return this.worker;
    }

    @Generated
    public Date getLastAction() {
        return this.lastAction;
    }

    @Generated
    public void setLastAction(Date lastAction) {
        this.lastAction = lastAction;
    }

    @Generated
    public Report getTmpReport() {
        return this.tmpReport;
    }

    @Generated
    public void setTmpReport(Report tmpReport) {
        this.tmpReport = tmpReport;
    }

    @Generated
    public TrntChkReport getTmpTCReport() {
        return this.tmpTCReport;
    }

    @Generated
    public void setTmpTCReport(TrntChkReport tmpTCReport) {
        this.tmpTCReport = tmpTCReport;
    }

    @Generated
    public TreeMap<String, Compressor.FileResult> getCachedCompressorList() {
        return this.cachedCompressorList;
    }
}

