/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import jrm.aui.progress.ProgressHandler;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.FindCmd;
import jrm.misc.Log;
import jrm.misc.ProfileSettings;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.profile.fix.Fix;
import jrm.profile.manager.Import;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.scan.Scan;
import jrm.profile.scan.ScanException;
import jrm.profile.scan.options.ScanAutomation;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import jrm.server.shared.Worker;
import jrm.server.shared.actions.ActionsMgr;
import jrm.server.shared.actions.CatVerActions;
import jrm.server.shared.actions.GlobalActions;
import jrm.server.shared.actions.NPlayersActions;
import jrm.server.shared.actions.ProgressActions;
import org.apache.commons.io.FileUtils;

public class ProfileActions
extends PathAbstractor {
    private static final String SUCCESS = "success";
    private static final String PARENT = "parent";
    private static final String PARAMS = "params";
    private final ActionsMgr ws;

    public ProfileActions(ActionsMgr ws) {
        super((Session)ws.getSession());
        this.ws = ws;
    }

    public void imprt(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            session.getWorker().progress = new ProgressActions(this.ws);
            session.getWorker().progress.canCancel(false);
            session.getWorker().progress.setProgress(session.getMsgs().getString("MainFrame.ImportingFromMame"), -1);
            try {
                JsonObject jsobj = jso.get(PARAMS).asObject();
                String filename = FindCmd.findMame();
                if (filename != null) {
                    boolean sl = jsobj.getBoolean("sl", false);
                    Import imprt = new Import((Session)session, new File(filename), sl, (ProgressHandler)session.getWorker().progress);
                    if (imprt.getFile() != null) {
                        this.doImport(session, jsobj, sl, imprt);
                    } else {
                        new GlobalActions(this.ws).warn("Could not import anything from Mame");
                    }
                } else {
                    new GlobalActions(this.ws).warn("Mame not found in system's search path");
                }
            }
            catch (BreakException jsobj) {
            }
            catch (IOException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
                new GlobalActions(this.ws).warn(e.getMessage());
            }
            finally {
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    private void doImport(WebSession session, JsonObject jsobj, boolean sl, Import imprt) throws SecurityException, IOException {
        File parent = this.getAbsolutePath(Optional.ofNullable(jsobj.get(PARENT)).filter(JsonValue::isString).map(JsonValue::asString).orElse(session.getUser().getSettings().getWorkPath().toString())).toFile();
        File file = new File(parent, imprt.getFile().getName());
        FileUtils.copyFile((File)imprt.getFile(), (File)file);
        ProfileNFO pnfo = ProfileNFO.load((Session)session, (File)file);
        pnfo.getMame().set(imprt.getOrgFile(), sl);
        if (imprt.getRomsFile() != null) {
            FileUtils.copyFileToDirectory((File)imprt.getRomsFile(), (File)parent);
            pnfo.getMame().setFileroms(new File(parent, imprt.getRomsFile().getName()));
            if (sl) {
                if (imprt.getSlFile() != null) {
                    FileUtils.copyFileToDirectory((File)imprt.getSlFile(), (File)parent);
                    pnfo.getMame().setFilesl(new File(parent, imprt.getSlFile().getName()));
                } else {
                    new GlobalActions(this.ws).warn("Could not import softwares list");
                }
            }
            pnfo.save((Session)session);
            this.imported(pnfo.getFile());
        } else {
            new GlobalActions(this.ws).warn("Could not import roms list");
            Files.delete(file.toPath());
        }
    }

    public void load(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            if (session.getCurrProfile() != null) {
                session.getCurrProfile().saveSettings();
            }
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                JsonObject jsobj = jso.get(PARAMS).asObject();
                Path file = this.getAbsolutePath(jsobj.getString(PARENT, null)).resolve(jsobj.getString("file", null));
                session.setCurrProfile(Profile.load((Session)session, (File)file.toFile(), (ProgressHandler)session.getWorker().progress));
                if (session.getCurrProfile() != null) {
                    session.getCurrProfile().getNfo().save((Session)session);
                    session.getReport().setProfile(session.getCurrProfile());
                    this.loaded(session.getCurrProfile());
                    new CatVerActions(this.ws).loaded(session.getCurrProfile());
                    new NPlayersActions(this.ws).loaded(session.getCurrProfile());
                }
            }
            catch (BreakException breakException) {
            }
            finally {
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    public void importSettings(JsonObject jso) {
        JsonValue jsv;
        WebSession session = this.ws.getSession();
        if (session.getCurrProfile() != null && (jsv = jso.get(PARAMS).asObject().get("path")) != null && !jsv.isNull()) {
            session.getCurrProfile().loadSettings(PathAbstractor.getAbsolutePath((Session)session, (String)jsv.asString()).toFile());
            session.getCurrProfile().loadCatVer(null);
            session.getCurrProfile().loadNPlayers(null);
            this.loaded(session.getCurrProfile());
            new CatVerActions(this.ws).loaded(session.getCurrProfile());
            new NPlayersActions(this.ws).loaded(session.getCurrProfile());
        }
    }

    public void exportSettings(JsonObject jso) {
        JsonValue jsv;
        WebSession session = this.ws.getSession();
        if (session.getCurrProfile() != null && (jsv = jso.get(PARAMS).asObject().get("path")) != null && !jsv.isNull()) {
            session.getCurrProfile().saveSettings(PathAbstractor.getAbsolutePath((Session)session, (String)jsv.asString()).toFile());
        }
    }

    public void scan(JsonObject jso, boolean automate) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                session.setCurrScan(new Scan(session.getCurrProfile(), (ProgressHandler)session.getWorker().progress));
            }
            catch (BreakException breakException) {
            }
            catch (ScanException ex) {
                session.getWorker().progress.addError(ex.getMessage());
            }
            session.getWorker().progress.close();
            session.getWorker().progress = null;
            session.setLastAction(new Date());
            ScanAutomation automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan));
            this.scanned(session.getCurrScan(), automation.hasReport());
            if (automate && session.getCurrScan() != null && session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() > 0 && automation.hasFix()) {
                this.fix(jso);
            }
        })).start();
    }

    public void fix(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                if (session.getCurrProfile().hasPropsChanged()) {
                    boolean needfix;
                    session.setCurrScan(new Scan(session.getCurrProfile(), (ProgressHandler)session.getWorker().progress));
                    boolean bl = needfix = session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() > 0;
                    if (!needfix) {
                        return;
                    }
                }
                Fix fix = new Fix(session.getCurrProfile(), session.getCurrScan(), (ProgressHandler)session.getWorker().progress);
                this.fixed(fix);
            }
            catch (ScanException ex) {
                session.getWorker().progress.addError(ex.getMessage());
            }
            finally {
                ScanAutomation automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan));
                if (automation.hasScanAgain()) {
                    this.scan(jso, false);
                }
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    public void setProperty(JsonObject jso) {
        String profile = jso.getString("profile", null);
        ProfileSettings settings = profile != null ? new ProfileSettings() : this.ws.getSession().getCurrProfile().getSettings();
        JsonObject pjso = jso.get(PARAMS).asObject();
        for (JsonObject.Member m : pjso) {
            JsonValue value = m.getValue();
            if (value.isBoolean()) {
                settings.setProperty(m.getName(), value.asBoolean());
                continue;
            }
            if (value.isNumber()) {
                settings.setProperty(m.getName(), value.asInt());
                continue;
            }
            if (value.isString()) {
                settings.setProperty(m.getName(), value.asString());
                continue;
            }
            settings.setProperty(m.getName(), value.toString());
        }
        try {
            if (profile != null) {
                this.ws.getSession().getUser().getSettings().saveProfileSettings(this.getAbsolutePath(profile).toFile(), settings);
            } else {
                this.ws.getSession().getCurrProfile().saveSettings();
            }
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void loaded(Profile profile) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Profile.loaded");
                JsonObject params = new JsonObject();
                params.add(SUCCESS, profile != null);
                if (profile != null) {
                    params.add("name", profile.getName());
                    if (profile.getSystems() != null) {
                        JsonArray systems = new JsonArray();
                        profile.getSystems().forEach(s -> {
                            JsonObject systm = new JsonObject();
                            systm.add("name", s.toString());
                            systm.add("selected", s.isSelected(profile));
                            systm.add("property", s.getPropertyName());
                            systm.add("type", s.getType().toString());
                            systems.add((JsonValue)systm);
                        });
                        params.add("systems", (JsonValue)systems);
                    }
                    JsonArray sources = new JsonArray();
                    profile.getSources().forEach(s -> {
                        JsonObject source = new JsonObject();
                        source.add("name", s.toString());
                        source.add("selected", s.isSelected(profile));
                        source.add("property", s.getPropertyName());
                        sources.add((JsonValue)source);
                    });
                    params.add("sources", (JsonValue)sources);
                    JsonArray years = new JsonArray();
                    ArrayList<String> arrlst = new ArrayList<String>(profile.getYears());
                    arrlst.sort(String::compareTo);
                    arrlst.forEach(arg_0 -> ((JsonArray)years).add(arg_0));
                    params.add("years", (JsonValue)years);
                    if (profile.getSettings() != null) {
                        params.add("settings", (JsonValue)profile.getSettings().asJSO());
                    }
                }
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void scanned(Scan scan, boolean hasReport) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Profile.scanned");
                JsonObject params = new JsonObject();
                params.add(SUCCESS, scan != null);
                if (scan != null) {
                    params.add("actions", scan.actions.stream().mapToInt(Collection::size).sum());
                    params.add("report", hasReport);
                }
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void fixed(Fix fix) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Profile.fixed");
                JsonObject params = new JsonObject();
                params.add(SUCCESS, fix != null);
                if (fix != null) {
                    params.add("actions", fix.getActionsRemain());
                }
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void imported(File file) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Profile.imported");
                JsonObject params = new JsonObject();
                params.add("path", file.getPath());
                params.add(PARENT, file.getParent());
                params.add("name", file.getName());
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

