/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.TorrentChecker;
import jrm.io.torrent.options.TrntChkMode;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import jrm.server.shared.Worker;
import jrm.server.shared.actions.ActionsMgr;
import jrm.server.shared.actions.ProgressActions;

public class TrntChkActions {
    private final ActionsMgr ws;

    public TrntChkActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void start(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            final WebSession session = this.ws.getSession();
            TrntChkMode mode = TrntChkMode.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_mode));
            EnumSet<TorrentChecker.Options> opts = EnumSet.noneOf(TorrentChecker.Options.class);
            if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_unknown_files, Boolean.class))) {
                opts.add(TorrentChecker.Options.REMOVEUNKNOWNFILES);
            }
            if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_wrong_sized_files, Boolean.class))) {
                opts.add(TorrentChecker.Options.REMOVEWRONGSIZEDFILES);
            }
            if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_detect_archived_folders, Boolean.class))) {
                opts.add(TorrentChecker.Options.DETECTARCHIVEDFOLDERS);
            }
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                final SDRList sdrl = SrcDstResult.fromJSON((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
                new TorrentChecker((Session)session, (ProgressHandler)session.getWorker().progress, (List)sdrl, mode, new ResultColUpdater(){

                    public void updateResult(int row, String result) {
                        ((SrcDstResult)sdrl.get(row)).setResult(result);
                        session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                        session.getUser().getSettings().saveSettings();
                        TrntChkActions.this.updateResult(row, result);
                    }

                    public void clearResults() {
                        sdrl.forEach(sdr -> sdr.setResult(""));
                        session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                        session.getUser().getSettings().saveSettings();
                        TrntChkActions.this.clearResults();
                    }
                }, opts);
            }
            catch (BreakException breakException) {
            }
            finally {
                this.end();
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    void updateResult(int row, String result) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "TrntChk.updateResult");
                JsonObject params = new JsonObject();
                params.add("row", row);
                params.add("result", result);
                rjso.add("params", (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void clearResults() {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "TrntChk.clearResults");
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void end() {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "TrntChk.end");
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

