/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.misc.Log;
import jrm.profile.data.AnywareList;
import jrm.profile.data.MachineList;
import jrm.profile.data.MachineListList;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class AnywareListListXMLResponse
extends XMLResponse {
    private static final String STATUS = "status";

    public AnywareListListXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement("response");
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        Set lstatus = operation.hasData(STATUS) ? Stream.of(operation.getData(STATUS).split(",")).collect(Collectors.toSet()) : null;
        boolean reset = Boolean.parseBoolean(operation.getData("reset"));
        MachineListList mll = this.request.session.getCurrProfile().getMachineListList();
        if (mll != null) {
            if (reset) {
                mll.resetCache();
            }
            ArrayList<AnywareList> fll = new ArrayList<AnywareList>();
            for (int i2 = 0; i2 < mll.count(); ++i2) {
                AnywareList l = mll.getObject(i2);
                if (lstatus != null && !lstatus.contains(l.getStatus().toString())) continue;
                fll.add(l);
            }
            this.fetchList(operation, fll, (list, i) -> this.writeRecord(mll, (AnywareList<?>)list, i));
        }
        this.writer.writeEndElement();
    }

    private void writeRecord(MachineListList mll, AnywareList<?> list, int i) {
        try {
            this.writer.writeElement("record", new SimpleAttribute[]{new SimpleAttribute(STATUS, (Object)list.getStatus()), new SimpleAttribute("name", (Object)(list instanceof MachineList ? "*" : list.getBaseName())), new SimpleAttribute("description", (Object)mll.getDescription(i)), new SimpleAttribute("have", (Object)mll.getHaveTot(i))});
        }
        catch (XMLStreamException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

