/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.misc.EnumWithDefault;
import jrm.misc.SettingsEnum;
import jrm.server.shared.datasources.SDRXMLResponse;
import jrm.server.shared.datasources.XMLRequest;

public class BatchTrntChkSDRXMLResponse
extends SDRXMLResponse {
    public BatchTrntChkSDRXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        SDRList sdrl = SrcDstResult.fromJSON((String)this.request.getSession().getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
        this.needSave((SDRList<SrcDstResult>)sdrl, SettingsEnum.trntchk_sdr);
        this.writeResponse(operation, (SDRList<SrcDstResult>)sdrl);
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("src")) {
            SDRList sdrl = SrcDstResult.fromJSON((String)this.request.getSession().getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
            this.needSave((SDRList<SrcDstResult>)sdrl, SettingsEnum.trntchk_sdr);
            SrcDstResult sdr = new SrcDstResult(operation.getData("src"));
            Optional<SrcDstResult> candidate = sdrl.stream().filter(s -> s.getSrc().equals(operation.getData("src"))).findAny();
            if (!candidate.isPresent()) {
                sdrl.add((Object)sdr);
                this.request.getSession().getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                this.request.getSession().getUser().getSettings().saveSettings();
                this.writeResponseSingle((AbstractSrcDstResult)sdr);
            } else {
                this.failure("Entry already exists");
            }
        } else {
            this.failure("Src is missing in request");
        }
    }

    @Override
    protected void update(XMLRequest.Operation operation) throws XMLStreamException {
        if (!operation.hasData("id")) {
            this.failure("Src is missing in request");
            return;
        }
        SDRList sdrl = SrcDstResult.fromJSON((String)this.request.getSession().getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
        this.needSave((SDRList<SrcDstResult>)sdrl, SettingsEnum.trntchk_sdr);
        Optional<SrcDstResult> candidate = sdrl.stream().filter(sdr -> sdr.getId().equals(operation.getData("id"))).findFirst();
        if (!candidate.isPresent()) {
            this.failure("not in list");
            return;
        }
        if (!(operation.hasData("src") || operation.hasData("dst") || operation.hasData("selected"))) {
            this.failure("field to update is missing in request");
            return;
        }
        AbstractSrcDstResult sdr2 = (AbstractSrcDstResult)candidate.get();
        if (operation.hasData("src")) {
            sdr2.setSrc(operation.getData("src"));
        }
        if (operation.hasData("dst")) {
            sdr2.setDst(operation.getData("dst"));
        }
        if (operation.hasData("selected")) {
            sdr2.setSelected(Boolean.parseBoolean(operation.getData("selected")));
        }
        this.request.getSession().getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
        this.request.getSession().getUser().getSettings().saveSettings();
        this.writeResponseSingle(sdr2);
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("id")) {
            SDRList sdrl = SrcDstResult.fromJSON((String)this.request.getSession().getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
            this.needSave((SDRList<SrcDstResult>)sdrl, SettingsEnum.trntchk_sdr);
            Optional<SrcDstResult> candidate = sdrl.stream().filter(sdr -> sdr.getId().equals(operation.getData("id"))).findFirst();
            if (candidate.isPresent()) {
                AbstractSrcDstResult sdr2 = (AbstractSrcDstResult)candidate.get();
                sdrl.remove((Object)sdr2);
                this.request.getSession().getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                this.request.getSession().getUser().getSettings().saveSettings();
                this.writeResponseKey(sdr2);
            } else {
                this.failure("not in the list");
            }
        } else {
            this.failure("Src is missing in request");
        }
    }
}

