/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class RemoteRootChooserXMLResponse
extends XMLResponse {
    private static final String WORK = "%work";

    public RemoteRootChooserXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        Map<String, Path> paths = this.getPaths(operation);
        this.writer.writeStartElement("response");
        this.writer.writeElement("status", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("endRow", (CharSequence)Long.toString((long)paths.size() - 1L), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Long.toString(paths.size()), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        for (Map.Entry<String, Path> root : paths.entrySet()) {
            this.writer.writeElement("record", new SimpleAttribute[]{new SimpleAttribute("Name", (Object)root.getKey()), new SimpleAttribute("Path", (Object)root.getValue())});
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    protected Map<String, Path> getPaths(XMLRequest.Operation operation) {
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        if (this.request.session.isServer() && this.request.session.isMultiuser()) {
            switch (operation.getData("context")) {
                case "listSrcDir": 
                case "importDat": 
                case "addDatSrc": 
                case "addDat": 
                case "tfSrcDir": 
                case "tfDstDat": {
                    paths.put("Work", Paths.get(WORK, new String[0]));
                    paths.put("Shared", Paths.get("%shared", new String[0]));
                    break;
                }
                case "importSettings": 
                case "exportSettings": {
                    paths.put("Presets", Paths.get("%presets", new String[0]));
                    break;
                }
                default: {
                    paths.put("Work", Paths.get(WORK, new String[0]));
                }
            }
            return paths;
        }
        paths.put("Work", Paths.get(WORK, new String[0]));
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            try {
                if (!Files.isDirectory(root, new LinkOption[0]) || !Files.exists(root, new LinkOption[0])) continue;
                paths.put((root.getFileName() != null ? root.getFileName() : root).toString(), root);
            }
            catch (Exception exception) {}
        }
        return paths;
    }
}

